/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.androidapi;

import com.android.tools.r8.androidapi.AndroidApiForHashingReference;
import com.android.tools.r8.androidapi.AndroidApiLevelDatabase;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.structural.DefaultHashingVisitor;
import com.android.tools.r8.utils.structural.HasherWrapper;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AndroidApiLevelHashingDatabaseImpl
implements AndroidApiLevelDatabase {
    private final Int2ReferenceMap<AndroidApiLevel> lookupNonAmbiguousCache = new Int2ReferenceOpenHashMap<AndroidApiLevel>();
    private final Map<String, AndroidApiLevel> ambiguousHashesWithApiLevel = new HashMap<String, AndroidApiLevel>();
    private final Map<DexReference, AndroidApiLevel> ambiguousCache = new IdentityHashMap<DexReference, AndroidApiLevel>();

    public static HasherWrapper getDefaultHasher() {
        return HasherWrapper.murmur3128Hasher();
    }

    public AndroidApiLevelHashingDatabaseImpl(List<AndroidApiForHashingReference> predefinedApiTypeLookup) {
        this.loadData();
        predefinedApiTypeLookup.forEach(predefinedApiReference -> {
            int hashCode = predefinedApiReference.getReference().hashCode();
            if (!this.lookupNonAmbiguousCache.containsKey(hashCode)) {
                this.lookupNonAmbiguousCache.put(hashCode, (AndroidApiLevel)null);
                this.ambiguousCache.put(predefinedApiReference.getReference(), predefinedApiReference.getApiLevel());
            }
        });
        assert (predefinedApiTypeLookup.stream().allMatch(added -> added.getApiLevel().isEqualTo(this.lookupApiLevel(added.getReference()))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadData() {
        List<String> ambiguous;
        byte[] apiLevels;
        int[] hashIndices;
        block30: {
            try {
                InputStream indicesInputStream = this.getClass().getClassLoader().getResourceAsStream("api_database/api_database_hash_lookup.ser");
                Throwable throwable = null;
                try {
                    Throwable throwable2;
                    ObjectInputStream indicesObjectStream;
                    block29: {
                        indicesObjectStream = new ObjectInputStream(indicesInputStream);
                        throwable2 = null;
                        try {
                            InputStream apiInputStream = this.getClass().getClassLoader().getResourceAsStream("api_database/api_database_api_level.ser");
                            Throwable throwable3 = null;
                            try {
                                Throwable throwable4;
                                ObjectInputStream apiObjectStream;
                                block28: {
                                    apiObjectStream = new ObjectInputStream(apiInputStream);
                                    throwable4 = null;
                                    try {
                                        InputStream ambiguousInputStream = this.getClass().getClassLoader().getResourceAsStream("api_database/api_database_ambiguous.txt");
                                        Throwable throwable5 = null;
                                        try {
                                            hashIndices = (int[])indicesObjectStream.readObject();
                                            apiLevels = (byte[])apiObjectStream.readObject();
                                            ambiguous = new BufferedReader(new InputStreamReader(ambiguousInputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                                            if (ambiguousInputStream == null) break block28;
                                        }
                                        catch (Throwable throwable6) {
                                            try {
                                                throwable5 = throwable6;
                                                throw throwable6;
                                            }
                                            catch (Throwable throwable7) {
                                                if (ambiguousInputStream != null) {
                                                    AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable5, ambiguousInputStream);
                                                }
                                                throw throwable7;
                                            }
                                        }
                                        AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable5, ambiguousInputStream);
                                    }
                                    catch (Throwable throwable8) {
                                        try {
                                            throwable4 = throwable8;
                                            throw throwable8;
                                        }
                                        catch (Throwable throwable9) {
                                            AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable4, apiObjectStream);
                                            throw throwable9;
                                        }
                                    }
                                }
                                AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable4, apiObjectStream);
                                if (apiInputStream == null) break block29;
                            }
                            catch (Throwable throwable10) {
                                try {
                                    throwable3 = throwable10;
                                    throw throwable10;
                                }
                                catch (Throwable throwable11) {
                                    if (apiInputStream != null) {
                                        AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable3, apiInputStream);
                                    }
                                    throw throwable11;
                                }
                            }
                            AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable3, apiInputStream);
                        }
                        catch (Throwable throwable12) {
                            try {
                                throwable2 = throwable12;
                                throw throwable12;
                            }
                            catch (Throwable throwable13) {
                                AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable2, indicesObjectStream);
                                throw throwable13;
                            }
                        }
                    }
                    AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable2, indicesObjectStream);
                    if (indicesInputStream == null) break block30;
                }
                catch (Throwable throwable14) {
                    try {
                        throwable = throwable14;
                        throw throwable14;
                    }
                    catch (Throwable throwable15) {
                        if (indicesInputStream != null) {
                            AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable, indicesInputStream);
                        }
                        throw throwable15;
                    }
                }
                AndroidApiLevelHashingDatabaseImpl.$closeResource(throwable, indicesInputStream);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Could not build api database");
            }
        }
        assert (hashIndices.length == apiLevels.length);
        int i = 0;
        while (true) {
            if (i >= hashIndices.length) {
                ambiguous.forEach(this::parseAmbiguous);
                return;
            }
            byte apiLevel = apiLevels[i];
            this.lookupNonAmbiguousCache.put(hashIndices[i], apiLevel == -1 ? null : AndroidApiLevel.getAndroidApiLevel(apiLevel));
            ++i;
        }
    }

    private void parseAmbiguous(String ambiguous) {
        String[] split = ambiguous.split(":");
        if (split.length != 2) {
            throw new CompilationError("Expected two entries in ambiguous map");
        }
        this.ambiguousHashesWithApiLevel.put(split[0], AndroidApiLevel.getAndroidApiLevel(Integer.parseInt(split[1])));
    }

    private AndroidApiLevel lookupApiLevel(DexReference reference) {
        AndroidApiLevel result = this.lookupNonAmbiguousCache.getOrDefault(reference.hashCode(), AndroidApiLevel.ANDROID_PLATFORM);
        if (result != null) {
            return result == AndroidApiLevel.ANDROID_PLATFORM ? null : result;
        }
        return this.ambiguousCache.computeIfAbsent(reference, ignored -> {
            HasherWrapper defaultHasher = AndroidApiLevelHashingDatabaseImpl.getDefaultHasher();
            reference.accept(type -> DefaultHashingVisitor.run(type, defaultHasher, DexType::acceptHashing), field -> DefaultHashingVisitor.run(field, defaultHasher, StructuralItem::acceptHashing), method -> DefaultHashingVisitor.run(method, defaultHasher, StructuralItem::acceptHashing));
            String existingHash = defaultHasher.hash().toString();
            AndroidApiLevel androidApiLevel = this.ambiguousHashesWithApiLevel.get(existingHash);
            if (androidApiLevel == null) {
                throw new CompilationError("Failed to find api level for reference: " + reference.toSourceString() + " with hash value: " + existingHash);
            }
            return androidApiLevel;
        });
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @Override
    public AndroidApiLevel getTypeApiLevel(DexType type) {
        return this.lookupApiLevel(type);
    }

    @Override
    public AndroidApiLevel getMethodApiLevel(DexMethod method) {
        return this.lookupApiLevel(method);
    }

    @Override
    public AndroidApiLevel getFieldApiLevel(DexField field) {
        return this.lookupApiLevel(field);
    }
}

