/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.androidapi;

import com.android.tools.r8.androidapi.AndroidApiForHashingReference;
import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.AndroidApiLevelDatabase;
import com.android.tools.r8.androidapi.AndroidApiLevelDatabaseHelper;
import com.android.tools.r8.androidapi.AndroidApiLevelHashingDatabaseImpl;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.ConsumerUtils;
import java.util.List;
import java.util.function.BiConsumer;

public class AndroidApiReferenceLevelCache {
    private final AndroidApiLevelCompute apiLevelCompute;
    private final AndroidApiLevelDatabase androidApiLevelDatabase;
    private final AppView<?> appView;
    private final DexItemFactory factory;

    private AndroidApiReferenceLevelCache(AppView<?> appView, AndroidApiLevelCompute apiLevelCompute, List<AndroidApiForHashingReference> predefinedApiTypeLookupForHashing) {
        this.appView = appView;
        this.apiLevelCompute = apiLevelCompute;
        this.factory = appView.dexItemFactory();
        this.androidApiLevelDatabase = new AndroidApiLevelHashingDatabaseImpl(predefinedApiTypeLookupForHashing);
    }

    public static AndroidApiReferenceLevelCache create(AppView<?> appView, AndroidApiLevelCompute apiLevelCompute) {
        assert (appView.options().apiModelingOptions().enableApiCallerIdentification);
        ImmutableList.Builder builder = ImmutableList.builder();
        BiConsumer<DexReference, AndroidApiLevel> addItemToList = ConsumerUtils.andThen(AndroidApiForHashingReference::create, builder::add);
        AndroidApiLevelDatabaseHelper.visitAdditionalKnownApiReferences(appView.dexItemFactory(), addItemToList);
        appView.options().apiModelingOptions().visitMockedApiLevelsForReferences(appView.dexItemFactory(), addItemToList);
        return new AndroidApiReferenceLevelCache(appView, apiLevelCompute, (List<AndroidApiForHashingReference>)((Object)builder.build()));
    }

    public ComputedApiLevel lookupMax(DexReference reference, ComputedApiLevel minApiLevel, ComputedApiLevel unknownValue) {
        assert (!minApiLevel.isNotSetApiLevel());
        return this.lookup(reference, unknownValue).max(minApiLevel);
    }

    public ComputedApiLevel lookup(DexReference reference, ComputedApiLevel unknownValue) {
        DexType contextType = reference.getContextType();
        if (contextType.isArrayType()) {
            if (reference.isDexMethod() && reference.asDexMethod().match(this.factory.objectMembers.clone)) {
                return this.appView.computedMinApiLevel();
            }
            return this.lookup(contextType.toBaseType(this.factory), unknownValue);
        }
        if (contextType.isPrimitiveType() || contextType.isVoidType()) {
            return this.appView.computedMinApiLevel();
        }
        DexClass clazz = this.appView.definitionFor(contextType);
        if (clazz != null && clazz.isProgramClass()) {
            return this.appView.computedMinApiLevel();
        }
        if (reference.getContextType() == this.factory.objectType) {
            return this.appView.computedMinApiLevel();
        }
        if (this.appView.options().machineDesugaredLibrarySpecification.isSupported(reference)) {
            return this.appView.computedMinApiLevel();
        }
        if (reference.isDexMethod() && !reference.asDexMethod().isInstanceInitializer(this.factory) && this.factory.objectMembers.isObjectMember(reference.asDexMethod())) {
            AndroidApiLevel methodApiLevel = this.androidApiLevelDatabase.getMethodApiLevel(reference.asDexMethod());
            if (methodApiLevel != null) {
                return this.apiLevelCompute.of(methodApiLevel);
            }
            AndroidApiLevel typeApiLevel = this.androidApiLevelDatabase.getTypeApiLevel(reference.getContextType());
            return typeApiLevel == null ? ComputedApiLevel.unknown() : this.apiLevelCompute.of(typeApiLevel);
        }
        AndroidApiLevel foundApiLevel = reference.apply(this.androidApiLevelDatabase::getTypeApiLevel, this.androidApiLevelDatabase::getFieldApiLevel, this.androidApiLevelDatabase::getMethodApiLevel);
        return foundApiLevel == null ? unknownValue : this.apiLevelCompute.of(foundApiLevel.max(this.appView.options().getMinApiLevel()));
    }
}

