/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.bisect;

import com.android.tools.r8.bisect.BisectOptions;
import com.android.tools.r8.com.google.common.base.Charsets;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.hash.Hashing;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingLens;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BisectState {
    private final String signature;
    private final DexApplication badApp;
    private final List<DexProgramClass> sortedGoodClasses;
    private final Map<DexType, Integer> indexMap;
    private final Path stateFile;
    private List<Run> runs = new ArrayList<Run>();
    private Range nextRange = null;

    public BisectState(DexApplication goodApp, DexApplication badApp, Path stateFile) {
        this.badApp = badApp;
        this.stateFile = stateFile;
        this.signature = BisectState.makeSignature(goodApp);
        if (!this.signature.equals(BisectState.makeSignature(badApp))) {
            throw new CompilationError("Bisecting application classes do not match classes in reference APK");
        }
        this.sortedGoodClasses = ImmutableList.copyOf(BisectState.getSortedClasses(goodApp));
        ImmutableMap.Builder<DexType, Integer> builder = ImmutableMap.builder();
        for (int i = 0; i < this.sortedGoodClasses.size(); ++i) {
            builder.put(this.sortedGoodClasses.get((int)i).type, i);
        }
        this.indexMap = builder.build();
    }

    private DexProgramClass getGoodClass(DexProgramClass clazz) {
        Integer index = this.indexMap.get(clazz.type);
        if (index != null && !this.nextRange.contains(index)) {
            return this.sortedGoodClasses.get(index);
        }
        return null;
    }

    private Range getLastBadRange() {
        Range good = new Range(0, 0);
        for (int i = this.runs.size() - 1; i >= 0; --i) {
            Run run = this.runs.get(i);
            if (run.isBad()) {
                return run.range.sub(good);
            }
            good = good.add(run.range);
        }
        throw new Unreachable("Did not find any bad range in bisection state");
    }

    private boolean signatureMismatch(String appSignature) {
        return !this.signature.equals(appSignature);
    }

    private static String readSignature(BufferedReader reader) throws IOException {
        return reader.readLine();
    }

    private static List<DexProgramClass> getSortedClasses(DexApplication app) {
        ArrayList<DexProgramClass> classes = new ArrayList<DexProgramClass>(app.classes());
        classes.sort((a, b) -> a.type.compareToWithNamingLens(b.type, NamingLens.getIdentityLens()));
        return classes;
    }

    private static String makeSignature(DexApplication app) {
        List<DexProgramClass> classes = BisectState.getSortedClasses(app);
        StringBuilder builder = new StringBuilder();
        for (DexProgramClass clazz : classes) {
            builder.append(clazz.toString()).append(";");
        }
        return Hashing.sha256().hashString(builder.toString(), Charsets.UTF_8).toString();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read() throws IOException {
        ArrayList<String> data2;
        block12: {
            if (this.stateFile == null) {
                return;
            }
            if (!Files.exists(this.stateFile, new LinkOption[0])) {
                System.out.println("Assuming initial run for non-existent state file: " + this.stateFile);
                return;
            }
            data2 = new ArrayList<String>();
            BufferedReader reader = Files.newBufferedReader(this.stateFile);
            Throwable throwable = null;
            try {
                String run;
                if (!this.signature.equals(BisectState.readSignature(reader))) {
                    throw new CompilationError("Bisection state file does not match the reference build signature");
                }
                while ((run = reader.readLine()) != null) {
                    data2.add(run);
                }
                if (reader == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (reader != null) {
                        BisectState.$closeResource(throwable, reader);
                    }
                    throw throwable3;
                }
            }
            BisectState.$closeResource(throwable, reader);
        }
        if (data2.isEmpty()) {
            return;
        }
        this.runs = new ArrayList<Run>(data2.size());
        int i = 0;
        while (true) {
            if (i >= data2.size() - 1) {
                this.nextRange = new Range((String)data2.get(data2.size() - 1));
                return;
            }
            this.runs.add(new Run((String)data2.get(i)));
            ++i;
        }
    }

    public void setPreviousResult(BisectOptions.Result result) {
        if (this.nextRange == null) {
            throw new CompilationError("Invalid bisection state. Could not find information on previous runs.");
        }
        if (this.runs.size() == 0) {
            assert (this.nextRange.equals(new Range(0, 0)));
            if (result != BisectOptions.Result.GOOD) {
                throw new CompilationError("Expected good state for reference application run, got " + (Object)((Object)result));
            }
        }
        if (this.runs.size() == 1) {
            assert (this.nextRange.equals(new Range(0, this.indexMap.size())));
            if (result != BisectOptions.Result.BAD) {
                throw new CompilationError("Expected bad state for input application run, got " + (Object)((Object)result));
            }
        }
        this.runs.add(new Run(result, this.nextRange));
        System.out.println("Marked range " + this.nextRange + ": " + (Object)((Object)result));
        this.nextRange = null;
    }

    public void verifySignature(DexApplication application) {
        if (this.signatureMismatch(BisectState.makeSignature(application))) {
            throw new CompilationError("Bisection state file does not match the application signature");
        }
    }

    public DexProgramClass getFinalClass() {
        if (this.nextRange.size() == 1) {
            int index = this.nextRange.start;
            return (DexProgramClass)this.badApp.definitionFor(this.sortedGoodClasses.get((int)index).type);
        }
        return null;
    }

    public DexApplication bisect() {
        assert (this.nextRange == null);
        if (this.runs.isEmpty()) {
            this.nextRange = new Range(0, 0);
        } else if (this.runs.size() == 1) {
            this.nextRange = new Range(0, this.sortedGoodClasses.size());
        } else {
            Range badRange = this.getLastBadRange();
            if (badRange.isEmpty()) {
                throw new CompilationError("Bad range is empty. Cannot continue bisecting :-(");
            }
            if (badRange.size() == 1) {
                this.nextRange = badRange;
                return null;
            }
            System.out.println("Last bad range: " + badRange);
            this.nextRange = badRange.split();
        }
        System.out.println("Next bisection range: " + this.nextRange);
        int goodClasses = 0;
        int badClasses = 0;
        ArrayList<DexProgramClass> programClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : this.badApp.classes()) {
            DexProgramClass goodClass = this.getGoodClass(clazz);
            if (goodClass != null) {
                programClasses.add(goodClass);
                ++goodClasses;
                continue;
            }
            programClasses.add(clazz);
            assert (!this.nextRange.isEmpty());
            ++badClasses;
        }
        System.out.println("Class split is good: " + goodClasses + ", bad: " + badClasses);
        return ((DexApplication.Builder)this.badApp.builder().replaceProgramClasses(programClasses)).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write() throws IOException {
        if (this.stateFile == null) {
            return;
        }
        BufferedWriter writer = Files.newBufferedWriter(this.stateFile, new OpenOption[0]);
        Throwable throwable = null;
        try {
            writer.write(this.signature);
            writer.write("\n");
            for (Run run : this.runs) {
                run.write(writer);
                writer.write("\n");
            }
            this.nextRange.write(writer);
            writer.write("\n");
            writer.flush();
            if (writer == null) return;
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                if (writer == null) throw throwable3;
                BisectState.$closeResource(throwable, writer);
                throw throwable3;
            }
        }
        BisectState.$closeResource(throwable, writer);
    }

    private static class Run {
        final boolean good;
        final Range range;

        public Run(BisectOptions.Result result, Range range) {
            assert (result != BisectOptions.Result.UNKNOWN);
            this.good = result == BisectOptions.Result.GOOD;
            this.range = range;
        }

        public Run(String nonLastEntry) {
            int sep1 = nonLastEntry.indexOf(58);
            this.good = nonLastEntry.substring(0, sep1).trim().equals("good");
            String rangeEntry = nonLastEntry.substring(sep1 + 1).trim();
            this.range = new Range(rangeEntry);
        }

        public void write(Writer writer) throws IOException {
            writer.write(this.good ? "good" : "bad");
            writer.write(58);
            this.range.write(writer);
        }

        public boolean isBad() {
            return !this.good;
        }
    }

    private static class Range {
        final int start;
        final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
            assert (this.verify());
        }

        public Range(String range) {
            int sep = range.indexOf(32);
            this.start = Integer.parseInt(range.substring(0, sep).trim());
            this.end = Integer.parseInt(range.substring(sep + 1).trim());
            assert (this.verify());
        }

        private boolean verify() {
            return this.start <= this.end;
        }

        public void write(Writer writer) throws IOException {
            writer.write("" + this.start);
            writer.write(" ");
            writer.write("" + this.end);
        }

        public boolean isEmpty() {
            return this.start == this.end;
        }

        public int size() {
            return this.end - this.start;
        }

        public Range add(Range other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            assert (this.start == other.end || this.end == other.start);
            return new Range(Integer.min(this.start, other.start), Integer.max(this.end, other.end));
        }

        public Range sub(Range other) {
            if (other.isEmpty()) {
                return this;
            }
            assert (this.start <= other.start && other.end <= this.end);
            if (this.start == other.start) {
                return new Range(other.end, this.end);
            }
            assert (this.end == other.end);
            return new Range(this.start, other.start);
        }

        public Range split() {
            int length = this.size() / 2;
            return new Range(this.start, this.start + length);
        }

        public boolean contains(int index) {
            return this.start <= index && index < this.end;
        }

        public String toString() {
            return "[" + this.start + ";" + this.end + "]";
        }

        public boolean equals(Object other) {
            if (!(other instanceof Range)) {
                return false;
            }
            Range o = (Range)other;
            return this.start == o.start && this.end == o.end;
        }

        public int hashCode() {
            return 31 * this.start + this.end;
        }
    }
}

