/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.utils.structural.Equatable;
import com.android.tools.r8.utils.structural.HashCodeVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class CfVersion
implements StructuralItem<CfVersion> {
    public static final CfVersion V1_1 = new CfVersion(196653);
    public static final CfVersion V1_2 = new CfVersion(46);
    public static final CfVersion V1_3 = new CfVersion(47);
    public static final CfVersion V1_4 = new CfVersion(48);
    public static final CfVersion V1_5 = new CfVersion(49);
    public static final CfVersion V1_6 = new CfVersion(50);
    public static final CfVersion V1_7 = new CfVersion(51);
    public static final CfVersion V1_8 = new CfVersion(52);
    public static final CfVersion V9 = new CfVersion(53);
    public static final CfVersion V10 = new CfVersion(54);
    public static final CfVersion V11 = new CfVersion(55);
    public static final CfVersion V11_PREVIEW = new CfVersion(-65481);
    public static final CfVersion V12 = new CfVersion(56);
    public static final CfVersion V12_PREVIEW = new CfVersion(-65480);
    public static final CfVersion V13 = new CfVersion(57);
    public static final CfVersion V13_PREVIEW = new CfVersion(-65479);
    public static final CfVersion V14 = new CfVersion(58);
    public static final CfVersion V14_PREVIEW = new CfVersion(-65478);
    public static final CfVersion V15 = new CfVersion(59);
    public static final CfVersion V15_PREVIEW = new CfVersion(-65477);
    public static final CfVersion V16 = new CfVersion(60);
    public static final CfVersion V16_PREVIEW = new CfVersion(-65476);
    public static final CfVersion V17 = new CfVersion(61);
    public static final CfVersion V17_PREVIEW = new CfVersion(-65475);
    public static final CfVersion V18 = new CfVersion(62);
    public static final CfVersion V18_PREVIEW = new CfVersion(-65474);
    private static CfVersion[] versions = new CfVersion[]{V1_1, V1_2, V1_3, V1_4, V1_5, V1_6, V1_7, V1_8, V9, V10, V11, V12, V13, V14, V15, V16, V17, V18};
    private final int version;

    private CfVersion(int version) {
        this.version = version;
    }

    public static CfVersion fromRaw(int rawVersion) {
        return new CfVersion(rawVersion);
    }

    private static void specify(StructuralSpecification<CfVersion, ?> spec) {
        ((StructuralSpecification)spec.withInt(CfVersion::major)).withInt(CfVersion::minor);
    }

    public static Iterable<CfVersion> rangeInclusive(CfVersion from, CfVersion to) {
        assert (from.isLessThanOrEqualTo(to));
        assert (!from.isPreview()) : "This method does not handle preview versions";
        assert (!to.isPreview()) : "This method does not handle preview versions";
        return Arrays.stream(versions).filter(version -> version.isGreaterThanOrEqualTo(from)).filter(version -> version.isLessThanOrEqualTo(to)).collect(Collectors.toList());
    }

    public int major() {
        return this.version & 0xFFFF;
    }

    public int minor() {
        return this.version >>> 16;
    }

    public int raw() {
        return this.version;
    }

    public boolean isPreview() {
        return this.minor() == 65535;
    }

    @Override
    public CfVersion self() {
        return this;
    }

    @Override
    public StructuralMapping<CfVersion> getStructuralMapping() {
        return CfVersion::specify;
    }

    @Override
    public boolean equals(Object o) {
        return Equatable.equalsImpl(this, o);
    }

    @Override
    public int hashCode() {
        return HashCodeVisitor.run(this);
    }

    public String toString() {
        return this.minor() != 0 ? "" + this.major() + "." + this.minor() : "" + this.major();
    }
}

