/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfTypeInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import java.util.ListIterator;

public class CfConstClass
extends CfInstruction
implements CfTypeInstruction {
    private final DexType type;
    private final boolean ignoreCompatRules;

    public CfConstClass(DexType type) {
        this(type, false);
    }

    public CfConstClass(DexType type, boolean ignoreCompatRules) {
        assert (!type.isPrimitiveType());
        assert (!type.isVoidType());
        this.type = type;
        this.ignoreCompatRules = ignoreCompatRules;
    }

    private String getInternalName(GraphLens graphLens, NamingLens namingLens) {
        DexType rewrittenType = graphLens.lookupType(this.type);
        switch (rewrittenType.toShorty()) {
            case 'L': 
            case '[': {
                return namingLens.lookupInternalName(rewrittenType);
            }
        }
        throw new Unreachable("Unexpected type in const-class: " + rewrittenType);
    }

    public boolean ignoreCompatRules() {
        return this.ignoreCompatRules;
    }

    @Override
    public int getCompareToId() {
        return CfCompareHelper.CONST_CLASS_COMPARE_ID;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return this.type.acceptCompareTo(((CfConstClass)other).type, visitor);
    }

    @Override
    public CfTypeInstruction asTypeInstruction() {
        return this;
    }

    @Override
    public boolean isTypeInstruction() {
        return true;
    }

    @Override
    public DexType getType() {
        return this.type;
    }

    @Override
    public CfInstruction withType(DexType newType) {
        return new CfConstClass(newType);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitLdcInsn(Type.getObjectType(this.getInternalName(graphLens, namingLens)));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    void internalRegisterUse(UseRegistry<?> registry, DexClassAndMethod context, ListIterator<CfInstruction> iterator2) {
        registry.registerConstClass(this.type, iterator2, this.ignoreCompatRules());
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        builder.addConstClass(state.push((DexType)builder.appView.dexItemFactory().classType).register, this.type);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forConstClass(this.type, context);
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.push(dexItemFactory.classType);
    }
}

