/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfTypeInstruction;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicReference;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.ConstantDynamic;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import java.util.ListIterator;

public class CfConstDynamic
extends CfInstruction
implements CfTypeInstruction {
    private final ConstantDynamicReference reference;

    public CfConstDynamic(DexString name, DexType type, DexMethodHandle bootstrapMethod, Object[] bootstrapMethodArguments) {
        assert (name != null);
        assert (type != null);
        assert (bootstrapMethod != null);
        assert (bootstrapMethodArguments != null);
        assert (bootstrapMethodArguments.length == 0);
        this.reference = new ConstantDynamicReference(name, type, bootstrapMethod, bootstrapMethodArguments);
    }

    public static CfConstDynamic fromAsmConstantDynamic(ConstantDynamic insn, JarApplicationReader application, DexType clazz) {
        String constantName = insn.getName();
        String constantDescriptor = insn.getDescriptor();
        if (insn.getBootstrapMethodArgumentCount() > 0) {
            throw new CompilationError("Unsupported dynamic constant (has arguments to bootstrap method)");
        }
        if (insn.getBootstrapMethod().getTag() != 6) {
            throw new CompilationError("Unsupported dynamic constant (not invoke static)");
        }
        if (insn.getBootstrapMethod().getOwner().equals("java/lang/invoke/ConstantBootstraps")) {
            throw new CompilationError("Unsupported dynamic constant (runtime provided bootstrap method)");
        }
        if (application.getTypeFromName(insn.getBootstrapMethod().getOwner()) != clazz) {
            throw new CompilationError("Unsupported dynamic constant (different owner)");
        }
        DexMethodHandle bootstrapMethodHandle = DexMethodHandle.fromAsmHandle(insn.getBootstrapMethod(), application, clazz);
        if (!bootstrapMethodHandle.member.isDexMethod()) {
            throw new CompilationError("Unsupported dynamic constant (invalid method handle)");
        }
        DexMethod bootstrapMethod = bootstrapMethodHandle.asMethod();
        if (bootstrapMethod.getProto().returnType != application.getTypeFromDescriptor("[Z") && bootstrapMethod.getProto().returnType != application.getTypeFromDescriptor("Ljava/lang/Object;")) {
            throw new CompilationError("Unsupported dynamic constant (unsupported constant type)");
        }
        if (bootstrapMethod.getProto().getParameters().size() != 3) {
            throw new CompilationError("Unsupported dynamic constant (unsupported signature)");
        }
        if (bootstrapMethod.getProto().getParameters().get(0) != application.getFactory().lookupType) {
            throw new CompilationError("Unsupported dynamic constant (unexpected type of first argument to bootstrap method");
        }
        if (bootstrapMethod.getProto().getParameters().get(1) != application.getFactory().stringType) {
            throw new CompilationError("Unsupported dynamic constant (unexpected type of second argument to bootstrap method");
        }
        if (bootstrapMethod.getProto().getParameters().get(2) != application.getFactory().classType) {
            throw new CompilationError("Unsupported dynamic constant (unexpected type of third argument to bootstrap method");
        }
        return new CfConstDynamic(application.getString(constantName), application.getTypeFromDescriptor(constantDescriptor), bootstrapMethodHandle, new Object[0]);
    }

    @Override
    public CfConstDynamic asConstDynamic() {
        return this;
    }

    @Override
    public boolean isConstDynamic() {
        return true;
    }

    public ConstantDynamicReference getReference() {
        return this.reference;
    }

    public DexString getName() {
        return this.reference.getName();
    }

    public DexMethodHandle getBootstrapMethod() {
        return this.reference.getBootstrapMethod();
    }

    public Object[] getBootstrapMethodArguments() {
        return this.reference.getBootstrapMethodArguments();
    }

    @Override
    public int getCompareToId() {
        return CfCompareHelper.CONST_DYNAMIC_COMPARE_ID;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        int diff = this.getName().acceptCompareTo(((CfConstDynamic)other).getName(), visitor);
        if (diff != 0) {
            return diff;
        }
        diff = this.getType().acceptCompareTo(((CfConstDynamic)other).getType(), visitor);
        if (diff != 0) {
            return diff;
        }
        return this.getBootstrapMethod().acceptCompareTo(((CfConstDynamic)other).getBootstrapMethod(), visitor);
    }

    @Override
    public CfTypeInstruction asTypeInstruction() {
        return this;
    }

    @Override
    public boolean isTypeInstruction() {
        return true;
    }

    @Override
    public DexType getType() {
        return this.reference.getType();
    }

    @Override
    public CfInstruction withType(DexType newType) {
        throw new Unimplemented();
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        throw new CompilationError("Unsupported dynamic constant (not desugaring)");
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    void internalRegisterUse(UseRegistry<?> registry, DexClassAndMethod context, ListIterator<CfInstruction> iterator2) {
        registry.registerTypeReference(this.reference.getType());
        registry.registerMethodHandle(this.reference.getBootstrapMethod(), UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
        assert (this.reference.getBootstrapMethodArguments().length == 0);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        throw new CompilationError("Unsupported dynamic constant (not desugaring)");
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        throw new Unreachable();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.push(dexItemFactory.classType);
    }
}

