/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;

public class CfConstNumber
extends CfInstruction {
    private final long value;
    private final ValueType type;

    private static void specify(StructuralSpecification<CfConstNumber, ?> spec) {
        ((StructuralSpecification)spec.withLong(CfConstNumber::getRawValue)).withItem(CfConstNumber::getType);
    }

    public CfConstNumber(long value, ValueType type) {
        this.value = value;
        this.type = type;
    }

    public static boolean isNegativeZeroDouble(double value) {
        return Double.doubleToLongBits(value) == Double.doubleToLongBits(-0.0);
    }

    public static boolean isNegativeZeroFloat(float value) {
        return Float.floatToIntBits(value) == Float.floatToIntBits(-0.0f);
    }

    @Override
    public int getCompareToId() {
        return CfCompareHelper.CONST_NUMBER_COMPARE_ID;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return visitor.visit(this, (CfConstNumber)other, CfConstNumber::specify);
    }

    public ValueType getType() {
        return this.type;
    }

    public long getRawValue() {
        return this.value;
    }

    public int getIntValue() {
        assert (this.type == ValueType.INT);
        return (int)this.value;
    }

    public long getLongValue() {
        assert (this.type == ValueType.LONG);
        return this.value;
    }

    public float getFloatValue() {
        assert (this.type == ValueType.FLOAT);
        return Float.intBitsToFloat((int)this.value);
    }

    public double getDoubleValue() {
        assert (this.type == ValueType.DOUBLE);
        return Double.longBitsToDouble(this.value);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        switch (this.type) {
            case INT: {
                int value = this.getIntValue();
                if (-1 <= value && value <= 5) {
                    visitor.visitInsn(3 + value);
                    break;
                }
                if (-128 <= value && value <= 127) {
                    visitor.visitIntInsn(16, value);
                    break;
                }
                if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
                    visitor.visitIntInsn(17, value);
                    break;
                }
                visitor.visitLdcInsn(value);
                break;
            }
            case LONG: {
                long value = this.getLongValue();
                if (value == 0L || value == 1L) {
                    visitor.visitInsn(9 + (int)value);
                    break;
                }
                visitor.visitLdcInsn(value);
                break;
            }
            case FLOAT: {
                float value = this.getFloatValue();
                if (value == 0.0f || value == 1.0f || value == 2.0f) {
                    visitor.visitInsn(11 + (int)value);
                    if (!CfConstNumber.isNegativeZeroFloat(value)) break;
                    visitor.visitInsn(118);
                    break;
                }
                visitor.visitLdcInsn(Float.valueOf(value));
                break;
            }
            case DOUBLE: {
                double value = this.getDoubleValue();
                if (value == 0.0 || value == 1.0) {
                    visitor.visitInsn(14 + (int)value);
                    if (!CfConstNumber.isNegativeZeroDouble(value)) break;
                    visitor.visitInsn(119);
                    break;
                }
                visitor.visitLdcInsn(value);
                break;
            }
            default: {
                throw new Unreachable("Non supported type in cf backend: " + this.type);
            }
        }
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        builder.addConst(this.type.toPrimitiveType(), state.push((ValueType)this.type).register, this.value);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forConstInstruction();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.push(this.type.toPrimitiveType().toDexType(dexItemFactory));
    }
}

