/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.CfCodeStackMapValidatingException;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.utils.BiPredicateUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.collections.ImmutableDeque;
import com.android.tools.r8.utils.collections.ImmutableInt2ReferenceSortedMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

public class CfFrameVerificationHelper {
    private final CfFrame NO_FRAME;
    private final Deque<CfFrame.FrameType> throwStack;
    private CfFrame currentFrame;
    private final DexType context;
    private final Map<CfLabel, CfFrame> stateMap;
    private final BiPredicate<DexType, DexType> isJavaAssignable;
    private final DexItemFactory factory;
    private final List<CfTryCatch> tryCatchRanges;
    private final int maxStackHeight;
    private final Deque<CfTryCatch> currentCatchRanges;
    private final Set<CfLabel> tryCatchRangeLabels;

    public CfFrameVerificationHelper(DexType context, Map<CfLabel, CfFrame> stateMap, List<CfTryCatch> tryCatchRanges, BiPredicate<DexType, DexType> isJavaAssignable, DexItemFactory factory, int maxStackHeight) {
        this.currentFrame = this.NO_FRAME = new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)ImmutableInt2ReferenceSortedMap.builder().build(), ImmutableDeque.of(new CfFrame.FrameType[0]));
        this.currentCatchRanges = new ArrayDeque<CfTryCatch>();
        this.context = context;
        this.stateMap = stateMap;
        this.tryCatchRanges = tryCatchRanges;
        this.isJavaAssignable = isJavaAssignable;
        this.factory = factory;
        this.maxStackHeight = maxStackHeight;
        this.throwStack = ImmutableDeque.of(CfFrame.FrameType.initialized(factory.throwableType));
        this.tryCatchRangeLabels = Sets.newIdentityHashSet();
        for (CfTryCatch tryCatchRange : tryCatchRanges) {
            this.tryCatchRangeLabels.add(tryCatchRange.start);
            this.tryCatchRangeLabels.add(tryCatchRange.end);
        }
    }

    private void checkFrameIsSet() {
        if (this.currentFrame == this.NO_FRAME) {
            throw CfCodeStackMapValidatingException.error("Unexpected state change");
        }
    }

    private void setFrame(CfFrame frame) {
        assert (frame != this.NO_FRAME);
        this.currentFrame = new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)new Int2ReferenceAVLTreeMap<CfFrame.FrameType>(frame.getLocals()), (Deque<CfFrame.FrameType>)new ArrayDeque<CfFrame.FrameType>(frame.getStack()));
    }

    public static void checkIsAssignable(Int2ReferenceSortedMap<CfFrame.FrameType> sourceLocals, Deque<CfFrame.FrameType> sourceStack, Int2ReferenceSortedMap<CfFrame.FrameType> destLocals, Deque<CfFrame.FrameType> destStack, DexItemFactory factory, BiPredicate<DexType, DexType> isJavaAssignable) {
        CfFrameVerificationHelper.checkLocalsIsAssignable(sourceLocals, destLocals, factory, isJavaAssignable);
        CfFrameVerificationHelper.checkStackIsAssignable(sourceStack, destStack, factory, isJavaAssignable);
    }

    private static void checkLocalsIsAssignable(Int2ReferenceSortedMap<CfFrame.FrameType> sourceLocals, Int2ReferenceSortedMap<CfFrame.FrameType> destLocals, DexItemFactory factory, BiPredicate<DexType, DexType> isJavaAssignable) {
        int otherLocalsLastKey;
        int localsLastKey = sourceLocals.isEmpty() ? -1 : sourceLocals.lastIntKey();
        int n = otherLocalsLastKey = destLocals.isEmpty() ? -1 : destLocals.lastIntKey();
        if (localsLastKey < otherLocalsLastKey) {
            throw CfCodeStackMapValidatingException.error("Source locals " + MapUtils.toString(sourceLocals) + " have different local indices than " + MapUtils.toString(destLocals));
        }
        for (int i = 0; i < otherLocalsLastKey; ++i) {
            CfFrame.FrameType destinationType;
            CfFrame.FrameType sourceType = sourceLocals.containsKey(i) ? (CfFrame.FrameType)sourceLocals.get(i) : CfFrame.FrameType.top();
            CfFrame.FrameType frameType = destinationType = destLocals.containsKey(i) ? (CfFrame.FrameType)destLocals.get(i) : CfFrame.FrameType.top();
            if (CfFrameVerificationHelper.canBeAssigned(sourceType, destinationType, factory, isJavaAssignable)) continue;
            throw CfCodeStackMapValidatingException.error("Could not assign '" + MapUtils.toString(sourceLocals) + "' to '" + MapUtils.toString(destLocals) + "'. The local at index " + i + " with '" + sourceType + "' not being assignable to '" + destinationType + "'");
        }
    }

    private static void checkStackIsAssignable(Deque<CfFrame.FrameType> sourceStack, Deque<CfFrame.FrameType> destStack, DexItemFactory factory, BiPredicate<DexType, DexType> isJavaAssignable) {
        if (sourceStack.size() != destStack.size()) {
            throw CfCodeStackMapValidatingException.error("Source stack " + Arrays.toString(sourceStack.toArray()) + " and destination stack " + Arrays.toString(destStack.toArray()) + " is not the same size");
        }
        Iterator<CfFrame.FrameType> otherIterator = destStack.iterator();
        int i = 0;
        for (CfFrame.FrameType sourceType : sourceStack) {
            CfFrame.FrameType destinationType;
            if (!CfFrameVerificationHelper.canBeAssigned(sourceType, destinationType = otherIterator.next(), factory, isJavaAssignable)) {
                throw CfCodeStackMapValidatingException.error("Could not assign '" + Arrays.toString(sourceStack.toArray()) + "' to '" + Arrays.toString(destStack.toArray()) + "'. The stack value at index " + i + " (from bottom) with '" + sourceType + "' not being assignable to '" + destinationType + "'");
            }
            ++i;
        }
    }

    public static boolean canBeAssigned(CfFrame.FrameType source, CfFrame.FrameType target, DexItemFactory factory, BiPredicate<DexType, DexType> isJavaAssignable) {
        if (target.isTop()) {
            return true;
        }
        if (source.isTop()) {
            return false;
        }
        if (source.isWide() != target.isWide()) {
            return false;
        }
        if (target.isOneWord() || target.isTwoWord()) {
            return true;
        }
        if (source.isUninitializedThis() && target.isUninitializedThis()) {
            return true;
        }
        if (source.isUninitializedNew() && target.isUninitializedNew()) {
            DexType uninitializedNewTypeSource = source.getUninitializedNewType();
            DexType uninitializedNewTypeTarget = target.getUninitializedNewType();
            return uninitializedNewTypeSource == null || uninitializedNewTypeTarget == null || uninitializedNewTypeSource == uninitializedNewTypeTarget;
        }
        if (!source.isInitialized() && target.isInitialized() && target.getInitializedType() == factory.objectType) {
            return true;
        }
        if (source.isInitialized() && target.isInitialized()) {
            return isJavaAssignable.test(source.getInitializedType(), target.getInitializedType());
        }
        return false;
    }

    public DexItemFactory factory() {
        return this.factory;
    }

    public CfFrame.FrameType readLocal(int index, DexType expectedType) {
        this.checkFrameIsSet();
        CfFrame.FrameType frameType = (CfFrame.FrameType)this.currentFrame.getLocals().get(index);
        if (frameType == null) {
            throw CfCodeStackMapValidatingException.error("No local at index " + index);
        }
        this.checkIsAssignable(frameType, expectedType, BiPredicateUtils.or(this::isUninitializedThisAndTarget, this::isUninitializedNewAndTarget, this::isAssignableAndInitialized));
        return frameType;
    }

    public void storeLocal(int index, CfFrame.FrameType frameType) {
        this.checkFrameIsSet();
        this.currentFrame.getLocals().put(index, frameType);
    }

    public CfFrame.FrameType pop() {
        this.checkFrameIsSet();
        if (this.currentFrame.getStack().isEmpty()) {
            throw CfCodeStackMapValidatingException.error("Cannot pop() from an empty stack");
        }
        return this.currentFrame.getStack().removeLast();
    }

    public CfFrame.FrameType popInitialized(DexType expectedType) {
        return this.pop(expectedType, this::isAssignableAndInitialized);
    }

    public CfFrame.FrameType pop(DexType expectedType, BiPredicate<CfFrame.FrameType, DexType> isAssignable) {
        CfFrame.FrameType frameType = this.pop();
        this.checkIsAssignable(frameType, expectedType, isAssignable);
        return frameType;
    }

    public CfFrameVerificationHelper popAndDiscardInitialized(DexType expectedType) {
        this.checkFrameIsSet();
        this.popInitialized(expectedType);
        return this;
    }

    public CfFrameVerificationHelper popAndDiscardInitialized(DexType ... expectedTypes) {
        this.checkFrameIsSet();
        for (int i = expectedTypes.length - 1; i >= 0; --i) {
            this.popInitialized(expectedTypes[i]);
        }
        return this;
    }

    public CfFrame.FrameType pop(CfFrame.FrameType expectedType) {
        CfFrame.FrameType frameType = this.pop();
        this.checkIsAssignable(frameType, expectedType);
        return frameType;
    }

    public CfFrameVerificationHelper popAndDiscard(CfFrame.FrameType ... expectedTypes) {
        this.checkFrameIsSet();
        for (int i = expectedTypes.length - 1; i >= 0; --i) {
            this.pop(expectedTypes[i]);
        }
        return this;
    }

    public void popAndInitialize(DexType context, DexType methodHolder) {
        this.checkFrameIsSet();
        CfFrame.FrameType objectRef = this.pop(this.factory.objectType, BiPredicateUtils.or(this::isUninitializedThisAndTarget, this::isUninitializedNewAndTarget));
        CfFrame newFrame = this.currentFrame.markInstantiated(objectRef, objectRef.isUninitializedNew() ? methodHolder : context);
        this.setNoFrame();
        this.checkFrameAndSet(newFrame);
    }

    public CfFrameVerificationHelper push(CfFrame.FrameType type) {
        this.checkFrameIsSet();
        this.currentFrame.getStack().addLast(type);
        if (this.currentFrame.computeStackSize() > this.maxStackHeight) {
            throw CfCodeStackMapValidatingException.error("The max stack height of " + this.maxStackHeight + " is violated when pushing type " + type + " to existing stack of size " + this.currentFrame.getStack().size());
        }
        return this;
    }

    public CfFrameVerificationHelper push(DexType type) {
        return this.push(CfFrame.FrameType.initialized(type));
    }

    public CfFrameVerificationHelper seenLabel(CfLabel label) {
        if (this.tryCatchRangeLabels.contains(label)) {
            for (CfTryCatch tryCatchRange : this.tryCatchRanges) {
                if (tryCatchRange.start != label) continue;
                this.currentCatchRanges.add(tryCatchRange);
                CfFrame destinationFrame = this.stateMap.get(tryCatchRange.start);
                if (destinationFrame == null) {
                    throw CfCodeStackMapValidatingException.error("No frame for target catch range target");
                }
                CfFrameVerificationHelper.checkStackIsAssignable(destinationFrame.getStack(), this.throwStack, this.factory, this.isJavaAssignable);
            }
            this.currentCatchRanges.removeIf(currentRange -> currentRange.end == label);
        }
        return this;
    }

    public void checkFrameAndSet(CfFrame newFrame) {
        if (this.currentFrame != this.NO_FRAME) {
            this.checkFrame(newFrame);
        }
        this.setFrame(newFrame);
    }

    public void checkExceptionEdges() {
        for (CfTryCatch currentCatchRange : this.currentCatchRanges) {
            for (CfLabel target : currentCatchRange.targets) {
                CfFrame destinationFrame = this.stateMap.get(target);
                if (destinationFrame == null) {
                    throw CfCodeStackMapValidatingException.error("No frame for target catch range target");
                }
                CfFrameVerificationHelper.checkLocalsIsAssignable(this.currentFrame.getLocals(), destinationFrame.getLocals(), this.factory, this.isJavaAssignable);
            }
        }
    }

    public CfFrame getFrame() {
        return this.currentFrame;
    }

    public void checkTarget(CfLabel label) {
        this.checkFrame(this.stateMap.get(label));
    }

    public void checkFrame(CfFrame destinationFrame) {
        if (destinationFrame == null) {
            throw CfCodeStackMapValidatingException.error("No destination frame");
        }
        this.checkFrame(destinationFrame.getLocals(), destinationFrame.getStack());
    }

    public void checkFrame(Int2ReferenceSortedMap<CfFrame.FrameType> locals, Deque<CfFrame.FrameType> stack) {
        CfFrameVerificationHelper.checkIsAssignable(this.currentFrame.getLocals(), this.currentFrame.getStack(), locals, stack, this.factory, this.isJavaAssignable);
    }

    public void setNoFrame() {
        this.currentFrame = this.NO_FRAME;
    }

    public boolean isUninitializedThisAndTarget(CfFrame.FrameType source, DexType target) {
        if (!source.isUninitializedThis()) {
            return false;
        }
        return target == this.factory.objectType || target == this.context;
    }

    public boolean isUninitializedNewAndTarget(CfFrame.FrameType source, DexType target) {
        if (!source.isUninitializedNew()) {
            return false;
        }
        return target == this.factory.objectType || target == this.context;
    }

    public boolean isAssignableAndInitialized(CfFrame.FrameType source, DexType target) {
        if (!source.isInitialized()) {
            return false;
        }
        return this.isJavaAssignable.test(source.getInitializedType(), target);
    }

    public void checkIsAssignable(CfFrame.FrameType source, DexType target, BiPredicate<CfFrame.FrameType, DexType> predicate) {
        if (predicate.test(source, target)) {
            return;
        }
        throw CfCodeStackMapValidatingException.error("The expected type " + source + " is not assignable to " + target.toSourceString());
    }

    public void checkIsAssignable(CfFrame.FrameType source, CfFrame.FrameType target) {
        if (!CfFrameVerificationHelper.canBeAssigned(source, target, this.factory, this.isJavaAssignable)) {
            throw CfCodeStackMapValidatingException.error("The expected type " + source + " is not assignable to " + target);
        }
    }
}

