/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;

public class CfIfCmp
extends CfInstruction {
    private final If.Type kind;
    private final ValueType type;
    private final CfLabel target;

    public CfIfCmp(If.Type kind, ValueType type, CfLabel target) {
        this.kind = kind;
        this.type = type;
        this.target = target;
    }

    @Override
    public int getCompareToId() {
        return this.getOpcode();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        CfIfCmp otherIf = (CfIfCmp)other;
        assert (this.kind == otherIf.kind);
        assert (this.type == otherIf.type);
        return helper.compareLabels(this.target, otherIf.target, visitor);
    }

    public If.Type getKind() {
        return this.kind;
    }

    public ValueType getType() {
        return this.type;
    }

    @Override
    public CfLabel getTarget() {
        return this.target;
    }

    public int getOpcode() {
        switch (this.kind) {
            case EQ: {
                return this.type.isObject() ? 165 : 159;
            }
            case GE: {
                return 162;
            }
            case GT: {
                return 163;
            }
            case LE: {
                return 164;
            }
            case LT: {
                return 161;
            }
            case NE: {
                return this.type.isObject() ? 166 : 160;
            }
        }
        throw new Unreachable("Unexpected type " + this.type);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitJumpInsn(this.getOpcode(), this.target.getLabel());
    }

    @Override
    public boolean isConditionalJump() {
        return true;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int right = state.pop().register;
        int left = state.pop().register;
        int trueTargetOffset = code.getLabelOffset(this.target);
        int falseTargetOffset = code.getCurrentInstructionIndex() + 1;
        builder.addIf(this.kind, this.type, left, right, trueTargetOffset, falseTargetOffset);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forJumpInstruction();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        DexType type = this.type.isObject() ? dexItemFactory.objectType : this.type.toPrimitiveType().toDexType(dexItemFactory);
        frameBuilder.popAndDiscardInitialized(type, type);
        frameBuilder.checkTarget(this.target);
    }
}

