/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class CfInvokeDynamic
extends CfInstruction {
    private final DexCallSite callSite;

    public CfInvokeDynamic(DexCallSite callSite) {
        this.callSite = callSite;
    }

    private Object decodeBootstrapArgument(DexValue value, NamingLens lens) {
        switch (value.getValueKind()) {
            case DOUBLE: {
                return value.asDexValueDouble().getValue();
            }
            case FLOAT: {
                return Float.valueOf(value.asDexValueFloat().getValue());
            }
            case INT: {
                return value.asDexValueInt().getValue();
            }
            case LONG: {
                return value.asDexValueLong().getValue();
            }
            case METHOD_HANDLE: {
                return ((DexMethodHandle)value.asDexValueMethodHandle().getValue()).toAsmHandle(lens);
            }
            case METHOD_TYPE: {
                return Type.getMethodType(((DexProto)value.asDexValueMethodType().getValue()).toDescriptorString(lens));
            }
            case STRING: {
                DexString innerValue = (DexString)value.asDexValueString().getValue();
                return innerValue == null ? null : innerValue.toString();
            }
            case TYPE: {
                return Type.getType(lens.lookupDescriptor((DexType)value.asDexValueType().value).toString());
            }
        }
        throw new Unreachable("Unsupported bootstrap argument of type " + value.getClass().getSimpleName());
    }

    @Override
    public boolean isInvokeDynamic() {
        return true;
    }

    @Override
    public CfInvokeDynamic asInvokeDynamic() {
        return this;
    }

    @Override
    public int getCompareToId() {
        return 186;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return this.callSite.acceptCompareTo(((CfInvokeDynamic)other).callSite, visitor);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        DexCallSite rewrittenCallSite = rewriter.rewriteCallSite(this.callSite, context);
        DexMethodHandle bootstrapMethod = rewrittenCallSite.bootstrapMethod;
        List<DexValue> bootstrapArgs = rewrittenCallSite.bootstrapArgs;
        Object[] bsmArgs = new Object[bootstrapArgs.size()];
        for (int i = 0; i < bootstrapArgs.size(); ++i) {
            bsmArgs[i] = this.decodeBootstrapArgument(bootstrapArgs.get(i), namingLens);
        }
        Handle bsmHandle = bootstrapMethod.toAsmHandle(namingLens);
        DexString methodName = namingLens.lookupMethodName(rewrittenCallSite, appView);
        visitor.visitInvokeDynamicInsn(methodName.toString(), rewrittenCallSite.methodProto.toDescriptorString(namingLens), bsmHandle, bsmArgs);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public DexCallSite getCallSite() {
        return this.callSite;
    }

    @Override
    void internalRegisterUse(UseRegistry<?> registry, DexClassAndMethod context, ListIterator<CfInstruction> iterator2) {
        registry.registerCallSite(this.callSite);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        DexType[] parameterTypes = this.callSite.methodProto.parameters.values;
        ArrayList<Integer> registers = new ArrayList<Integer>(parameterTypes.length);
        for (int register : state.popReverse(parameterTypes.length)) {
            registers.add(register);
        }
        ArrayList<ValueType> types = new ArrayList<ValueType>(parameterTypes.length);
        for (DexType value : parameterTypes) {
            types.add(ValueType.fromDexType(value));
        }
        builder.addInvokeCustom(this.callSite, types, registers);
        if (!this.callSite.methodProto.returnType.isVoidType()) {
            builder.addMoveResult(state.push((DexType)this.callSite.methodProto.returnType).register);
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forInvokeCustom();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        frameBuilder.popAndDiscardInitialized(this.callSite.methodProto.parameters.values);
        if (this.callSite.methodProto.returnType != dexItemFactory.voidType) {
            frameBuilder.push(this.callSite.methodProto.returnType);
        }
    }
}

