/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;

public class CfNeg
extends CfInstruction {
    private final NumericType type;

    public CfNeg(NumericType type) {
        this.type = type;
    }

    public static CfNeg fromAsm(int opcode) {
        switch (opcode) {
            case 116: {
                return new CfNeg(NumericType.INT);
            }
            case 117: {
                return new CfNeg(NumericType.LONG);
            }
            case 118: {
                return new CfNeg(NumericType.FLOAT);
            }
            case 119: {
                return new CfNeg(NumericType.DOUBLE);
            }
        }
        throw new Unreachable("Invalid opcode for CfNeg " + opcode);
    }

    public NumericType getType() {
        return this.type;
    }

    @Override
    public int getCompareToId() {
        return this.getAsmOpcode();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return CfCompareHelper.compareIdUniquelyDeterminesEquality(this, other);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitInsn(this.getAsmOpcode());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public int getAsmOpcode() {
        switch (this.type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return 116;
            }
            case LONG: {
                return 117;
            }
            case FLOAT: {
                return 118;
            }
            case DOUBLE: {
                return 119;
            }
        }
        throw new Unreachable("Invalid type for CfNeg " + (Object)((Object)this.type));
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int value = state.pop().register;
        builder.addNeg(this.type, state.push((ValueType)ValueType.fromNumericType((NumericType)this.type)).register, value);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forUnop();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        CfFrame.FrameType frameType = CfFrame.FrameType.fromNumericType(this.type, dexItemFactory);
        frameBuilder.popAndDiscard(frameType).push(frameType);
    }
}

