/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfTypeInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import java.util.ListIterator;

public class CfNewArray
extends CfInstruction
implements CfTypeInstruction {
    private final DexType type;

    public CfNewArray(DexType type) {
        assert (type.isArrayType());
        this.type = type;
    }

    private int getPrimitiveTypeCode() {
        switch (this.type.descriptor.content[1]) {
            case 90: {
                return 4;
            }
            case 67: {
                return 5;
            }
            case 70: {
                return 6;
            }
            case 68: {
                return 7;
            }
            case 66: {
                return 8;
            }
            case 83: {
                return 9;
            }
            case 73: {
                return 10;
            }
            case 74: {
                return 11;
            }
        }
        throw new Unreachable("Unexpected type for new-array: " + this.type);
    }

    private String getElementInternalName(DexItemFactory dexItemFactory, GraphLens graphLens, NamingLens namingLens) {
        assert (!this.type.isPrimitiveArrayType());
        StringBuilder renamedElementDescriptor = new StringBuilder();
        int numberOfLeadingSquareBrackets = this.getType().getNumberOfLeadingSquareBrackets();
        for (int i = 1; i < numberOfLeadingSquareBrackets; ++i) {
            renamedElementDescriptor.append("[");
        }
        DexType baseType = this.getType().toBaseType(dexItemFactory);
        DexType rewrittenBaseType = graphLens.lookupType(baseType);
        renamedElementDescriptor.append(namingLens.lookupDescriptor(rewrittenBaseType).toSourceString());
        return DescriptorUtils.descriptorToInternalName(renamedElementDescriptor.toString());
    }

    @Override
    public CfTypeInstruction asTypeInstruction() {
        return this;
    }

    @Override
    public boolean isTypeInstruction() {
        return true;
    }

    @Override
    public DexType getType() {
        return this.type;
    }

    @Override
    public CfInstruction withType(DexType newType) {
        return new CfNewArray(newType);
    }

    @Override
    public int getCompareToId() {
        return this.type.isPrimitiveArrayType() ? 188 : 189;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return this.type.acceptCompareTo(((CfNewArray)other).type, visitor);
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        if (this.type.isPrimitiveArrayType()) {
            visitor.visitIntInsn(188, this.getPrimitiveTypeCode());
        } else {
            visitor.visitTypeInsn(189, this.getElementInternalName(dexItemFactory, graphLens, namingLens));
        }
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    void internalRegisterUse(UseRegistry<?> registry, DexClassAndMethod context, ListIterator<CfInstruction> iterator2) {
        if (!this.type.isPrimitiveArrayType()) {
            registry.registerTypeReference(this.type);
        }
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        CfState.Slot size = state.pop();
        CfState.Slot push = state.push(this.type);
        builder.addNewArrayEmpty(push.register, size.register, this.type);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forNewArrayEmpty(this.type, context);
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        assert (this.type.isArrayType());
        frameBuilder.popAndDiscardInitialized(dexItemFactory.intType).push(this.type);
    }
}

