/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;

public class CfPosition
extends CfInstruction {
    private final CfLabel label;
    private final Position position;

    public CfPosition(CfLabel label, Position position) {
        this.label = label;
        this.position = position;
    }

    @Override
    public int getCompareToId() {
        return CfCompareHelper.POSITION_COMPARE_ID;
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return visitor.visit(this, (CfPosition)other, spec -> ((StructuralSpecification)spec.withInt(p -> p.position.getLine())).withCustomItem(p -> p.label, helper.labelAcceptor()));
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitLineNumber(this.position.getLine(), this.label.getLabel());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public Position getPosition() {
        return this.position;
    }

    public CfLabel getLabel() {
        return this.label;
    }

    @Override
    public boolean emitsIR() {
        return false;
    }

    @Override
    public boolean isPosition() {
        return true;
    }

    @Override
    public CfPosition asPosition() {
        return this;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        Position canonical = code.getCanonicalPosition(this.position);
        state.setPosition(canonical);
        builder.addDebugPosition(canonical);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
    }
}

