/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.BiPredicateUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import java.util.function.BiPredicate;

public class CfStore
extends CfInstruction {
    private final int var;
    private final ValueType type;

    public CfStore(ValueType type, int var) {
        this.var = var;
        this.type = type;
    }

    private int getStoreType() {
        switch (this.type) {
            case OBJECT: {
                return 58;
            }
            case INT: {
                return 54;
            }
            case FLOAT: {
                return 56;
            }
            case LONG: {
                return 55;
            }
            case DOUBLE: {
                return 57;
            }
        }
        throw new Unreachable("Unexpected type " + this.type);
    }

    @Override
    public int getCompareToId() {
        return this.getStoreType();
    }

    @Override
    public int internalAcceptCompareTo(CfInstruction other, CompareToVisitor visitor, CfCompareHelper helper) {
        return visitor.visitInt(this.var, other.asStore().var);
    }

    @Override
    public CfStore asStore() {
        return this;
    }

    @Override
    public boolean isStore() {
        return true;
    }

    @Override
    public void write(AppView<?> appView, ProgramMethod context, DexItemFactory dexItemFactory, GraphLens graphLens, InitClassLens initClassLens, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitVarInsn(this.getStoreType(), this.var);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public ValueType getType() {
        return this.type;
    }

    public int getLocalIndex() {
        return this.var;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        CfState.Slot pop = state.pop();
        builder.addMove(this.type, state.write((int)this.var, (CfState.Slot)pop).register, pop.register);
    }

    @Override
    public boolean emitsIR() {
        return false;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, CfCode code, ProgramMethod context) {
        return inliningConstraints.forStore();
    }

    @Override
    public void evaluate(CfFrameVerificationHelper frameBuilder, DexMethod context, AppView<?> appView, DexItemFactory dexItemFactory) {
        CfFrame.FrameType pop = frameBuilder.pop();
        switch (this.type) {
            case OBJECT: {
                BiPredicate[] biPredicateArray = new BiPredicate[3];
                biPredicateArray[0] = frameBuilder::isUninitializedThisAndTarget;
                biPredicateArray[1] = frameBuilder::isUninitializedNewAndTarget;
                biPredicateArray[2] = frameBuilder::isAssignableAndInitialized;
                frameBuilder.checkIsAssignable(pop, dexItemFactory.objectType, BiPredicateUtils.or(biPredicateArray));
                frameBuilder.storeLocal(this.var, pop);
                return;
            }
            case INT: {
                frameBuilder.checkIsAssignable(pop, dexItemFactory.intType, frameBuilder::isAssignableAndInitialized);
                frameBuilder.storeLocal(this.var, CfFrame.FrameType.initialized(dexItemFactory.intType));
                return;
            }
            case FLOAT: {
                frameBuilder.checkIsAssignable(pop, dexItemFactory.floatType, frameBuilder::isAssignableAndInitialized);
                frameBuilder.storeLocal(this.var, CfFrame.FrameType.initialized(dexItemFactory.floatType));
                return;
            }
            case LONG: {
                frameBuilder.checkIsAssignable(pop, dexItemFactory.longType, frameBuilder::isAssignableAndInitialized);
                frameBuilder.storeLocal(this.var, CfFrame.FrameType.initialized(dexItemFactory.longType));
                frameBuilder.storeLocal(this.var + 1, CfFrame.FrameType.initialized(dexItemFactory.longType));
                return;
            }
            case DOUBLE: {
                frameBuilder.checkIsAssignable(pop, dexItemFactory.doubleType, frameBuilder::isAssignableAndInitialized);
                frameBuilder.storeLocal(this.var, CfFrame.FrameType.initialized(dexItemFactory.doubleType));
                frameBuilder.storeLocal(this.var + 1, CfFrame.FrameType.initialized(dexItemFactory.doubleType));
                return;
            }
        }
        throw new Unreachable("Unexpected type " + this.type);
    }
}

