/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format21c;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.OffsetToObjectMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;

public class ConstMethodHandle
extends Format21c<DexMethodHandle> {
    public static final int OPCODE = 254;
    public static final String NAME = "ConstMethodHandle";
    public static final String SMALI_NAME = "const-method-handle";

    ConstMethodHandle(int high, BytecodeStream stream, OffsetToObjectMapping mapping) {
        super(high, stream, (IndexedDexItem[])mapping.getMethodHandleMap());
    }

    public ConstMethodHandle(int register, DexMethodHandle methodHandle) {
        super(register, methodHandle);
    }

    public DexMethodHandle getMethodHandle() {
        return (DexMethodHandle)this.BBBB;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        return 254;
    }

    @Override
    void internalSubSpecify(StructuralSpecification<Format21c<DexMethodHandle>, ?> spec) {
        spec.withItem(i -> (DexMethodHandle)i.BBBB);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", \"" + ((DexMethodHandle)this.BBBB).toString() + "\"");
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", \"" + ((DexMethodHandle)this.BBBB).toString() + "\"");
    }

    @Override
    public void registerUse(UseRegistry<?> registry) {
        registry.registerMethodHandle(this.getMethodHandle(), UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
    }

    @Override
    public void write(ShortBuffer dest, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        DexMethodHandle rewritten = rewriter.rewriteDexMethodHandle(this.getMethodHandle(), UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY, context);
        int index = rewritten.getOffset(mapping);
        if (index != (index & 0xFFFF)) {
            throw new InternalCompilerError("MethodHandle-index overflow.");
        }
        this.writeFirst(this.AA, dest);
        this.write16BitReference(rewritten, dest, mapping);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        DexMethodHandle rewritten = rewriter.rewriteDexMethodHandle(this.getMethodHandle(), UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY, context);
        rewritten.collectIndexedItems(indexedItems);
    }

    @Override
    public void buildIR(IRBuilder builder) {
        builder.addConstMethodHandle(this.AA, (DexMethodHandle)this.BBBB);
    }

    @Override
    public boolean canThrow() {
        return true;
    }
}

