/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format21c;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.OffsetToObjectMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;

public class ConstString
extends Format21c<DexString> {
    public static final int OPCODE = 26;
    public static final String NAME = "ConstString";
    public static final String SMALI_NAME = "const-string";

    ConstString(int high, BytecodeStream stream, OffsetToObjectMapping mapping) {
        super(high, stream, (IndexedDexItem[])mapping.getStringMap());
    }

    public ConstString(int register, DexString string) {
        super(register, string);
    }

    public DexString getString() {
        return (DexString)this.BBBB;
    }

    @Override
    void internalSubSpecify(StructuralSpecification<Format21c<DexString>, ?> spec) {
        spec.withItem(i -> (DexString)i.BBBB);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        this.getString().collectIndexedItems(indexedItems);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        return 26;
    }

    @Override
    public ConstString asConstString() {
        return this;
    }

    @Override
    public boolean isConstString() {
        return true;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", \"" + ((DexString)this.BBBB).toString() + "\"");
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", \"" + ((DexString)this.BBBB).toString() + "\"");
    }

    @Override
    public void write(ShortBuffer dest, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        int index = ((DexString)this.BBBB).getOffset(mapping);
        if (index != (index & 0xFFFF)) {
            throw new InternalCompilerError("String-index overflow.");
        }
        this.writeFirst(this.AA, dest);
        this.write16BitReference(this.BBBB, dest, mapping);
    }

    @Override
    public void buildIR(IRBuilder builder) {
        builder.addConstString(this.AA, (DexString)this.BBBB);
    }

    @Override
    public boolean canThrow() {
        return true;
    }
}

