/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.DexCompareHelper;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class DexRecordFieldValues
extends Instruction {
    public static final String NAME = "RecordFieldValues";
    public static final String SMALI_NAME = "record-field-values*";
    private final int outRegister;
    private final int[] arguments;
    private final DexField[] fields;

    public DexRecordFieldValues(int outRegister, int[] arguments, DexField[] fields) {
        this.outRegister = outRegister;
        this.arguments = arguments;
        this.fields = fields;
    }

    private static void specify(StructuralSpecification<DexRecordFieldValues, ?> spec) {
        spec.withItemArray(i -> i.fields);
    }

    private void appendArguments(StringBuilder builder) {
        builder.append("{ ");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append("v").append(this.arguments[i]);
        }
        builder.append(" }");
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        for (DexField field : this.fields) {
            field.collectIndexedItems(indexedItems);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        throw new Unreachable("DexRecordFieldValues instructions should always be rewritten into NewArray");
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    int getCompareToId() {
        return DexCompareHelper.DEX_RECORD_FIELD_VALUES_COMPARE_ID;
    }

    @Override
    int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (DexRecordFieldValues)other, DexRecordFieldValues::specify);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder sb = new StringBuilder();
        sb.append("v").append(this.outRegister).append(" ");
        this.appendArguments(sb);
        return this.formatString(sb.toString());
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.toString(naming);
    }

    @Override
    public void write(ShortBuffer dest, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        throw new Unreachable("DexRecordFieldValues instructions should always be rewritten into NewArray");
    }

    @Override
    public boolean isRecordFieldValues() {
        return true;
    }

    public void registerUse(UseRegistry registry) {
        registry.registerRecordFieldValues(this.fields);
    }

    @Override
    public void buildIR(IRBuilder builder) {
        IntArrayList parameters = new IntArrayList();
        for (int i = 0; i < this.arguments.length; ++i) {
            parameters.add(this.arguments[i]);
        }
        builder.addRecordFieldValues(this.fields, parameters, this.outRegister);
    }

    @Override
    public int hashCode() {
        return 31 * this.getClass().hashCode() + Arrays.hashCode(this.fields);
    }

    @Override
    public boolean canThrow() {
        return true;
    }
}

