/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base2Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;

public abstract class Format22b
extends Base2Format {
    public final short AA;
    public final short BB;
    public final byte CC;

    private static void specify(StructuralSpecification<Format22b, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)spec.withInt(i -> i.AA)).withInt(i -> i.BB)).withInt(i -> i.CC);
    }

    Format22b(int high, BytecodeStream stream) {
        super(stream);
        this.AA = (short)high;
        this.CC = Format22b.readSigned8BitValue(stream);
        this.BB = Format22b.read8BitValue(stream);
    }

    Format22b(int AA, int BB, int CC) {
        assert (0 <= AA && AA <= 255);
        assert (0 <= BB && BB <= 255);
        assert (-128 <= CC && CC <= 127);
        this.AA = (short)AA;
        this.BB = (short)BB;
        this.CC = (byte)CC;
    }

    @Override
    public void write(ShortBuffer dest, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        this.writeFirst(this.AA, dest);
        this.write16BitValue(Format22b.combineBytes(this.CC, this.BB), dest);
    }

    @Override
    public final int hashCode() {
        return (this.AA << 16 | this.BB << 8 | this.CC) ^ this.getClass().hashCode();
    }

    @Override
    final int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (Format22b)other, Format22b::specify);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", v" + this.BB + ", #" + this.CC);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", v" + this.BB + ", " + StringUtils.hexString(this.CC, 2) + "  # " + this.CC);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
    }
}

