/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base2Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;

public abstract class Format22t
extends Base2Format {
    public final byte A;
    public final byte B;
    public short CCCC;

    private static void specify(StructuralSpecification<Format22t, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)spec.withInt(i -> i.A)).withInt(i -> i.B)).withInt(i -> i.CCCC);
    }

    Format22t(int high, BytecodeStream stream) {
        super(stream);
        this.A = (byte)(high & 0xF);
        this.B = (byte)(high >> 4 & 0xF);
        this.CCCC = Format22t.readSigned16BitValue(stream);
    }

    Format22t(int register1, int register2, int offset) {
        assert (0 <= register1 && register1 <= 15);
        assert (0 <= register2 && register2 <= 15);
        assert (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE);
        this.A = (byte)register1;
        this.B = (byte)register2;
        this.CCCC = (short)offset;
    }

    @Override
    public void write(ShortBuffer dest, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        this.writeFirst((int)this.B, this.A, dest);
        this.write16BitValue(this.CCCC, dest);
    }

    @Override
    public final int hashCode() {
        return (this.CCCC << 8 | this.B << 4 | this.A) ^ this.getClass().hashCode();
    }

    @Override
    final int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (Format22t)other, Format22t::specify);
    }

    public abstract If.Type getType();

    public abstract ValueTypeConstraint getOperandTypeConstraint();

    @Override
    public int[] getTargets() {
        return new int[]{this.CCCC, this.getSize()};
    }

    @Override
    public void buildIR(IRBuilder builder) {
        int offset = this.getOffset();
        int size = this.getSize();
        builder.addIf(this.getType(), this.getOperandTypeConstraint(), (int)this.A, (int)this.B, offset + this.CCCC, offset + size);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.A + ", v" + this.B + ", " + this.formatRelativeOffset(this.CCCC));
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.A + ", v" + this.B + ", :label_" + (this.getOffset() + this.CCCC));
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
    }
}

