/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;

abstract class Format32x
extends Base3Format {
    public final int AAAA;
    public final int BBBB;

    private static void specify(StructuralSpecification<Format32x, ?> spec) {
        ((StructuralSpecification)spec.withInt(i -> i.AAAA)).withInt(i -> i.BBBB);
    }

    Format32x(int high, BytecodeStream stream) {
        super(stream);
        this.AAAA = Format32x.read16BitValue(stream);
        this.BBBB = Format32x.read16BitValue(stream);
    }

    Format32x(int dest, int src) {
        assert (0 <= dest && dest <= 65535);
        assert (0 <= src && src <= 65535);
        this.AAAA = dest;
        this.BBBB = src;
    }

    @Override
    public void write(ShortBuffer dest, ProgramMethod context, GraphLens graphLens, ObjectToOffsetMapping mapping, LensCodeRewriterUtils rewriter) {
        this.writeFirst(0, dest);
        this.write16BitValue(this.AAAA, dest);
        this.write16BitValue(this.BBBB, dest);
    }

    @Override
    public final int hashCode() {
        return (this.AAAA << 16 | this.BBBB) ^ this.getClass().hashCode();
    }

    @Override
    final int internalAcceptCompareTo(Instruction other, CompareToVisitor visitor) {
        return visitor.visit(this, (Format32x)other, Format32x::specify);
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AAAA + ", v" + this.BBBB);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AAAA + ", v" + this.BBBB);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
    }
}

