/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.code.CheckCast;
import com.android.tools.r8.code.ConstClass;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.code.DexItemBasedConstString;
import com.android.tools.r8.code.InstanceOf;
import com.android.tools.r8.code.InvokeVirtual;
import com.android.tools.r8.code.InvokeVirtualRange;
import com.android.tools.r8.code.Nop;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.Equatable;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import java.nio.ShortBuffer;
import java.util.function.BiPredicate;

public abstract class Instruction
implements CfOrDexInstruction,
StructuralItem<Instruction> {
    public static final Instruction[] EMPTY_ARRAY = new Instruction[0];
    public static final int[] NO_TARGETS = null;
    public static final int[] EXIT_TARGET = new int[0];
    private int offset;

    Instruction(BytecodeStream stream) {
        this.offset = stream.getOffset() - 1;
    }

    protected Instruction() {
        this.offset = -1;
    }

    static byte readSigned8BitValue(BytecodeStream stream) {
        return (byte)stream.nextByte();
    }

    static short read8BitValue(BytecodeStream stream) {
        return (short)stream.nextByte();
    }

    static short readSigned16BitValue(BytecodeStream stream) {
        return (short)stream.nextShort();
    }

    static char read16BitValue(BytecodeStream stream) {
        return (char)(stream.nextShort() & 0xFFFF);
    }

    static int readSigned32BitValue(BytecodeStream stream) {
        char low = Instruction.read16BitValue(stream);
        char high = Instruction.read16BitValue(stream);
        int result = high << 16 & 0xFFFF0000 | low & 0xFFFF;
        return result;
    }

    static long read32BitValue(BytecodeStream stream) {
        long low = Instruction.read16BitValue(stream);
        long high = Instruction.read16BitValue(stream);
        long result = (high & 0xFFFFL) << 16 | low & 0xFFFFL;
        return result;
    }

    static long read64BitValue(BytecodeStream stream) {
        long low = Instruction.read32BitValue(stream);
        long high = Instruction.read32BitValue(stream);
        long result = high << 32 | low;
        return result;
    }

    protected static short combineBytes(int high, int low) {
        return (short)((high & 0xFF) << 8 | low & 0xFF);
    }

    protected static int makeByte(int high, int low) {
        return (high & 0xF) << 4 | low & 0xF;
    }

    static String formatOffset(int offset) {
        return StringUtils.hexString(offset, 2);
    }

    static String formatDecimalOffset(int offset) {
        return offset >= 0 ? "+" + offset : Integer.toString(offset);
    }

    protected void writeFirst(int aa, ShortBuffer dest) {
        this.writeFirst(aa, dest, this.getOpcode());
    }

    protected void writeFirst(int aa, ShortBuffer dest, int opcode) {
        dest.put((short)((aa & 0xFF) << 8 | opcode & 0xFF));
    }

    protected void writeFirst(int a, int b, ShortBuffer dest) {
        this.writeFirst(a, b, dest, this.getOpcode());
    }

    protected void writeFirst(int a, int b, ShortBuffer dest, int opcode) {
        dest.put((short)((a & 0xF) << 12 | (b & 0xF) << 8 | opcode & 0xFF));
    }

    protected void write16BitValue(int value, ShortBuffer dest) {
        dest.put((short)value);
    }

    protected void write32BitValue(long value, ShortBuffer dest) {
        dest.put((short)(value & 0xFFFFL));
        dest.put((short)(value >> 16 & 0xFFFFL));
    }

    protected void write64BitValue(long value, ShortBuffer dest) {
        this.write32BitValue(value & 0xFFFFFFFFFFFFFFFFL, dest);
        this.write32BitValue(value >> 32 & 0xFFFFFFFFFFFFFFFFL, dest);
    }

    protected void write16BitReference(IndexedDexItem item, ShortBuffer dest, ObjectToOffsetMapping mapping) {
        int index = item.getOffset(mapping);
        assert (index == (index & 0xFFFF));
        this.write16BitValue(index, dest);
    }

    protected void write32BitReference(IndexedDexItem item, ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.write32BitValue(item.getOffset(mapping), dest);
    }

    public boolean hasOffset() {
        return this.offset >= 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public CfInstruction asCfInstruction() {
        return null;
    }

    @Override
    public boolean isCfInstruction() {
        return false;
    }

    @Override
    public Instruction asDexInstruction() {
        return this;
    }

    public CheckCast asCheckCast() {
        return null;
    }

    public boolean isCheckCast() {
        return false;
    }

    public InstanceOf asInstanceOf() {
        return null;
    }

    public boolean isInstanceOf() {
        return false;
    }

    public ConstString asConstString() {
        return null;
    }

    public boolean isConstString() {
        return false;
    }

    public ConstClass asConstClass() {
        return null;
    }

    public boolean isConstClass() {
        return false;
    }

    public boolean isRecordFieldValues() {
        return false;
    }

    public DexItemBasedConstString asDexItemBasedConstString() {
        return null;
    }

    public boolean isDexItemBasedConstString() {
        return false;
    }

    public ConstStringJumbo asConstStringJumbo() {
        return null;
    }

    public boolean isConstStringJumbo() {
        return false;
    }

    public boolean isInvokeVirtual() {
        return false;
    }

    public InvokeVirtual asInvokeVirtual() {
        return null;
    }

    public boolean isInvokeVirtualRange() {
        return false;
    }

    public InvokeVirtualRange asInvokeVirtualRange() {
        return null;
    }

    public boolean isSimpleNop() {
        return !this.isPayload() && this instanceof Nop;
    }

    public boolean isPayload() {
        return false;
    }

    public boolean isSwitchPayload() {
        return false;
    }

    public boolean hasPayload() {
        return false;
    }

    public boolean isIntSwitch() {
        return false;
    }

    public boolean isThrow() {
        return false;
    }

    public int getPayloadOffset() {
        return 0;
    }

    public boolean ignoreCompatRules() {
        return false;
    }

    String formatRelativeOffset(int offset) {
        return Instruction.formatOffset(this.getOffset() + offset) + " (" + Instruction.formatDecimalOffset(offset) + ")";
    }

    String formatString(String left) {
        StringBuilder builder = new StringBuilder();
        StringUtils.appendLeftPadded(builder, Instruction.formatOffset(this.getOffset()), 6);
        builder.append(": ");
        StringUtils.appendRightPadded(builder, this.getName(), 20);
        builder.append(left == null ? "" : left);
        return builder.toString();
    }

    String formatSmaliString(String left) {
        StringBuilder builder = new StringBuilder();
        builder.append("    ");
        if (left != null) {
            StringUtils.appendRightPadded(builder, this.getSmaliName(), 20);
            builder.append(left);
        } else {
            builder.append(this.getSmaliName());
        }
        return builder.toString();
    }

    public int[] getTargets() {
        return NO_TARGETS;
    }

    public abstract void buildIR(IRBuilder var1);

    public DexCallSite getCallSite() {
        return null;
    }

    public DexMethod getMethod() {
        return null;
    }

    public DexProto getProto() {
        return null;
    }

    public DexField getField() {
        return null;
    }

    @Override
    public final boolean equals(Object other) {
        return Equatable.equalsImpl(this, other);
    }

    @Override
    public abstract int hashCode();

    @Override
    public Instruction self() {
        return this;
    }

    @Override
    public StructuralMapping<Instruction> getStructuralMapping() {
        throw new Unreachable();
    }

    int getCompareToId() {
        return this.getOpcode();
    }

    abstract int internalAcceptCompareTo(Instruction var1, CompareToVisitor var2);

    @Override
    public final int acceptCompareTo(Instruction other, CompareToVisitor visitor) {
        int opcodeDiff = visitor.visitInt(this.getCompareToId(), other.getCompareToId());
        return opcodeDiff != 0 ? opcodeDiff : this.internalAcceptCompareTo(other, visitor);
    }

    @Override
    public final void acceptHashing(HashingVisitor visitor) {
        visitor.visitInt(this.getCompareToId());
    }

    public abstract String getName();

    public abstract String getSmaliName();

    public abstract int getOpcode();

    public abstract int getSize();

    public String toSmaliString(Instruction payloadUser) {
        throw new InternalCompilerError("Instruction " + payloadUser + " is not a payload user");
    }

    public abstract String toSmaliString(ClassNameMapper var1);

    public String toSmaliString() {
        return this.toSmaliString((ClassNameMapper)null);
    }

    public abstract String toString(ClassNameMapper var1);

    public String toString(ClassNameMapper naming, Instruction payloadUser) {
        throw new InternalCompilerError("Instruction " + payloadUser + " is not a payload user");
    }

    public String toString() {
        return this.toString(null);
    }

    public abstract void write(ShortBuffer var1, ProgramMethod var2, GraphLens var3, ObjectToOffsetMapping var4, LensCodeRewriterUtils var5);

    public abstract void collectIndexedItems(IndexedItemCollection var1, ProgramMethod var2, GraphLens var3, LensCodeRewriterUtils var4);

    public boolean equals(Instruction other, BiPredicate<IndexedDexItem, IndexedDexItem> equality) {
        return this.equals(other);
    }

    public void registerUse(UseRegistry<?> registry) {
    }

    public boolean canThrow() {
        return false;
    }
}

