/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format31t;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;

public class SparseSwitch
extends Format31t {
    public static final int OPCODE = 44;
    public static final String NAME = "SparseSwitch";
    public static final String SMALI_NAME = "sparse-switch";

    SparseSwitch(int high, BytecodeStream stream) {
        super(high, stream);
    }

    public SparseSwitch(int value) {
        super(value, -1);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getOpcode() {
        return 44;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public boolean isIntSwitch() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder) {
        int offset = this.getOffset();
        int payloadOffset = offset + this.getPayloadOffset();
        int fallthroughOffset = offset + this.getSize();
        builder.resolveAndBuildSwitch(this.AA, fallthroughOffset, payloadOffset);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", :label_" + (this.getOffset() + this.BBBBBBBB));
    }
}

