/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.com.google.common.io;

import com.android.tools.r8.com.google.common.annotations.GwtIncompatible;
import com.android.tools.r8.com.google.common.base.Preconditions;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.CharSink;
import com.android.tools.r8.com.google.common.io.Closer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

@GwtIncompatible
public abstract class ByteSink {
    protected ByteSink() {
    }

    public CharSink asCharSink(Charset charset) {
        return new AsCharSink(charset);
    }

    public abstract OutputStream openStream() throws IOException;

    public OutputStream openBufferedStream() throws IOException {
        OutputStream out = this.openStream();
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public void write(byte[] bytes) throws IOException {
        Preconditions.checkNotNull(bytes);
        Closer closer = Closer.create();
        try {
            OutputStream out = closer.register(this.openStream());
            out.write(bytes);
            out.flush();
        }
        catch (Throwable e) {
            try {
                throw closer.rethrow(e);
            }
            catch (Throwable throwable) {
                closer.close();
                throw throwable;
            }
        }
        closer.close();
    }

    @CanIgnoreReturnValue
    public long writeFrom(InputStream input) throws IOException {
        long l;
        Preconditions.checkNotNull(input);
        Closer closer = Closer.create();
        try {
            OutputStream out = closer.register(this.openStream());
            long written = ByteStreams.copy(input, out);
            out.flush();
            l = written;
        }
        catch (Throwable e) {
            try {
                throw closer.rethrow(e);
            }
            catch (Throwable throwable) {
                closer.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    private final class AsCharSink
    extends CharSink {
        private final Charset charset;

        private AsCharSink(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        @Override
        public Writer openStream() throws IOException {
            return new OutputStreamWriter(ByteSink.this.openStream(), this.charset);
        }

        public String toString() {
            String string = ByteSink.this.toString();
            String string2 = String.valueOf(this.charset);
            return new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".asCharSink(").append(string2).append(")").toString();
        }
    }
}

