/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.contexts;

import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaring;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.structural.HasherWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class CompilationContext {
    private final Consumer<String> testingConsumer;
    private final Thread mainThread;
    private final Map<String, String> seenSetForTesting = new ConcurrentHashMap<String, String>();
    private int nextProcessorId = 0;

    public static CompilationContext createInitialContext(InternalOptions options) {
        return new CompilationContext(options);
    }

    private CompilationContext(InternalOptions options) {
        this.testingConsumer = options.testing.processingContextsConsumer;
        this.mainThread = options.mainThread;
    }

    private boolean verifyContext(ContextDescriptorProvider context) {
        String descriptor = context.buildContextDescriptorForTesting(new StringBuilder()).toString();
        String suffix = context.buildSyntheticSuffix(new StringBuilder()).toString();
        assert (descriptor.endsWith(suffix));
        if (this.testingConsumer != null) {
            this.testingConsumer.accept(descriptor);
        }
        assert (this.seenSetForTesting.put(descriptor, descriptor) == null) : "Duplicated use of context descriptor: " + descriptor;
        return true;
    }

    public ProcessorContext createProcessorContext() {
        ProcessorContext processorContext = new ProcessorContext(this, this.nextProcessorId++);
        assert (this.verifyContext(processorContext));
        assert (this.mainThread == Thread.currentThread()) : "Invoked on another thread than main";
        return processorContext;
    }

    public static class UniqueContext
    extends ContextDescriptorProvider {
        private final ThreadTaskContext parent;
        private final DexProgramClass classContext;
        private final int positionId;

        private UniqueContext(ThreadTaskContext parent, DexProgramClass classContext, int positionId) {
            this.parent = parent;
            this.classContext = classContext;
            this.positionId = positionId;
        }

        private StringBuilder buildSuffix(StringBuilder builder) {
            return builder.append('$').append(this.positionId);
        }

        @Override
        StringBuilder buildContextDescriptorForTesting(StringBuilder builder) {
            return this.buildSuffix(this.parent.buildContextDescriptorForTesting(builder));
        }

        @Override
        StringBuilder buildSyntheticSuffix(StringBuilder builder) {
            return this.buildSuffix(this.parent.buildSyntheticSuffix(builder));
        }

        public DexProgramClass getClassContext() {
            return this.classContext;
        }

        public String getSyntheticSuffix() {
            return this.buildSyntheticSuffix(new StringBuilder()).toString();
        }
    }

    public static class MethodProcessingContext
    extends ThreadTaskContext {
        private final ProgramMethod method;

        private MethodProcessingContext(ProcessorContext parent, ProgramMethod method) {
            super(parent);
            this.method = method;
        }

        private DexProgramClass getClassContext() {
            return this.method.getHolder();
        }

        private StringBuilder buildSuffix(StringBuilder builder) {
            HasherWrapper hasher = HasherWrapper.sha256Hasher();
            ((DexMethod)this.method.getReference()).hash(hasher);
            return builder.append('$').append(hasher.hashCodeAsString());
        }

        public UniqueContext createUniqueContext() {
            UniqueContext uniqueContext = new UniqueContext(this, this.getClassContext(), this.incrementAndGetNextId());
            assert (this.getParent().verifyContext(uniqueContext));
            return uniqueContext;
        }

        public ProgramMethod getMethodContext() {
            return this.method;
        }

        @Override
        StringBuilder buildContextDescriptorForTesting(StringBuilder builder) {
            builder.append(this.getClassContext().getType().toDescriptorString());
            return this.buildSuffix(this.getParent().buildContextDescriptorForTesting(builder));
        }

        @Override
        StringBuilder buildSyntheticSuffix(StringBuilder builder) {
            return this.buildSuffix(this.getParent().buildSyntheticSuffix(builder));
        }
    }

    public static class ClassSynthesisDesugaringContext
    extends ThreadTaskContext {
        private final CfClassSynthesizerDesugaring desugaring;

        private ClassSynthesisDesugaringContext(ProcessorContext parent, CfClassSynthesizerDesugaring desugaring) {
            super(parent);
            this.desugaring = desugaring;
        }

        @Override
        StringBuilder buildContextDescriptorForTesting(StringBuilder builder) {
            return this.getParent().buildContextDescriptorForTesting(builder).append(this.desugaring.uniqueIdentifier());
        }

        @Override
        StringBuilder buildSyntheticSuffix(StringBuilder builder) {
            return this.getParent().buildSyntheticSuffix(builder).append(this.desugaring.uniqueIdentifier());
        }

        public UniqueContext createUniqueContext(DexProgramClass context) {
            UniqueContext uniqueContext = new UniqueContext(this, context, this.incrementAndGetNextId());
            assert (this.getParent().verifyContext(uniqueContext));
            return uniqueContext;
        }
    }

    public static class MainThreadContext
    extends ThreadTaskContext {
        private static final String IDENTIFIER = "main";
        private final Thread mainThread;

        private MainThreadContext(ProcessorContext parent, Thread mainThread) {
            super(parent);
            this.mainThread = mainThread;
        }

        @Override
        StringBuilder buildContextDescriptorForTesting(StringBuilder builder) {
            return this.getParent().buildContextDescriptorForTesting(builder).append(IDENTIFIER);
        }

        @Override
        StringBuilder buildSyntheticSuffix(StringBuilder builder) {
            return this.getParent().buildSyntheticSuffix(builder).append(IDENTIFIER);
        }

        public UniqueContext createUniqueContext(DexProgramClass context) {
            assert (this.mainThread == Thread.currentThread()) : "Invoked on another thread than main";
            UniqueContext uniqueContext = new UniqueContext(this, context, this.incrementAndGetNextId());
            assert (this.getParent().verifyContext(uniqueContext));
            return uniqueContext;
        }
    }

    public static abstract class ThreadTaskContext
    extends ContextDescriptorProvider {
        private final ProcessorContext parent;
        private int nextId = 0;

        private ThreadTaskContext(ProcessorContext parent) {
            this.parent = parent;
        }

        public ProcessorContext getParent() {
            return this.parent;
        }

        int incrementAndGetNextId() {
            return this.nextId++;
        }
    }

    public static class ProcessorContext
    extends ContextDescriptorProvider {
        private final CompilationContext parent;
        private final int processorId;

        private ProcessorContext(CompilationContext parent, int processorId) {
            this.parent = parent;
            this.processorId = processorId;
        }

        private boolean verifyContext(ContextDescriptorProvider context) {
            assert (this.parent.verifyContext(context));
            return true;
        }

        private StringBuilder buildSuffix(StringBuilder builder) {
            return builder.append('$').append(this.processorId);
        }

        public MethodProcessingContext createMethodProcessingContext(ProgramMethod method) {
            MethodProcessingContext methodProcessingContext = new MethodProcessingContext(this, method);
            assert (this.verifyContext(methodProcessingContext));
            return methodProcessingContext;
        }

        public MainThreadContext createMainThreadContext() {
            MainThreadContext singleThreadContext = new MainThreadContext(this, this.parent.mainThread);
            assert (this.verifyContext(singleThreadContext));
            return singleThreadContext;
        }

        public ClassSynthesisDesugaringContext createClassSynthesisDesugaringContext(CfClassSynthesizerDesugaring desugaring) {
            ClassSynthesisDesugaringContext classSynthesisDesugaringContext = new ClassSynthesisDesugaringContext(this, desugaring);
            assert (this.verifyContext(classSynthesisDesugaringContext));
            return classSynthesisDesugaringContext;
        }

        @Override
        StringBuilder buildContextDescriptorForTesting(StringBuilder builder) {
            return this.buildSuffix(builder);
        }

        @Override
        StringBuilder buildSyntheticSuffix(StringBuilder builder) {
            return this.buildSuffix(builder);
        }
    }

    private static abstract class ContextDescriptorProvider {
        private ContextDescriptorProvider() {
        }

        abstract StringBuilder buildContextDescriptorForTesting(StringBuilder var1);

        abstract StringBuilder buildSyntheticSuffix(StringBuilder var1);
    }
}

