/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonParser;
import com.android.tools.r8.com.google.gson.JsonSyntaxException;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2LongMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.UTFDataFormatException;
import java.util.Comparator;
import java.util.Map;

public class ClassesChecksum {
    private static final String PREFIX = "~~~";
    private static final char PREFIX_CHAR0 = '~';
    private static final char PREFIX_CHAR1 = '~';
    private static final char PREFIX_CHAR2 = '~';
    private final Object2LongMap<String> dictionary = new Object2LongOpenHashMap<String>();

    public ClassesChecksum() {
        assert (PREFIX.length() == 3);
        assert (PREFIX.charAt(0) == '~');
        assert (PREFIX.charAt(1) == '~');
        assert (PREFIX.charAt(2) == '~');
    }

    private void append(JsonObject json) {
        json.entrySet().forEach(entry -> this.dictionary.put((String)entry.getKey(), Long.parseLong(((JsonElement)entry.getValue()).getAsString(), 16)));
    }

    public static boolean definitelyPrecedesChecksumMarker(DexString string) {
        try {
            assert (PREFIX.length() == 3);
            char[] prefix = new char[PREFIX.length()];
            int prefixLength = string.decodePrefix(prefix);
            if (prefixLength == 0) {
                return true;
            }
            if (prefix[0] != '~') {
                return prefix[0] < '~';
            }
            if (prefixLength == 1) {
                return true;
            }
            if (prefix[1] != '~') {
                return prefix[1] < '~';
            }
            if (prefixLength == 2) {
                return true;
            }
            return prefix[2] < '~';
        }
        catch (UTFDataFormatException e) {
            throw new RuntimeException("Bad format", e);
        }
    }

    public void addChecksum(String classDescriptor, long crc) {
        this.dictionary.put(classDescriptor, crc);
    }

    public Object2LongMap<String> getChecksums() {
        return this.dictionary;
    }

    public String toJsonString() {
        JsonObject sortedJson = new JsonObject();
        this.dictionary.object2LongEntrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> sortedJson.addProperty((String)entry.getKey(), Long.toString(entry.getLongValue(), 16)));
        return PREFIX + sortedJson;
    }

    public void tryParseAndAppend(DexString dexString) {
        if (dexString.size > 2 && dexString.content[0] == 126 && dexString.content[1] == 126 && dexString.content[2] == 126) {
            String str = dexString.toString().substring(3);
            try {
                JsonElement result = new JsonParser().parse(str);
                if (result.isJsonObject()) {
                    this.append(result.getAsJsonObject());
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
    }
}

