/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.graph.DexDebugInfoForWriting;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.utils.LebUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DebugBytecodeWriter {
    private final ObjectToOffsetMapping mapping;
    private final GraphLens graphLens;
    private final DexDebugInfoForWriting info;
    private ByteBuffer buffer;

    public DebugBytecodeWriter(DexDebugInfoForWriting info, ObjectToOffsetMapping mapping, GraphLens graphLens) {
        this.info = info;
        this.mapping = mapping;
        this.graphLens = graphLens;
        this.buffer = ByteBuffer.allocate(info.estimatedWriteSize());
    }

    private void maybeGrow(int size) {
        if (this.buffer.remaining() < size) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() * 2);
            newBuffer.put(this.buffer.array(), 0, this.buffer.position());
            this.buffer = newBuffer;
        }
    }

    private void putUleb128p1(int item) {
        this.putUleb128(item + 1);
    }

    private void putNoIndex() {
        this.putUleb128(0);
    }

    public byte[] generate() {
        this.info.write(this, this.mapping, this.graphLens);
        return Arrays.copyOf(this.buffer.array(), this.buffer.position());
    }

    public void putByte(int item) {
        this.maybeGrow(1);
        this.buffer.put((byte)item);
    }

    public void putSleb128(int item) {
        byte[] encoded = LebUtils.encodeSleb128(item);
        this.maybeGrow(encoded.length);
        this.buffer.put(encoded, 0, encoded.length);
    }

    public void putUleb128(int item) {
        byte[] encoded = LebUtils.encodeUleb128(item);
        this.maybeGrow(encoded.length);
        this.buffer.put(encoded, 0, encoded.length);
    }

    public void putType(DexType type) {
        if (type == null) {
            this.putNoIndex();
        } else {
            int index = this.mapping.getOffsetFor(type);
            this.putUleb128p1(index);
        }
    }

    public void putString(DexString string) {
        if (string == null) {
            this.putNoIndex();
        } else {
            int index = this.mapping.getOffsetFor(string);
            this.putUleb128p1(index);
        }
    }
}

