/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dump;

import com.android.tools.r8.dump.DumpOptions;
import com.android.tools.r8.dump.ProguardConfigSanitizer;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ZipUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class CompilerDump {
    private final Path directory;

    public static CompilerDump fromArchive(Path dumpArchive, Path dumpExtractionDirectory) throws IOException {
        ZipUtils.unzip(dumpArchive, dumpExtractionDirectory);
        return new CompilerDump(dumpExtractionDirectory);
    }

    public CompilerDump(Path directory) {
        this.directory = directory;
    }

    public Path getProgramArchive() {
        return this.directory.resolve("program.jar");
    }

    public Path getClasspathArchive() {
        return this.directory.resolve("classpath.jar");
    }

    public Path getLibraryArchive() {
        return this.directory.resolve("library.jar");
    }

    public Path getBuildPropertiesFile() {
        return this.directory.resolve("build.properties");
    }

    public Path getProguardConfigFile() {
        return this.directory.resolve("proguard.config");
    }

    public void sanitizeProguardConfig(ProguardConfigSanitizer sanitizer) throws IOException {
        block12: {
            BufferedReader reader;
            block13: {
                reader = Files.newBufferedReader(this.getProguardConfigFile());
                Throwable throwable = null;
                try {
                    String next = reader.readLine();
                    while (next != null) {
                        sanitizer.sanitize(next);
                        next = reader.readLine();
                    }
                    if (reader == null) break block12;
                    if (throwable == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                try {
                    reader.close();
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                break block12;
            }
            reader.close();
        }
    }

    public DumpOptions getBuildProperties() throws IOException {
        if (Files.exists(this.getBuildPropertiesFile(), new LinkOption[0])) {
            DumpOptions.Builder builder = new DumpOptions.Builder();
            DumpOptions.parse(FileUtils.readTextFile(this.getBuildPropertiesFile(), StandardCharsets.UTF_8), builder);
            return builder.build();
        }
        return null;
    }
}

