/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dump;

import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.experimental.startup.StartupConfiguration;
import com.android.tools.r8.features.FeatureSplitConfiguration;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DumpOptions {
    private static final String TOOL_KEY = "tool";
    private static final String MODE_KEY = "mode";
    private static final String DEBUG_MODE_VALUE = "debug";
    private static final String RELEASE_MODE_VALUE = "release";
    private static final String MIN_API_KEY = "min-api";
    private static final String OPTIMIZE_MULTIDEX_FOR_LINEAR_ALLOC_KEY = "optimize-multidex-for-linear-alloc";
    private static final String THREAD_COUNT_KEY = "thread-count";
    private static final String DESUGAR_STATE_KEY = "desugar-state";
    private static final String INTERMEDIATE_KEY = "intermediate";
    private static final String INCLUDE_DATA_RESOURCES_KEY = "include-data-resources";
    private static final String TREE_SHAKING_KEY = "tree-shaking";
    private static final String MINIFICATION_KEY = "minification";
    private static final String FORCE_PROGUARD_COMPATIBILITY_KEY = "force-proguard-compatibility";
    private static final String SYSTEM_PROPERTY_PREFIX = "system-property-";
    private final Marker.Tool tool;
    private final CompilationMode compilationMode;
    private final int minApi;
    private final boolean optimizeMultidexForLinearAlloc;
    private final int threadCount;
    private final InternalOptions.DesugarState desugarState;
    private final Optional<Boolean> intermediate;
    private final Optional<Boolean> includeDataResources;
    private final Optional<Boolean> treeShaking;
    private final Optional<Boolean> minification;
    private final Optional<Boolean> forceProguardCompatibility;
    private final DesugaredLibrarySpecification desugaredLibrarySpecification;
    private final FeatureSplitConfiguration featureSplitConfiguration;
    private final ProguardConfiguration proguardConfiguration;
    private final List<ProguardConfigurationRule> mainDexKeepRules;
    private final Map<String, String> systemProperties;
    private final boolean dumpInputToFile;

    private DumpOptions(Marker.Tool tool, CompilationMode compilationMode, int minAPI, DesugaredLibrarySpecification desugaredLibrarySpecification, boolean optimizeMultidexForLinearAlloc, int threadCount, InternalOptions.DesugarState desugarState, Optional<Boolean> intermediate, Optional<Boolean> includeDataResources, Optional<Boolean> treeShaking, Optional<Boolean> minification, Optional<Boolean> forceProguardCompatibility, FeatureSplitConfiguration featureSplitConfiguration, ProguardConfiguration proguardConfiguration, List<ProguardConfigurationRule> mainDexKeepRules, Map<String, String> systemProperties, boolean dumpInputToFile) {
        this.tool = tool;
        this.compilationMode = compilationMode;
        this.minApi = minAPI;
        this.desugaredLibrarySpecification = desugaredLibrarySpecification;
        this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
        this.threadCount = threadCount;
        this.desugarState = desugarState;
        this.intermediate = intermediate;
        this.includeDataResources = includeDataResources;
        this.treeShaking = treeShaking;
        this.minification = minification;
        this.forceProguardCompatibility = forceProguardCompatibility;
        this.featureSplitConfiguration = featureSplitConfiguration;
        this.proguardConfiguration = proguardConfiguration;
        this.mainDexKeepRules = mainDexKeepRules;
        this.systemProperties = systemProperties;
        this.dumpInputToFile = dumpInputToFile;
    }

    public static void parse(String content, Builder builder) {
        String[] lines;
        for (String line : lines = content.split("\n")) {
            String trimmed = line.trim();
            int i = trimmed.indexOf(61);
            if (i < 0) {
                throw new RuntimeException("Invalid dump line. Expected = in line: '" + trimmed + "'");
            }
            String key = trimmed.substring(0, i).trim();
            String value = trimmed.substring(i + 1).trim();
            DumpOptions.parseKeyValue(builder, key, value);
        }
    }

    private static void parseKeyValue(Builder builder, String key, String value) {
        switch (key) {
            case "tool": {
                builder.setTool(Marker.Tool.valueOf(value));
                return;
            }
            case "mode": {
                if (value.equals(DEBUG_MODE_VALUE)) {
                    builder.setCompilationMode(CompilationMode.DEBUG);
                } else if (value.equals(RELEASE_MODE_VALUE)) {
                    builder.setCompilationMode(CompilationMode.RELEASE);
                } else {
                    DumpOptions.parseKeyValueError(key, value);
                }
                return;
            }
            case "min-api": {
                builder.setMinApi(Integer.parseInt(value));
                return;
            }
            case "optimize-multidex-for-linear-alloc": {
                builder.setOptimizeMultidexForLinearAlloc(Boolean.parseBoolean(value));
                return;
            }
            case "thread-count": {
                builder.setThreadCount(Integer.parseInt(value));
                return;
            }
            case "desugar-state": {
                builder.setDesugarState(InternalOptions.DesugarState.valueOf(value));
                return;
            }
            case "intermediate": {
                builder.setIntermediate(Boolean.parseBoolean(value));
                return;
            }
            case "include-data-resources": {
                builder.setIncludeDataResources(Optional.of(Boolean.parseBoolean(value)));
                return;
            }
            case "tree-shaking": {
                builder.setTreeShaking(Boolean.parseBoolean(value));
                return;
            }
            case "minification": {
                builder.setMinification(Boolean.parseBoolean(value));
                return;
            }
            case "force-proguard-compatibility": {
                builder.setForceProguardCompatibility(Boolean.parseBoolean(value));
                return;
            }
        }
        if (key.startsWith(SYSTEM_PROPERTY_PREFIX)) {
            builder.setSystemProperty(key.substring(SYSTEM_PROPERTY_PREFIX.length()), value);
        } else {
            DumpOptions.parseKeyValueError(key, value);
        }
    }

    private static void parseKeyValueError(String key, String value) {
        throw new RuntimeException("Unknown key value pair: " + key + " = " + value);
    }

    private void addOptionalDumpEntry(StringBuilder builder, String key, Optional<?> optionalValue) {
        optionalValue.ifPresent(bool -> this.addDumpEntry(builder, key, bool));
    }

    private void addDumpEntry(StringBuilder builder, String key, Object value) {
        builder.append(key).append("=").append(value).append("\n");
    }

    private boolean hasDesugaredLibraryConfiguration() {
        return this.desugaredLibrarySpecification != null && !this.desugaredLibrarySpecification.isEmpty();
    }

    public static Builder builder(Marker.Tool tool) {
        return new Builder().setTool(tool);
    }

    public String dumpOptions() {
        StringBuilder builder = new StringBuilder();
        this.addDumpEntry(builder, TOOL_KEY, this.tool.name());
        this.addDumpEntry(builder, MODE_KEY, this.compilationMode == CompilationMode.DEBUG ? DEBUG_MODE_VALUE : RELEASE_MODE_VALUE);
        this.addDumpEntry(builder, MIN_API_KEY, this.minApi);
        this.addDumpEntry(builder, OPTIMIZE_MULTIDEX_FOR_LINEAR_ALLOC_KEY, this.optimizeMultidexForLinearAlloc);
        if (this.threadCount != -1) {
            this.addDumpEntry(builder, THREAD_COUNT_KEY, this.threadCount);
        }
        this.addDumpEntry(builder, DESUGAR_STATE_KEY, (Object)this.desugarState);
        this.addOptionalDumpEntry(builder, INTERMEDIATE_KEY, this.intermediate);
        this.addOptionalDumpEntry(builder, INCLUDE_DATA_RESOURCES_KEY, this.includeDataResources);
        this.addOptionalDumpEntry(builder, TREE_SHAKING_KEY, this.treeShaking);
        this.addOptionalDumpEntry(builder, MINIFICATION_KEY, this.minification);
        this.addOptionalDumpEntry(builder, FORCE_PROGUARD_COMPATIBILITY_KEY, this.forceProguardCompatibility);
        ArrayList<String> sortedKeys = new ArrayList<String>(this.systemProperties.keySet());
        sortedKeys.sort(String::compareTo);
        sortedKeys.forEach(key -> this.addDumpEntry(builder, SYSTEM_PROPERTY_PREFIX + key, this.systemProperties.get(key)));
        return builder.toString();
    }

    public Marker.Tool getTool() {
        return this.tool;
    }

    public CompilationMode getCompilationMode() {
        return this.compilationMode;
    }

    public int getMinApi() {
        return this.minApi;
    }

    public String getDesugaredLibraryJsonSource() {
        if (this.hasDesugaredLibraryConfiguration()) {
            return this.desugaredLibrarySpecification.getJsonSource();
        }
        return null;
    }

    public FeatureSplitConfiguration getFeatureSplitConfiguration() {
        return this.featureSplitConfiguration;
    }

    public StartupConfiguration getStartupConfiguration() {
        return null;
    }

    public String getParsedProguardConfiguration() {
        return this.proguardConfiguration == null ? null : this.proguardConfiguration.getParsedConfiguration();
    }

    public boolean hasMainDexKeepRules() {
        return this.mainDexKeepRules != null && !this.mainDexKeepRules.isEmpty();
    }

    public List<ProguardConfigurationRule> getMainDexKeepRules() {
        return this.mainDexKeepRules;
    }

    public boolean dumpInputToFile() {
        return this.dumpInputToFile;
    }

    public static class Builder {
        private Marker.Tool tool;
        private CompilationMode compilationMode;
        private int minApi;
        private boolean optimizeMultidexForLinearAlloc;
        private int threadCount;
        private InternalOptions.DesugarState desugarState;
        private Optional<Boolean> intermediate = Optional.empty();
        private Optional<Boolean> includeDataResources = Optional.empty();
        private Optional<Boolean> treeShaking = Optional.empty();
        private Optional<Boolean> minification = Optional.empty();
        private Optional<Boolean> forceProguardCompatibility = Optional.empty();
        private DesugaredLibrarySpecification desugaredLibrarySpecification;
        private FeatureSplitConfiguration featureSplitConfiguration;
        private ProguardConfiguration proguardConfiguration;
        private List<ProguardConfigurationRule> mainDexKeepRules;
        private Map<String, String> systemProperties = new HashMap<String, String>();
        private boolean dumpInputToFile;

        public Builder setTool(Marker.Tool tool) {
            this.tool = tool;
            return this;
        }

        public Builder setCompilationMode(CompilationMode compilationMode) {
            this.compilationMode = compilationMode;
            return this;
        }

        public Builder setMinApi(int minAPI) {
            this.minApi = minAPI;
            return this;
        }

        public Builder setDesugaredLibraryConfiguration(DesugaredLibrarySpecification desugaredLibrarySpecification) {
            this.desugaredLibrarySpecification = desugaredLibrarySpecification;
            return this;
        }

        public Builder setOptimizeMultidexForLinearAlloc(boolean optimizeMultidexForLinearAlloc) {
            this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
            return this;
        }

        public Builder setThreadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Builder setDesugarState(InternalOptions.DesugarState desugarState) {
            this.desugarState = desugarState;
            return this;
        }

        public Builder setIntermediate(boolean intermediate) {
            this.intermediate = Optional.of(intermediate);
            return this;
        }

        public Builder setIncludeDataResources(Optional<Boolean> includeDataResources) {
            this.includeDataResources = includeDataResources;
            return this;
        }

        public Builder setForceProguardCompatibility(boolean forceProguardCompatibility) {
            this.forceProguardCompatibility = Optional.of(forceProguardCompatibility);
            return this;
        }

        public Builder setMinification(boolean minification) {
            this.minification = Optional.of(minification);
            return this;
        }

        public Builder setTreeShaking(boolean treeShaking) {
            this.treeShaking = Optional.of(treeShaking);
            return this;
        }

        public Builder setDumpInputToFile(boolean dumpInputToFile) {
            this.dumpInputToFile = dumpInputToFile;
            return this;
        }

        public Builder setFeatureSplitConfiguration(FeatureSplitConfiguration featureSplitConfiguration) {
            this.featureSplitConfiguration = featureSplitConfiguration;
            return this;
        }

        public Builder setProguardConfiguration(ProguardConfiguration proguardConfiguration) {
            this.proguardConfiguration = proguardConfiguration;
            return this;
        }

        public Builder setMainDexKeepRules(List<ProguardConfigurationRule> mainDexKeepRules) {
            this.mainDexKeepRules = mainDexKeepRules;
            return this;
        }

        public Builder setSystemProperty(String key, String value) {
            this.systemProperties.put(key, value);
            return this;
        }

        public Builder readCurrentSystemProperties() {
            System.getProperties().stringPropertyNames().forEach(name -> {
                if (name.startsWith("com.android.tools.r8.")) {
                    String value = System.getProperty(name);
                    this.setSystemProperty((String)name, value);
                }
            });
            return this;
        }

        public DumpOptions build() {
            assert (this.tool != null);
            return new DumpOptions(this.tool, this.compilationMode, this.minApi, this.desugaredLibrarySpecification, this.optimizeMultidexForLinearAlloc, this.threadCount, this.desugarState, this.intermediate, this.includeDataResources, this.treeShaking, this.minification, this.forceProguardCompatibility, this.featureSplitConfiguration, this.proguardConfiguration, this.mainDexKeepRules, this.systemProperties, this.dumpInputToFile);
        }
    }
}

