/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.Keep;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.Collection;

@Keep
public class DuplicateTypesDiagnostic
implements Diagnostic {
    private final ClassReference type;
    private final Collection<Origin> origins;

    public DuplicateTypesDiagnostic(ClassReference type, Collection<Origin> origins) {
        assert (type != null);
        assert (origins.size() > 1);
        this.type = type;
        this.origins = origins;
    }

    public ClassReference getType() {
        return this.type;
    }

    public Collection<Origin> getOrigins() {
        return this.origins;
    }

    @Override
    public Origin getOrigin() {
        return this.origins.iterator().next();
    }

    @Override
    public Position getPosition() {
        return Position.UNKNOWN;
    }

    @Override
    public String getDiagnosticMessage() {
        String typeName = DescriptorUtils.descriptorToJavaType(this.type.getDescriptor());
        return "Type " + typeName + " is defined multiple times: " + StringUtils.join(", ", this.origins);
    }
}

