/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors;

import com.android.tools.r8.Keep;
import com.android.tools.r8.errors.DesugarDiagnostic;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.references.ClassReference;

@Keep
public class InterfaceDesugarMissingTypeDiagnostic
implements DesugarDiagnostic {
    private final Origin origin;
    private final Position position;
    private final ClassReference missingType;
    private final ClassReference contextType;
    private final ClassReference implementingContextType;

    public InterfaceDesugarMissingTypeDiagnostic(Origin origin, Position position, ClassReference missingType, ClassReference contextType, ClassReference implementingContextType) {
        assert (origin != null);
        assert (position != null);
        assert (missingType != null);
        assert (contextType != null);
        this.origin = origin;
        this.position = position;
        this.missingType = missingType;
        this.contextType = contextType;
        this.implementingContextType = implementingContextType;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public ClassReference getMissingType() {
        return this.missingType;
    }

    public ClassReference getContextType() {
        return this.contextType;
    }

    @Override
    public String getDiagnosticMessage() {
        StringBuilder builder = new StringBuilder().append("Type `").append(this.missingType.getTypeName()).append("` was not found, ").append("it is required for default or static interface methods desugaring of `");
        if (this.position != Position.UNKNOWN) {
            builder.append(this.position.getDescription());
        } else {
            builder.append(this.contextType.getTypeName());
        }
        builder.append("`");
        if (this.implementingContextType != null) {
            builder.append(" This missing interface is declared in the direct hierarchy of `").append(this.implementingContextType).append("`");
        }
        return builder.toString();
    }
}

