/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors;

import com.android.tools.r8.Keep;
import com.android.tools.r8.errors.DesugarDiagnostic;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.utils.StringUtils;
import java.util.List;

@Keep
public class InvalidLibrarySuperclassDiagnostic
implements DesugarDiagnostic {
    private final Origin origin;
    private final List<MethodReference> methods;
    private final ClassReference libraryType;
    private final ClassReference invalidSuperType;
    private final String message;

    public InvalidLibrarySuperclassDiagnostic(Origin origin, ClassReference libraryType, ClassReference invalidSuperType, String message, List<MethodReference> methods) {
        assert (origin != null);
        assert (libraryType != null);
        assert (invalidSuperType != null);
        assert (message != null);
        this.origin = origin;
        this.libraryType = libraryType;
        this.invalidSuperType = invalidSuperType;
        this.message = message;
        this.methods = methods;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return Position.UNKNOWN;
    }

    @Override
    public String getDiagnosticMessage() {
        StringBuilder builder = new StringBuilder().append("Superclass `").append(this.invalidSuperType.getTypeName()).append("` of library class `").append(this.libraryType.getTypeName()).append("` is ").append(this.message).append(". A superclass of a library class should be a library class. This is required for the desugaring of ");
        StringUtils.append(builder, this.methods, ", ", StringUtils.BraceType.NONE);
        return builder.toString();
    }
}

