/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.experimental.startup;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class StartupConfiguration {
    private final List<DexType> startupClasses;
    private final List<DexMethod> startupMethods;

    public StartupConfiguration(List<DexType> startupClasses, List<DexMethod> startupMethods) {
        this.startupClasses = startupClasses;
        this.startupMethods = startupMethods;
    }

    public static StartupConfiguration createStartupConfiguration(DexItemFactory dexItemFactory, Reporter reporter) {
        List<String> startupDescriptors;
        String propertyValue = System.getProperty("com.android.tools.r8.startupclassdescriptors");
        if (propertyValue == null) {
            return null;
        }
        try {
            startupDescriptors = FileUtils.readAllLines(Paths.get(propertyValue, new String[0]));
        }
        catch (IOException e) {
            throw reporter.fatalError(new ExceptionDiagnostic(e));
        }
        if (startupDescriptors.isEmpty()) {
            return null;
        }
        ArrayList<DexType> startupClasses = new ArrayList<DexType>();
        ArrayList<DexMethod> startupMethods = new ArrayList<DexMethod>();
        for (String startupDescriptor : startupDescriptors) {
            if (startupDescriptor.isEmpty()) continue;
            int methodNameStartIndex = StartupConfiguration.getMethodNameStartIndex(startupDescriptor);
            if (methodNameStartIndex >= 0) {
                DexMethod startupMethod = StartupConfiguration.parseStartupMethodDescriptor(startupDescriptor, methodNameStartIndex, dexItemFactory);
                if (startupMethod != null) {
                    startupClasses.add(startupMethod.getHolderType());
                    startupMethods.add(startupMethod);
                    continue;
                }
                reporter.warning(new StringDiagnostic("Invalid descriptor for startup method: " + startupDescriptor));
                continue;
            }
            DexType startupClass = StartupConfiguration.parseStartupClassDescriptor(startupDescriptor, dexItemFactory);
            if (startupClass != null) {
                startupClasses.add(startupClass);
                continue;
            }
            reporter.warning(new StringDiagnostic("Invalid descriptor for startup class: " + startupDescriptor));
        }
        return new StartupConfiguration(startupClasses, startupMethods);
    }

    private static int getMethodNameStartIndex(String startupDescriptor) {
        int arrowIndex = startupDescriptor.indexOf("->");
        return arrowIndex >= 0 ? arrowIndex + 2 : arrowIndex;
    }

    private static DexType parseStartupClassDescriptor(String startupClassDescriptor, DexItemFactory dexItemFactory) {
        if (DescriptorUtils.isClassDescriptor(startupClassDescriptor)) {
            return dexItemFactory.createType(startupClassDescriptor);
        }
        return null;
    }

    private static DexMethod parseStartupMethodDescriptor(String startupMethodDescriptor, int methodNameStartIndex, DexItemFactory dexItemFactory) {
        String classDescriptor = startupMethodDescriptor.substring(0, methodNameStartIndex - 2);
        DexType classType = StartupConfiguration.parseStartupClassDescriptor(classDescriptor, dexItemFactory);
        if (classType == null) {
            return null;
        }
        String protoWithNameDescriptor = startupMethodDescriptor.substring(methodNameStartIndex);
        int methodNameEndIndex = protoWithNameDescriptor.indexOf(40);
        if (methodNameEndIndex <= 1) {
            return null;
        }
        String methodName = protoWithNameDescriptor.substring(methodNameEndIndex);
        String protoDescriptor = protoWithNameDescriptor.substring(methodNameEndIndex);
        DexProto proto = StartupConfiguration.parseStartupMethodProto(protoDescriptor, dexItemFactory);
        return dexItemFactory.createMethod(classType, proto, methodName);
    }

    private static DexProto parseStartupMethodProto(String protoDescriptor, DexItemFactory dexItemFactory) {
        ArrayList<DexType> parameterTypes = new ArrayList<DexType>();
        for (String parameterTypeDescriptor : DescriptorUtils.getArgumentTypeDescriptors(protoDescriptor)) {
            parameterTypes.add(dexItemFactory.createType(parameterTypeDescriptor));
        }
        String returnTypeDescriptor = DescriptorUtils.getReturnTypeDescriptor(protoDescriptor);
        DexType returnType = dexItemFactory.createType(returnTypeDescriptor);
        return dexItemFactory.createProto(returnType, parameterTypes);
    }

    public boolean hasStartupClasses() {
        return !this.startupClasses.isEmpty();
    }

    public List<DexType> getStartupClasses() {
        return this.startupClasses;
    }
}

