/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Definition;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.SuccessfulMemberResolutionResult;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.OptionalBool;

public class AccessControl {
    public static OptionalBool isClassAccessible(DexClass clazz, ProgramDefinition context, AppView<? extends AppInfoWithClassHierarchy> appView) {
        return AccessControl.isClassAccessible(clazz, context, appView.appInfo().getClassToFeatureSplitMap(), appView.getSyntheticItems());
    }

    public static OptionalBool isClassAccessible(DexClass clazz, Definition context, ClassToFeatureSplitMap classToFeatureSplitMap, SyntheticItems syntheticItems) {
        if (!clazz.isPublic() && !clazz.getType().isSamePackage(context.getContextType())) {
            return OptionalBool.FALSE;
        }
        if (clazz.isProgramClass() && context.isProgramDefinition() && !classToFeatureSplitMap.isInBaseOrSameFeatureAs(clazz.asProgramClass(), context.asProgramDefinition(), syntheticItems)) {
            return OptionalBool.UNKNOWN;
        }
        return OptionalBool.TRUE;
    }

    static OptionalBool isMemberAccessible(SuccessfulMemberResolutionResult<?, ?> resolutionResult, ProgramDefinition context, AppInfoWithClassHierarchy appInfo) {
        return AccessControl.isMemberAccessible(resolutionResult.getResolutionPair(), resolutionResult.getInitialResolutionHolder(), context.getContextClass(), appInfo);
    }

    public static OptionalBool isMemberAccessible(DexClassAndMember<?, ?> member, DexClass initialResolutionHolder, ProgramDefinition context, AppView<? extends AppInfoWithClassHierarchy> appView) {
        return AccessControl.isMemberAccessible(member, initialResolutionHolder, context.getContextClass(), appView.appInfo());
    }

    static OptionalBool isMemberAccessible(DexClassAndMember<?, ?> member, DexClass initialResolutionHolder, DexClass context, AppInfoWithClassHierarchy appInfo) {
        AccessFlags<?> memberFlags = member.getDefinition().getAccessFlags();
        OptionalBool classAccessibility = AccessControl.isClassAccessible(initialResolutionHolder, context, appInfo.getClassToFeatureSplitMap(), appInfo.getSyntheticItems());
        if (classAccessibility.isFalse()) {
            return OptionalBool.FALSE;
        }
        if (memberFlags.isPublic()) {
            return classAccessibility;
        }
        if (memberFlags.isPrivate()) {
            if (!AccessControl.isNestMate(member.getHolder(), context)) {
                return OptionalBool.FALSE;
            }
            return classAccessibility;
        }
        if (member.getHolderType().isSamePackage(context.getType())) {
            return classAccessibility;
        }
        if (memberFlags.isProtected() && appInfo.isSubtype(context.getType(), member.getHolderType())) {
            return classAccessibility;
        }
        return OptionalBool.FALSE;
    }

    private static boolean isNestMate(DexClass clazz, DexClass context) {
        if (clazz == context) {
            return true;
        }
        if (context == null) {
            assert (false) : "context should not be null";
            return false;
        }
        if (!clazz.isInANest() || !context.isInANest()) {
            return false;
        }
        return clazz.getNestHost() == context.getNestHost();
    }
}

