/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.List;
import java.util.function.BooleanSupplier;

public abstract class AccessFlags<T extends AccessFlags<T>>
implements StructuralItem<T> {
    protected static final int BASE_FLAGS = 4127;
    private static final List<String> NAMES = ImmutableList.of("public", "private", "protected", "static", "final", "synthetic");
    protected int originalFlags;
    protected int modifiedFlags;

    protected AccessFlags(int originalFlags, int modifiedFlags) {
        this.originalFlags = originalFlags;
        this.modifiedFlags = modifiedFlags;
    }

    protected static <T extends AccessFlags<T>> void specify(StructuralSpecification<T, ?> spec) {
        ((StructuralSpecification)spec.withInt(a -> a.originalFlags)).withInt(a -> a.modifiedFlags);
    }

    private boolean wasSet(int flag) {
        return AccessFlags.isSet(this.originalFlags, flag);
    }

    public static boolean isSet(int flag, int flags) {
        return (flags & flag) != 0;
    }

    private String toStringInternal(boolean ignoreSuper) {
        List<String> names = this.getNames();
        List<BooleanSupplier> predicates = this.getPredicates();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (!predicates.get(i).getAsBoolean() || ignoreSuper && names.get(i).equals("super")) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(names.get(i));
        }
        return builder.toString();
    }

    protected List<BooleanSupplier> getPredicates() {
        return ImmutableList.of(this::isPublic, this::isPrivate, this::isProtected, this::isStatic, this::isFinal, this::isSynthetic);
    }

    protected List<String> getNames() {
        return NAMES;
    }

    @Override
    public StructuralMapping<T> getStructuralMapping() {
        return AccessFlags::specify;
    }

    public abstract T copy();

    @Override
    public abstract T self();

    public int materialize() {
        return this.modifiedFlags;
    }

    public abstract int getAsCfAccessFlags();

    public abstract int getAsDexAccessFlags();

    public final int getOriginalAccessFlags() {
        return this.originalFlags;
    }

    public ClassAccessFlags asClassAccessFlags() {
        return null;
    }

    public MethodAccessFlags asMethodAccessFlags() {
        return null;
    }

    public FieldAccessFlags asFieldAccessFlags() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AccessFlags) {
            AccessFlags other = (AccessFlags)object;
            return this.originalFlags == other.originalFlags && this.modifiedFlags == other.modifiedFlags;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.originalFlags | this.modifiedFlags;
    }

    public boolean isMoreVisibleThan(AccessFlags other, String packageNameThis, String packageNameOther) {
        int visibilityOrdinal = this.getVisibilityOrdinal();
        if (visibilityOrdinal > other.getVisibilityOrdinal()) {
            return true;
        }
        return visibilityOrdinal == other.getVisibilityOrdinal() && this.isVisibilityDependingOnPackage() && !packageNameThis.equals(packageNameOther);
    }

    public boolean isAtLeastAsVisibleAs(AccessFlags other) {
        return this.getVisibilityOrdinal() >= other.getVisibilityOrdinal();
    }

    public boolean isSameVisibility(AccessFlags other) {
        return this.getVisibilityOrdinal() == other.getVisibilityOrdinal();
    }

    public int getVisibilityOrdinal() {
        if (this.isPublic()) {
            return 3;
        }
        if (this.isProtected()) {
            return 2;
        }
        if (this.isPrivate()) {
            return 0;
        }
        return 1;
    }

    public boolean isVisibilityDependingOnPackage() {
        return this.getVisibilityOrdinal() == 1 || this.getVisibilityOrdinal() == 2;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isPackagePrivateOrProtected() {
        return !this.isPublic() && !this.isPrivate();
    }

    public boolean isPublic() {
        return this.isSet(1);
    }

    public void setPublic() {
        assert (!this.isPrivate() && !this.isProtected());
        this.set(1);
    }

    public void unsetPublic() {
        this.unset(1);
    }

    public boolean isPrivate() {
        return this.isSet(2);
    }

    public void setPrivate() {
        assert (!this.isPublic() && !this.isProtected());
        this.set(2);
    }

    public void unsetPrivate() {
        this.unset(2);
    }

    public boolean isProtected() {
        return this.isSet(4);
    }

    public void setProtected() {
        assert (!this.isPublic() && !this.isPrivate());
        this.set(4);
    }

    public void unsetProtected() {
        this.unset(4);
    }

    public boolean isStatic() {
        return this.isSet(8);
    }

    public void setStatic() {
        this.set(8);
    }

    public boolean isOpen() {
        return !this.isFinal();
    }

    public boolean isFinal() {
        return this.isSet(16);
    }

    public void setFinal() {
        this.set(16);
    }

    public T unsetFinal() {
        this.unset(16);
        return (T)this.self();
    }

    public boolean isSynthetic() {
        return this.isSet(4096);
    }

    public void setSynthetic() {
        this.set(4096);
    }

    public T unsetSynthetic() {
        this.unset(4096);
        return (T)this.self();
    }

    public void demoteFromSynthetic() {
        this.demote(4096);
    }

    public void promoteToFinal() {
        this.promote(16);
    }

    public T demoteFromFinal() {
        this.demote(16);
        return (T)this.self();
    }

    public boolean isPromotedToPublic() {
        return this.isPromoted(1);
    }

    public void promoteToPublic() {
        this.demote(6);
        this.promote(1);
    }

    public void promoteToStatic() {
        this.promote(8);
    }

    protected boolean isSet(int flag) {
        return AccessFlags.isSet(this.modifiedFlags, flag);
    }

    protected void set(int flag) {
        this.originalFlags |= flag;
        this.modifiedFlags |= flag;
    }

    protected void unset(int flag) {
        this.originalFlags &= ~flag;
        this.modifiedFlags &= ~flag;
    }

    protected boolean isPromoted(int flag) {
        return !this.wasSet(flag) && this.isSet(flag);
    }

    protected void promote(int flag) {
        this.modifiedFlags |= flag;
    }

    protected void demote(int flag) {
        this.modifiedFlags &= ~flag;
    }

    public String toSmaliString() {
        return this.toStringInternal(true);
    }

    public String toString() {
        return this.toStringInternal(false);
    }

    static abstract class BuilderBase<B extends BuilderBase<B, F>, F extends AccessFlags<F>> {
        protected F flags;

        BuilderBase(F flags) {
            this.flags = flags;
        }

        public B setPackagePrivate() {
            assert (((AccessFlags)this.flags).isPackagePrivate());
            return this.self();
        }

        public B setPrivate(boolean value) {
            if (value) {
                ((AccessFlags)this.flags).setPrivate();
            } else {
                ((AccessFlags)this.flags).unsetPrivate();
            }
            return this.self();
        }

        public B setProtected(boolean value) {
            if (value) {
                ((AccessFlags)this.flags).setProtected();
            } else {
                ((AccessFlags)this.flags).unsetProtected();
            }
            return this.self();
        }

        public B setPublic() {
            return this.setPublic(true);
        }

        public B setPublic(boolean value) {
            if (value) {
                ((AccessFlags)this.flags).setPublic();
            } else {
                ((AccessFlags)this.flags).unsetPublic();
            }
            return this.self();
        }

        public B setStatic() {
            ((AccessFlags)this.flags).setStatic();
            return this.self();
        }

        public B setSynthetic() {
            ((AccessFlags)this.flags).setSynthetic();
            return this.self();
        }

        public F build() {
            return this.flags;
        }

        public abstract B self();
    }
}

