/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriter;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.synthesis.CommittedItems;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class AppInfo
implements DexDefinitionSupplier {
    private final DexApplication app;
    private final DexItemFactory dexItemFactory;
    private final MainDexInfo mainDexInfo;
    private final SyntheticItems syntheticItems;
    private final BooleanBox obsolete;

    public static AppInfo createInitialAppInfo(DexApplication application) {
        return AppInfo.createInitialAppInfo(application, MainDexInfo.none());
    }

    public static AppInfo createInitialAppInfo(DexApplication application, MainDexInfo mainDexInfo) {
        return new AppInfo(SyntheticItems.createInitialSyntheticItems(application), mainDexInfo);
    }

    public AppInfo(CommittedItems committedItems, MainDexInfo mainDexInfo) {
        this(committedItems.getApplication(), committedItems.toSyntheticItems(), mainDexInfo, new BooleanBox());
    }

    AppInfo(AppInfoWithClassHierarchy.CreateDesugaringViewOnAppInfo witness, AppInfo appInfo) {
        this(appInfo.app, appInfo.syntheticItems, appInfo.mainDexInfo, appInfo.obsolete);
        assert (witness != null);
    }

    private AppInfo(DexApplication application, SyntheticItems syntheticItems, MainDexInfo mainDexInfo, BooleanBox obsolete) {
        this.app = application;
        this.dexItemFactory = application.dexItemFactory;
        this.mainDexInfo = mainDexInfo;
        this.syntheticItems = syntheticItems;
        this.obsolete = obsolete;
    }

    public AppInfo prunedCopyFrom(PrunedItems prunedItems, ExecutorService executorService) throws ExecutionException {
        assert (this.getClass() == AppInfo.class);
        assert (this.checkIfObsolete());
        assert (prunedItems.getPrunedApp() == this.app());
        if (prunedItems.isEmpty()) {
            return this;
        }
        return new AppInfo(this.getSyntheticItems().commitPrunedItems(prunedItems), this.getMainDexInfo().withoutPrunedItems(prunedItems));
    }

    public AppInfo rebuildWithMainDexInfo(MainDexInfo mainDexInfo) {
        assert (this.checkIfObsolete());
        return new AppInfo(this.app, this.syntheticItems, mainDexInfo, new BooleanBox());
    }

    protected InternalOptions options() {
        return this.app.options;
    }

    public boolean isObsolete() {
        return this.obsolete.get();
    }

    public void markObsolete() {
        this.obsolete.set();
    }

    public void unsetObsolete() {
        this.obsolete.unset();
    }

    public boolean checkIfObsolete() {
        assert (!this.isObsolete());
        return true;
    }

    public DexApplication app() {
        assert (this.checkIfObsolete());
        return this.app;
    }

    @Override
    public DexItemFactory dexItemFactory() {
        assert (this.checkIfObsolete());
        return this.dexItemFactory;
    }

    public MainDexInfo getMainDexInfo() {
        assert (this.checkIfObsolete());
        return this.mainDexInfo;
    }

    public SyntheticItems getSyntheticItems() {
        assert (this.checkIfObsolete());
        return this.syntheticItems;
    }

    public Collection<DexProgramClass> classes() {
        assert (this.checkIfObsolete());
        return this.app.classes();
    }

    public Collection<DexProgramClass> classesWithDeterministicOrder() {
        assert (this.checkIfObsolete());
        return this.app.classesWithDeterministicOrder();
    }

    public void forEachMethod(Consumer<ProgramMethod> consumer) {
        for (DexProgramClass clazz : this.classes()) {
            clazz.forEachProgramMethod(consumer);
        }
    }

    @Override
    public ClassResolutionResult contextIndependentDefinitionForWithResolutionResult(DexType type) {
        assert (this.checkIfObsolete());
        return this.syntheticItems.definitionFor(type, this.app::contextIndependentDefinitionForWithResolutionResult);
    }

    @Override
    public DexClass definitionFor(DexType type) {
        return this.definitionForWithoutExistenceAssert(type);
    }

    public final DexClass definitionForWithoutExistenceAssert(DexType type) {
        assert (this.checkIfObsolete());
        return this.syntheticItems.definitionFor(type, this.app::contextIndependentDefinitionForWithResolutionResult).toSingleClassWithProgramOverLibrary();
    }

    public DexClass definitionForDesugarDependency(DexClass dependent, DexType type) {
        if (dependent.type == type) {
            return dependent;
        }
        DexClass definition = this.definitionFor(type);
        if (definition != null && !definition.isLibraryClass() && !dependent.isLibraryClass()) {
            InterfaceMethodRewriter.reportDependencyEdge(dependent, definition, this);
        }
        return definition;
    }

    public DexProgramClass unsafeDirectProgramTypeLookup(DexType type) {
        return this.app.programDefinitionFor(type);
    }

    public Origin originFor(DexType type) {
        assert (this.checkIfObsolete());
        DexClass definition = this.app.definitionFor(type);
        return definition == null ? Origin.unknown() : definition.origin;
    }

    public final DexEncodedMethod lookupStaticTargetOnItself(DexMethod method, ProgramMethod context) {
        if (method.holder != context.getHolderType()) {
            return null;
        }
        DexEncodedMethod singleTarget = context.getHolder().lookupDirectMethod(method);
        if (singleTarget != null && singleTarget.isStatic()) {
            return singleTarget;
        }
        return null;
    }

    public final DexEncodedMethod lookupDirectTargetOnItself(DexMethod method, ProgramMethod context) {
        if (method.holder != context.getHolderType()) {
            return null;
        }
        DexEncodedMethod singleTarget = context.getHolder().lookupDirectMethod(method);
        if (singleTarget != null && !singleTarget.isStatic()) {
            return singleTarget;
        }
        return null;
    }

    public boolean hasClassHierarchy() {
        assert (this.checkIfObsolete());
        return false;
    }

    public AppInfoWithClassHierarchy withClassHierarchy() {
        assert (this.checkIfObsolete());
        return null;
    }

    public boolean hasLiveness() {
        assert (this.checkIfObsolete());
        return false;
    }

    public AppInfoWithLiveness withLiveness() {
        assert (this.checkIfObsolete());
        return null;
    }

    public final FieldResolutionResult resolveField(DexField field, ProgramMethod context) {
        return this.resolveFieldOn(field.holder, field, context);
    }

    public FieldResolutionResult resolveFieldOn(DexType type, DexField field, ProgramMethod context) {
        if (type != context.getHolderType()) {
            return FieldResolutionResult.failure();
        }
        DexProgramClass clazz = context.getHolder();
        DexEncodedField definition = clazz.lookupField(field);
        return definition != null ? FieldResolutionResult.createSingleFieldResolutionResult(clazz, clazz, definition) : FieldResolutionResult.unknown();
    }
}

