/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolution;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.ir.analysis.type.InterfaceCollection;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.shaking.MissingClasses;
import com.android.tools.r8.synthesis.CommittedItems;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.TraversalContinuation;
import com.android.tools.r8.utils.TriConsumer;
import com.android.tools.r8.utils.TriFunction;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class AppInfoWithClassHierarchy
extends AppInfo {
    private static final CreateDesugaringViewOnAppInfo WITNESS = new CreateDesugaringViewOnAppInfo();
    private final ClassToFeatureSplitMap classToFeatureSplitMap;
    private final MissingClasses missingClasses;

    public static AppInfoWithClassHierarchy createInitialAppInfoWithClassHierarchy(DexApplication application, ClassToFeatureSplitMap classToFeatureSplitMap, MainDexInfo mainDexInfo) {
        return new AppInfoWithClassHierarchy(SyntheticItems.createInitialSyntheticItems(application), classToFeatureSplitMap, mainDexInfo, MissingClasses.empty());
    }

    protected AppInfoWithClassHierarchy(CommittedItems committedItems, ClassToFeatureSplitMap classToFeatureSplitMap, MainDexInfo mainDexInfo, MissingClasses missingClasses) {
        super(committedItems, mainDexInfo);
        this.classToFeatureSplitMap = classToFeatureSplitMap;
        this.missingClasses = missingClasses;
    }

    private AppInfoWithClassHierarchy(CreateDesugaringViewOnAppInfo witness, AppInfo appInfo) {
        super(witness, appInfo);
        this.classToFeatureSplitMap = ClassToFeatureSplitMap.createEmptyClassToFeatureSplitMap();
        this.missingClasses = MissingClasses.empty();
    }

    public static AppInfoWithClassHierarchy createForDesugaring(AppInfo appInfo) {
        assert (!appInfo.hasClassHierarchy());
        return new AppInfoWithClassHierarchy(WITNESS, appInfo);
    }

    private boolean isInterfaceInSuperTypes(DexProgramClass clazz, DexType ifaceToFind, WorkList<DexType> workList) {
        workList.addIfNotSeen(clazz.allImmediateSupertypes());
        while (workList.hasNext()) {
            DexType superType = workList.next();
            if (superType == ifaceToFind) {
                return true;
            }
            DexClass superClass = this.definitionFor(superType);
            if (superClass == null) continue;
            workList.addIfNotSeen(superClass.allImmediateSupertypes());
        }
        return false;
    }

    private List<DexProgramClass> computeChainInClassHierarchy(DexProgramClass subClass, DexType superType) {
        assert (this.isSubtype(subClass.type, superType));
        assert (!subClass.isInterface());
        assert (superType == this.dexItemFactory().objectType || this.definitionFor(superType) == null || !this.definitionFor(superType).isInterface());
        ArrayList<DexProgramClass> relationChain = new ArrayList<DexProgramClass>();
        DexClass current = subClass;
        while (current != null) {
            if (((DexDefinition)current).isProgramClass()) {
                relationChain.add(((DexDefinition)current).asProgramClass());
            }
            if (current.type == superType) {
                return relationChain;
            }
            current = this.definitionFor(current.superType);
        }
        return relationChain;
    }

    private MethodResolutionResult resolveMethodOnArray(DexType holder, DexProto methodProto, DexString methodName) {
        assert (this.checkIfObsolete());
        assert (holder.isArrayType());
        if (methodName == this.dexItemFactory().cloneMethodName) {
            return MethodResolutionResult.ArrayCloneMethodResult.INSTANCE;
        }
        return this.resolveMethodOnClass(methodProto, methodName, this.dexItemFactory().objectType);
    }

    private MethodResolutionResult resolveMethodOnClassStep2(DexClass clazz, DexProto methodProto, DexString methodName, DexClass initialResolutionHolder) {
        DexClass superClass;
        DexEncodedMethod result = clazz.lookupSignaturePolymorphicMethod(methodName, this.dexItemFactory());
        if (result != null) {
            return new MethodResolutionResult.SingleResolutionResult(initialResolutionHolder, clazz, result);
        }
        result = clazz.lookupMethod(methodProto, methodName);
        if (result != null) {
            if (result.isPrivateMethod() && clazz != initialResolutionHolder) {
                return new MethodResolutionResult.IllegalAccessOrNoSuchMethodResult(initialResolutionHolder, result);
            }
            return new MethodResolutionResult.SingleResolutionResult(initialResolutionHolder, clazz, result);
        }
        if (clazz.superType != null && (superClass = this.definitionFor(clazz.superType)) != null) {
            return this.resolveMethodOnClassStep2(superClass, methodProto, methodName, initialResolutionHolder);
        }
        return null;
    }

    private MethodResolutionResult resolveMethodStep3(DexClass clazz, DexProto methodProto, DexString methodName) {
        MaximallySpecificMethodsBuilder builder = new MaximallySpecificMethodsBuilder();
        this.resolveMethodStep3Helper(methodProto, methodName, clazz, builder);
        return builder.resolve(clazz);
    }

    private MaximallySpecificMethodsBuilder resolveMaximallySpecificTargetHelper(DexClass clazz, DexMethod method) {
        MaximallySpecificMethodsBuilder builder = new MaximallySpecificMethodsBuilder();
        this.resolveMethodStep3Helper(method.getProto(), method.getName(), clazz, builder);
        return builder;
    }

    private MaximallySpecificMethodsBuilder resolveMaximallySpecificTargetHelper(LambdaDescriptor lambda, DexMethod method) {
        MaximallySpecificMethodsBuilder builder = new MaximallySpecificMethodsBuilder();
        this.resolveMethodStep3Helper(method.getProto(), method.getName(), this.dexItemFactory().objectType, lambda.interfaces, builder);
        return builder;
    }

    private void resolveMethodStep3Helper(DexProto methodProto, DexString methodName, DexClass clazz, MaximallySpecificMethodsBuilder builder) {
        this.resolveMethodStep3Helper(methodProto, methodName, clazz.superType, Arrays.asList(clazz.interfaces.values), builder);
    }

    private void resolveMethodStep3Helper(DexProto methodProto, DexString methodName, DexType superType, List<DexType> interfaces, MaximallySpecificMethodsBuilder builder) {
        DexClass superClass;
        for (DexType iface : interfaces) {
            DexClass definition = this.definitionFor(iface);
            if (definition == null) continue;
            assert (definition.isInterface());
            DexEncodedMethod result = definition.lookupMethod(methodProto, methodName);
            if (this.isMaximallySpecificCandidate(result)) {
                builder.addCandidate(definition, result, this);
                continue;
            }
            this.resolveMethodStep3Helper(methodProto, methodName, definition, builder);
        }
        if (superType != null && (superClass = this.definitionFor(superType)) != null) {
            this.resolveMethodStep3Helper(methodProto, methodName, superClass, builder);
        }
    }

    private boolean isMaximallySpecificCandidate(DexEncodedMethod method) {
        return method != null && !method.accessFlags.isPrivate() && !method.accessFlags.isStatic();
    }

    public final AppInfoWithClassHierarchy rebuildWithClassHierarchy(CommittedItems commit) {
        return new AppInfoWithClassHierarchy(commit, this.getClassToFeatureSplitMap(), this.getMainDexInfo(), this.getMissingClasses());
    }

    public AppInfoWithClassHierarchy rebuildWithClassHierarchy(Function<DexApplication, DexApplication> fn) {
        assert (this.checkIfObsolete());
        return new AppInfoWithClassHierarchy(this.getSyntheticItems().commit(fn.apply(this.app())), this.getClassToFeatureSplitMap(), this.getMainDexInfo(), this.getMissingClasses());
    }

    @Override
    public AppInfoWithClassHierarchy rebuildWithMainDexInfo(MainDexInfo mainDexInfo) {
        assert (this.getClass() == AppInfoWithClassHierarchy.class);
        assert (this.checkIfObsolete());
        return new AppInfoWithClassHierarchy(this.getSyntheticItems().commit(this.app()), this.getClassToFeatureSplitMap(), mainDexInfo, this.getMissingClasses());
    }

    @Override
    public AppInfoWithClassHierarchy prunedCopyFrom(PrunedItems prunedItems, ExecutorService executorService) throws ExecutionException {
        assert (this.getClass() == AppInfoWithClassHierarchy.class);
        assert (this.checkIfObsolete());
        assert (prunedItems.getPrunedApp() == this.app());
        if (prunedItems.isEmpty()) {
            return this;
        }
        return new AppInfoWithClassHierarchy(this.getSyntheticItems().commitPrunedItems(prunedItems), this.getClassToFeatureSplitMap().withoutPrunedItems(prunedItems), this.getMainDexInfo().withoutPrunedItems(prunedItems), this.getMissingClasses());
    }

    public ClassToFeatureSplitMap getClassToFeatureSplitMap() {
        return this.classToFeatureSplitMap;
    }

    public MissingClasses getMissingClasses() {
        return this.missingClasses;
    }

    @Override
    public boolean hasClassHierarchy() {
        assert (this.checkIfObsolete());
        return true;
    }

    @Override
    public AppInfoWithClassHierarchy withClassHierarchy() {
        assert (this.checkIfObsolete());
        return this;
    }

    public <T> TraversalContinuation<T> traverseSuperClasses(DexClass clazz, TriFunction<DexType, DexClass, DexClass, TraversalContinuation<T>> fn) {
        DexClass currentClass = clazz;
        while (currentClass != null && currentClass.getSuperType() != null) {
            DexClass superclass = this.definitionFor(currentClass.getSuperType());
            TraversalContinuation<T> stepResult = fn.apply(currentClass.getSuperType(), superclass, currentClass);
            if (stepResult.shouldBreak()) {
                return stepResult;
            }
            currentClass = superclass;
        }
        return TraversalContinuation.doContinue();
    }

    public TraversalContinuation<?> traverseSuperTypes(DexClass clazz, TriFunction<DexType, DexClass, Boolean, TraversalContinuation<?>> fn) {
        int interfaceCount = 0;
        DexClass currentClass = clazz;
        while (currentClass != null) {
            interfaceCount += currentClass.interfaces.values.length;
            if (currentClass.superType == null) break;
            TraversalContinuation<?> stepResult = fn.apply(currentClass.superType, currentClass, false);
            if (stepResult.shouldBreak()) {
                return stepResult;
            }
            currentClass = this.definitionFor(currentClass.superType);
        }
        if (interfaceCount == 0) {
            return TraversalContinuation.doContinue();
        }
        Set<DexType> seen = Sets.newIdentityHashSet();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        DexClass currentClass2 = clazz;
        while (currentClass2 != null) {
            for (DexType iface : currentClass2.interfaces.values) {
                if (!seen.add(iface)) continue;
                TraversalContinuation<?> stepResult = fn.apply(iface, currentClass2, true);
                if (stepResult.shouldBreak()) {
                    return stepResult;
                }
                worklist.addLast(iface);
            }
            if (currentClass2.superType == null) break;
            currentClass2 = this.definitionFor(currentClass2.superType);
        }
        while (!worklist.isEmpty()) {
            DexType type = (DexType)worklist.removeFirst();
            DexClass definition = this.definitionFor(type);
            if (definition == null) continue;
            for (DexType iface : definition.interfaces.values) {
                if (!seen.add(iface)) continue;
                TraversalContinuation<?> stepResult = fn.apply(iface, definition, true);
                if (stepResult.shouldBreak()) {
                    return stepResult;
                }
                worklist.addLast(iface);
            }
        }
        return TraversalContinuation.doContinue();
    }

    public void forEachSuperType(DexClass clazz, TriConsumer<DexType, DexClass, Boolean> fn) {
        this.traverseSuperTypes(clazz, (superType, subclass, isInterface) -> {
            fn.accept((DexType)superType, (DexClass)subclass, (Boolean)isInterface);
            return TraversalContinuation.doContinue();
        });
    }

    public boolean isSubtype(DexType subtype, DexType supertype) {
        assert (subtype != null);
        assert (supertype != null);
        assert (subtype.isClassType());
        assert (supertype.isClassType());
        return subtype == supertype || this.isStrictSubtypeOf(subtype, supertype);
    }

    public boolean isStrictSubtypeOf(DexType subtype, DexType supertype) {
        assert (subtype != null);
        assert (supertype != null);
        assert (subtype.isClassType());
        assert (supertype.isClassType());
        if (subtype == supertype) {
            return false;
        }
        if (subtype == this.dexItemFactory().objectType) {
            return false;
        }
        if (supertype == this.dexItemFactory().objectType) {
            return true;
        }
        if (!subtype.isClassType() || !supertype.isClassType()) {
            return false;
        }
        DexClass clazz = this.definitionFor(subtype);
        if (clazz == null) {
            return false;
        }
        return this.traverseSuperTypes(clazz, (superType, subclass, isInterface) -> superType == supertype ? TraversalContinuation.doBreak() : TraversalContinuation.doContinue()).shouldBreak();
    }

    public boolean isSubtype(DexClass subclass, DexClass superclass) {
        return superclass.isInterface() ? this.isSubtype(subclass.getType(), superclass.getType()) : this.isSubtypeOfClass(subclass, superclass);
    }

    public boolean isSubtypeOfClass(DexClass subclass, DexClass superclass) {
        assert (subclass != null);
        assert (superclass != null);
        assert (!superclass.isInterface());
        if (subclass.isInterface()) {
            return superclass.getType() == this.dexItemFactory().objectType;
        }
        return subclass == superclass || this.isStrictSubtypeOfClass(subclass, superclass);
    }

    public boolean isStrictSubtypeOfClass(DexClass subclass, DexClass superclass) {
        assert (subclass != null);
        assert (superclass != null);
        assert (!subclass.isInterface());
        assert (!superclass.isInterface());
        if (subclass == superclass) {
            return false;
        }
        if (subclass.getType() == this.dexItemFactory().objectType) {
            return false;
        }
        if (superclass.getType() == this.dexItemFactory().objectType) {
            return true;
        }
        TraversalContinuation result = this.traverseSuperClasses(subclass, (currentType, currentClass, immediateSubclass) -> {
            if (currentType == superclass.getType()) {
                return TraversalContinuation.doBreak(true);
            }
            if (currentClass == null) {
                return TraversalContinuation.doBreak(false);
            }
            if (superclass.isProgramClass() && !currentClass.isProgramClass()) {
                return TraversalContinuation.doBreak(false);
            }
            return TraversalContinuation.doContinue();
        });
        return result.isBreak() && (Boolean)result.asBreak().getValue() != false;
    }

    public boolean inSameHierarchy(DexType type, DexType other) {
        assert (type.isClassType());
        assert (other.isClassType());
        return this.isSubtype(type, other) || this.isSubtype(other, type);
    }

    public boolean inDifferentHierarchy(DexType type1, DexType type2) {
        return !this.inSameHierarchy(type1, type2);
    }

    public boolean isMissingOrHasMissingSuperType(DexType type) {
        DexClass clazz = this.definitionFor(type);
        return clazz == null || clazz.hasMissingSuperType(this);
    }

    public InterfaceCollection implementedInterfaces(DexType type) {
        assert (type.isClassType());
        DexClass clazz = this.definitionFor(type);
        if (clazz == null) {
            return InterfaceCollection.empty();
        }
        if (clazz.superType == this.dexItemFactory().objectType && clazz.interfaces.isEmpty()) {
            return clazz.isInterface() ? InterfaceCollection.singleton(type) : InterfaceCollection.empty();
        }
        InterfaceCollection.Builder builder = InterfaceCollection.builder();
        if (clazz.isInterface()) {
            builder.addInterface(type, true);
        }
        Set<DexType> seenAndKnown = Sets.newIdentityHashSet();
        ArrayDeque<Pair<DexClass, Boolean>> worklist = new ArrayDeque<Pair<DexClass, Boolean>>();
        DexClass implementor = clazz;
        while (implementor != null) {
            for (DexType iface : implementor.interfaces) {
                DexClass definition;
                if (seenAndKnown.contains(iface)) continue;
                boolean isKnown = InterfaceCollection.isKnownToImplement(iface, implementor.getType(), this.options());
                builder.addInterface(iface, isKnown);
                if (isKnown) {
                    seenAndKnown.add(iface);
                }
                if ((definition = this.definitionFor(iface)) == null || definition.interfaces.isEmpty()) continue;
                worklist.add(new Pair<DexClass, Boolean>(definition, isKnown));
            }
            if (implementor.superType == null || implementor.superType == this.options().dexItemFactory().objectType) break;
            implementor = this.definitionFor(implementor.superType);
        }
        while (!worklist.isEmpty()) {
            Pair item = (Pair)worklist.poll();
            DexClass implementor2 = (DexClass)item.getFirst();
            assert (!implementor2.interfaces.isEmpty());
            for (DexType itf : implementor2.interfaces) {
                DexClass definition;
                if (seenAndKnown.contains(itf)) continue;
                boolean isKnown = (Boolean)item.getSecond() != false && InterfaceCollection.isKnownToImplement(itf, implementor2.getType(), this.options());
                builder.addInterface(itf, isKnown);
                if (isKnown) {
                    seenAndKnown.add(itf);
                }
                if ((definition = this.definitionFor(itf)) == null || definition.interfaces.isEmpty()) continue;
                worklist.add(new Pair<DexClass, Boolean>(definition, isKnown));
            }
        }
        return builder.build();
    }

    public boolean isExternalizable(DexType type) {
        return this.isSubtype(type, this.dexItemFactory().externalizableType);
    }

    public boolean isSerializable(DexType type) {
        return this.isSubtype(type, this.dexItemFactory().serializableType);
    }

    public List<DexProgramClass> computeProgramClassRelationChain(DexProgramClass subClass, DexProgramClass superClass) {
        assert (this.isSubtype(subClass.type, superClass.type));
        assert (!subClass.isInterface());
        if (!superClass.isInterface()) {
            return this.computeChainInClassHierarchy(subClass, superClass.type);
        }
        List<DexProgramClass> relationChain = this.computeChainInClassHierarchy(subClass, this.dexItemFactory().objectType);
        WorkList<DexType> interfaceWorklist = WorkList.newIdentityWorkList();
        for (int i = relationChain.size() - 1; i >= 0; --i) {
            DexProgramClass clazz = relationChain.get(i);
            if (!this.isInterfaceInSuperTypes(clazz, superClass.type, interfaceWorklist)) continue;
            return relationChain.subList(0, i + 1);
        }
        return Collections.emptyList();
    }

    public boolean methodDefinedInInterfaces(DexEncodedMethod method, DexType implementingClass) {
        DexClass holder = this.definitionFor(implementingClass);
        if (holder == null) {
            return false;
        }
        for (DexType iface : holder.interfaces.values) {
            if (!this.methodDefinedInInterface(method, iface)) continue;
            return true;
        }
        return false;
    }

    public boolean methodDefinedInInterface(DexEncodedMethod method, DexType iface) {
        DexClass potentialHolder = this.definitionFor(iface);
        if (potentialHolder == null) {
            return false;
        }
        assert (potentialHolder.isInterface());
        for (DexEncodedMethod virtualMethod : potentialHolder.virtualMethods()) {
            if (!((DexMethod)virtualMethod.getReference()).match((DexMethod)method.getReference()) || !virtualMethod.accessFlags.isSameVisibility(method.accessFlags)) continue;
            return true;
        }
        for (DexType parentInterface : potentialHolder.interfaces.values) {
            if (!this.methodDefinedInInterface(method, parentInterface)) continue;
            return true;
        }
        return false;
    }

    public DexClassAndMethod lookupMaximallySpecificMethod(DexClass clazz, DexMethod method) {
        return this.lookupMaximallySpecificTarget(clazz, method);
    }

    public DexClassAndMethod lookupMaximallySpecificMethod(LambdaDescriptor lambda, DexMethod method) {
        return this.lookupMaximallySpecificTarget(lambda, method);
    }

    public DexEncodedField lookupInstanceTargetOn(DexType type, DexField field) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        DexEncodedField result = this.resolveFieldOn(type, field).getResolvedField();
        return result == null || result.accessFlags.isStatic() ? null : result;
    }

    public DexEncodedField lookupInstanceTarget(DexField field) {
        return this.lookupInstanceTargetOn(field.holder, field);
    }

    public DexClassAndField lookupStaticTargetOn(DexType type, DexField field) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        DexClassAndField result = this.resolveFieldOn(type, field).getResolutionPair();
        return result == null || !result.getAccessFlags().isStatic() ? null : result;
    }

    public DexClassAndField lookupStaticTarget(DexField field) {
        return this.lookupStaticTargetOn(field.getHolderType(), field);
    }

    public DexEncodedMethod lookupStaticTarget(DexMethod method, DexProgramClass context) {
        assert (this.checkIfObsolete());
        return this.unsafeResolveMethodDueToDexFormat(method).lookupInvokeStaticTarget(context, this);
    }

    public DexEncodedMethod lookupStaticTarget(DexMethod method, ProgramMethod context) {
        return this.lookupStaticTarget(method, context.getHolder());
    }

    public DexClassAndMethod lookupSuperTarget(DexMethod method, DexProgramClass context) {
        assert (this.checkIfObsolete());
        return this.unsafeResolveMethodDueToDexFormat(method).lookupInvokeSuperTarget(context, this);
    }

    public DexClassAndMethod lookupSuperTarget(DexMethod method, ProgramMethod context) {
        return this.lookupSuperTarget(method, context.getHolder());
    }

    public DexEncodedMethod lookupDirectTarget(DexMethod method, DexProgramClass context) {
        assert (this.checkIfObsolete());
        return this.unsafeResolveMethodDueToDexFormat(method).lookupInvokeDirectTarget(context, this);
    }

    public DexEncodedMethod lookupDirectTarget(DexMethod method, ProgramMethod context) {
        return this.lookupDirectTarget(method, context.getHolder());
    }

    public MethodResolutionResult unsafeResolveMethodDueToDexFormat(DexMethod method) {
        assert (this.checkIfObsolete());
        DexType holder = method.holder;
        if (holder.isArrayType()) {
            return this.resolveMethodOnArray(holder, method.getProto(), method.getName());
        }
        DexClass definition = this.definitionFor(holder);
        if (definition == null) {
            return MethodResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        return this.resolveMethodOn(definition, method);
    }

    public MethodResolutionResult resolveMethod(DexMethod method, boolean isInterface) {
        return isInterface ? this.resolveMethodOnInterface(method.holder, method) : this.resolveMethodOnClass(method, method.holder);
    }

    public MethodResolutionResult resolveMethodOn(DexClass holder, DexMethod method) {
        return this.resolveMethodOn(holder, method.getProto(), method.getName());
    }

    public MethodResolutionResult resolveMethodOn(DexClass holder, DexMethodSignature method) {
        return this.resolveMethodOn(holder, method.getProto(), method.getName());
    }

    public MethodResolutionResult resolveMethodOn(DexClass holder, DexProto methodProto, DexString methodName) {
        return holder.isInterface() ? this.resolveMethodOnInterface(holder, methodProto, methodName) : this.resolveMethodOnClass(methodProto, methodName, holder);
    }

    public MethodResolutionResult resolveMethodOn(DexType holder, DexMethod method, boolean isInterface) {
        assert (this.checkIfObsolete());
        return isInterface ? this.resolveMethodOnInterface(holder, method) : this.resolveMethodOnClass(method, holder);
    }

    public MethodResolutionResult resolveMethodOnClass(DexMethod method) {
        return this.resolveMethodOnClass(method.getProto(), method.getName(), method.getHolderType());
    }

    public MethodResolutionResult resolveMethodOnClass(DexMethod method, DexType holder) {
        return this.resolveMethodOnClass(method.getProto(), method.getName(), holder);
    }

    public MethodResolutionResult resolveMethodOnClass(DexProto methodProto, DexString methodName, DexType holder) {
        assert (this.checkIfObsolete());
        if (holder.isArrayType()) {
            return this.resolveMethodOnArray(holder, methodProto, methodName);
        }
        DexClass clazz = this.definitionFor(holder);
        if (clazz == null) {
            return MethodResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        if (clazz.isInterface()) {
            return MethodResolutionResult.IncompatibleClassResult.INSTANCE;
        }
        return this.resolveMethodOnClass(methodProto, methodName, clazz);
    }

    public MethodResolutionResult resolveMethodOnClass(DexMethodSignature method, DexType holder) {
        assert (this.checkIfObsolete());
        if (holder.isArrayType()) {
            return this.resolveMethodOnArray(holder, method.getProto(), method.getName());
        }
        DexClass clazz = this.definitionFor(holder);
        if (clazz == null) {
            return MethodResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        if (clazz.isInterface()) {
            return MethodResolutionResult.IncompatibleClassResult.INSTANCE;
        }
        return this.resolveMethodOnClass(method, clazz);
    }

    public MethodResolutionResult resolveMethodOnClass(DexMethod method, DexClass clazz) {
        return this.resolveMethodOnClass(method.getProto(), method.getName(), clazz);
    }

    public MethodResolutionResult resolveMethodOnClass(DexMethodSignature method, DexClass clazz) {
        return this.resolveMethodOnClass(method.getProto(), method.getName(), clazz);
    }

    public MethodResolutionResult resolveMethodOnClass(DexProto methodProto, DexString methodName, DexClass clazz) {
        assert (this.checkIfObsolete());
        assert (!clazz.isInterface());
        MethodResolutionResult result = this.resolveMethodOnClassStep2(clazz, methodProto, methodName, clazz);
        if (result != null) {
            return result;
        }
        return this.resolveMethodStep3(clazz, methodProto, methodName);
    }

    MethodResolutionResult resolveMaximallySpecificTarget(DexClass clazz, DexMethod method) {
        return this.resolveMaximallySpecificTargetHelper(clazz, method).resolve(clazz);
    }

    MethodResolutionResult resolveMaximallySpecificTarget(LambdaDescriptor lambda, DexMethod method) {
        return this.resolveMaximallySpecificTargetHelper(lambda, method).internalResolve(null);
    }

    DexClassAndMethod lookupMaximallySpecificTarget(DexClass clazz, DexMethod method) {
        return this.resolveMaximallySpecificTargetHelper(clazz, method).lookup();
    }

    DexClassAndMethod lookupMaximallySpecificTarget(LambdaDescriptor lambda, DexMethod method) {
        return this.resolveMaximallySpecificTargetHelper(lambda, method).lookup();
    }

    public MethodResolutionResult resolveMethodOnInterface(DexMethod method) {
        return this.resolveMethodOnInterface(method.holder, method);
    }

    public MethodResolutionResult resolveMethodOnInterface(DexType holder, DexMethod desc) {
        assert (this.checkIfObsolete());
        if (holder.isArrayType()) {
            return MethodResolutionResult.IncompatibleClassResult.INSTANCE;
        }
        DexClass definition = this.definitionFor(holder);
        if (definition == null) {
            return MethodResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        if (!definition.isInterface()) {
            return MethodResolutionResult.IncompatibleClassResult.INSTANCE;
        }
        return this.resolveMethodOnInterface(definition, desc);
    }

    public MethodResolutionResult resolveMethodOnInterface(DexClass definition, DexMethod desc) {
        return this.resolveMethodOnInterface(definition, desc.getProto(), desc.getName());
    }

    public MethodResolutionResult resolveMethodOnInterface(DexClass definition, DexProto methodProto, DexString methodName) {
        assert (this.checkIfObsolete());
        assert (definition.isInterface());
        DexEncodedMethod result = definition.lookupMethod(methodProto, methodName);
        if (result != null) {
            return new MethodResolutionResult.SingleResolutionResult(definition, definition, result);
        }
        DexClass objectClass = this.definitionFor(this.dexItemFactory().objectType);
        if (objectClass == null) {
            return MethodResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        result = objectClass.lookupMethod(methodProto, methodName);
        if (result != null && result.accessFlags.isPublic() && !result.accessFlags.isAbstract()) {
            return new MethodResolutionResult.SingleResolutionResult(definition, objectClass, result);
        }
        return this.resolveMethodStep3(definition, methodProto, methodName);
    }

    public FieldResolutionResult resolveField(DexField field) {
        assert (this.checkIfObsolete());
        return this.resolveFieldOn(field.holder, field);
    }

    @Override
    public FieldResolutionResult resolveFieldOn(DexType type, DexField field, ProgramMethod context) {
        assert (this.checkIfObsolete());
        return this.resolveFieldOn(type, field);
    }

    public FieldResolutionResult resolveFieldOn(DexType type, DexField field) {
        assert (this.checkIfObsolete());
        return new FieldResolution(this).resolveFieldOn(type, field);
    }

    public FieldResolutionResult resolveFieldOn(DexClass clazz, DexField field) {
        assert (this.checkIfObsolete());
        return new FieldResolution(this).resolveFieldOn(clazz, field);
    }

    private static class MaximallySpecificMethodsBuilder {
        LinkedHashMap<DexClass, DexEncodedMethod> maximallySpecificMethods = new LinkedHashMap();

        private MaximallySpecificMethodsBuilder() {
        }

        private void markShadowed(DexType type, AppInfo appInfo) {
            if (type == null) {
                return;
            }
            DexClass clazz = appInfo.definitionFor(type);
            if (clazz == null) {
                return;
            }
            assert (clazz.isInterface());
            assert (clazz.superType == appInfo.dexItemFactory().objectType);
            if (this.maximallySpecificMethods.containsKey(clazz) && this.maximallySpecificMethods.get(clazz) == null) {
                return;
            }
            this.maximallySpecificMethods.put(clazz, null);
            for (DexType iface : clazz.interfaces.values) {
                this.markShadowed(iface, appInfo);
            }
        }

        private MethodResolutionResult internalResolve(DexClass initialResolutionHolder) {
            if (this.maximallySpecificMethods.isEmpty()) {
                return MethodResolutionResult.NoSuchMethodResult.INSTANCE;
            }
            if (this.maximallySpecificMethods.size() == 1) {
                return MaximallySpecificMethodsBuilder.singleResultHelper(initialResolutionHolder, this.maximallySpecificMethods.entrySet().iterator().next());
            }
            Map.Entry<DexClass, DexEncodedMethod> firstMaximallySpecificMethod = null;
            ArrayList<Map.Entry<DexClass, DexEncodedMethod>> nonAbstractMethods = new ArrayList<Map.Entry<DexClass, DexEncodedMethod>>(this.maximallySpecificMethods.size());
            for (Map.Entry<DexClass, DexEncodedMethod> entry : this.maximallySpecificMethods.entrySet()) {
                DexEncodedMethod method = entry.getValue();
                if (method == null) continue;
                if (firstMaximallySpecificMethod == null) {
                    firstMaximallySpecificMethod = entry;
                }
                if (!method.isNonAbstractVirtualMethod()) continue;
                nonAbstractMethods.add(entry);
            }
            if (nonAbstractMethods.isEmpty()) {
                return MaximallySpecificMethodsBuilder.singleResultHelper(initialResolutionHolder, firstMaximallySpecificMethod);
            }
            if (nonAbstractMethods.size() == 1) {
                return MaximallySpecificMethodsBuilder.singleResultHelper(initialResolutionHolder, (Map.Entry)nonAbstractMethods.get(0));
            }
            return MethodResolutionResult.IncompatibleClassResult.create(ListUtils.map(nonAbstractMethods, Map.Entry::getValue));
        }

        private static MethodResolutionResult.SingleResolutionResult singleResultHelper(DexClass initialResolutionResult, Map.Entry<DexClass, DexEncodedMethod> entry) {
            return new MethodResolutionResult.SingleResolutionResult(initialResolutionResult != null ? initialResolutionResult : entry.getKey(), entry.getKey(), entry.getValue());
        }

        void addCandidate(DexClass holder, DexEncodedMethod method, AppInfo appInfo) {
            if (this.maximallySpecificMethods.containsKey(holder)) {
                return;
            }
            this.maximallySpecificMethods.put(holder, method);
            assert (holder.isInterface());
            assert (holder.superType == appInfo.dexItemFactory().objectType);
            for (DexType iface : holder.interfaces.values) {
                this.markShadowed(iface, appInfo);
            }
        }

        DexClassAndMethod lookup() {
            return this.internalResolve(null).getResolutionPair();
        }

        MethodResolutionResult resolve(DexClass initialResolutionHolder) {
            assert (initialResolutionHolder != null);
            return this.internalResolve(initialResolutionHolder);
        }
    }

    static class CreateDesugaringViewOnAppInfo {
        private CreateDesugaringViewOnAppInfo() {
        }
    }
}

