/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class AppServices {
    public static final String SERVICE_DIRECTORY_NAME = "META-INF/services/";
    private final AppView<?> appView;
    private final GraphLens applied;
    private final Map<DexType, Map<FeatureSplit, List<DexType>>> services;

    private AppServices(AppView<?> appView, Map<DexType, Map<FeatureSplit, List<DexType>>> services) {
        this.appView = appView;
        this.applied = appView.graphLens();
        this.services = services;
    }

    public static Builder builder(AppView<?> appView) {
        return new Builder(appView);
    }

    public boolean isEmpty() {
        return this.services.isEmpty();
    }

    public Set<DexType> allServiceTypes() {
        assert (this.verifyRewrittenWithLens());
        return this.services.keySet();
    }

    public Set<DexType> computeAllServiceImplementations() {
        assert (this.verifyRewrittenWithLens());
        Set<DexType> serviceImplementations = Sets.newIdentityHashSet();
        this.services.forEach((serviceType, featureSplitListMap) -> featureSplitListMap.forEach((feature, featureServiceImplementations) -> serviceImplementations.addAll((Collection<DexType>)featureServiceImplementations)));
        return serviceImplementations;
    }

    public List<DexType> serviceImplementationsFor(DexType serviceType) {
        assert (this.verifyRewrittenWithLens());
        Map<FeatureSplit, List<DexType>> featureSplitListMap = this.services.get(serviceType);
        if (featureSplitListMap == null) {
            assert (false) : "Unexpected attempt to get service implementations for non-service type `" + serviceType.toSourceString() + "`";
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<DexType> implementations : featureSplitListMap.values()) {
            builder.addAll(implementations);
        }
        return builder.build();
    }

    public boolean hasServiceImplementationsInFeature(AppView<AppInfoWithLiveness> appView, DexType serviceType) {
        ClassToFeatureSplitMap classToFeatureSplitMap = appView.appInfo().getClassToFeatureSplitMap();
        if (classToFeatureSplitMap.isEmpty()) {
            return false;
        }
        Map<FeatureSplit, List<DexType>> featureImplementations = this.services.get(serviceType);
        if (featureImplementations == null || featureImplementations.isEmpty()) {
            assert (false) : "Unexpected attempt to get service implementations for non-service type `" + serviceType.toSourceString() + "`";
            return true;
        }
        if (featureImplementations.keySet().stream().anyMatch(feature -> !feature.isBase())) {
            return true;
        }
        assert (featureImplementations.size() <= 2);
        DexProgramClass serviceClass = appView.definitionForProgramType(serviceType);
        if (serviceClass != null && classToFeatureSplitMap.isInFeature(serviceClass, appView.getSyntheticItems())) {
            return true;
        }
        for (Map.Entry<FeatureSplit, List<DexType>> entry : featureImplementations.entrySet()) {
            FeatureSplit feature2 = entry.getKey();
            assert (feature2.isBase());
            List<DexType> implementationTypes = entry.getValue();
            for (DexType implementationType : implementationTypes) {
                DexProgramClass implementationClass = appView.definitionForProgramType(implementationType);
                if (implementationClass == null || !classToFeatureSplitMap.isInFeature(implementationClass, appView.getSyntheticItems())) continue;
                return true;
            }
        }
        return false;
    }

    public AppServices rewrittenWithLens(GraphLens graphLens) {
        ImmutableMap.Builder rewrittenFeatureMappings = ImmutableMap.builder();
        for (Map.Entry<DexType, Map<FeatureSplit, List<DexType>>> entry : this.services.entrySet()) {
            DexType rewrittenServiceType = graphLens.lookupClassType(entry.getKey(), this.applied);
            ImmutableMap.Builder<FeatureSplit, ImmutableCollection> rewrittenFeatureImplementations = ImmutableMap.builder();
            for (Map.Entry<FeatureSplit, List<DexType>> featureSplitImpls : entry.getValue().entrySet()) {
                ImmutableList.Builder rewrittenServiceImplementationTypes = ImmutableList.builder();
                for (DexType serviceImplementationType : featureSplitImpls.getValue()) {
                    rewrittenServiceImplementationTypes.add(graphLens.lookupClassType(serviceImplementationType, this.applied));
                }
                rewrittenFeatureImplementations.put(featureSplitImpls.getKey(), rewrittenServiceImplementationTypes.build());
            }
            rewrittenFeatureMappings.put(rewrittenServiceType, rewrittenFeatureImplementations.build());
        }
        return new AppServices(this.appView, rewrittenFeatureMappings.build());
    }

    public AppServices prunedCopy(PrunedItems prunedItems) {
        ImmutableMap.Builder rewrittenServicesBuilder = ImmutableMap.builder();
        for (Map.Entry<DexType, Map<FeatureSplit, List<DexType>>> entry : this.services.entrySet()) {
            if (prunedItems.getRemovedClasses().contains(entry.getKey())) continue;
            ImmutableMap.Builder<FeatureSplit, ImmutableCollection> prunedFeatureSplitImpls = ImmutableMap.builder();
            for (Map.Entry<FeatureSplit, List<DexType>> featureSplitEntry : entry.getValue().entrySet()) {
                ImmutableList.Builder rewrittenServiceImplementationTypesBuilder = ImmutableList.builder();
                for (DexType serviceImplementationType : featureSplitEntry.getValue()) {
                    if (prunedItems.getRemovedClasses().contains(serviceImplementationType)) continue;
                    rewrittenServiceImplementationTypesBuilder.add(serviceImplementationType);
                }
                ImmutableCollection prunedFeatureSplitImplementations = rewrittenServiceImplementationTypesBuilder.build();
                if (prunedFeatureSplitImplementations.size() <= 0) continue;
                prunedFeatureSplitImpls.put(featureSplitEntry.getKey(), rewrittenServiceImplementationTypesBuilder.build());
            }
            ImmutableMap prunedServiceImplementations = prunedFeatureSplitImpls.build();
            if (prunedServiceImplementations.size() <= 0) continue;
            rewrittenServicesBuilder.put(entry.getKey(), prunedServiceImplementations);
        }
        return new AppServices(this.appView, rewrittenServicesBuilder.build());
    }

    public boolean verifyRewrittenWithLens() {
        for (Map.Entry<DexType, Map<FeatureSplit, List<DexType>>> entry : this.services.entrySet()) {
            assert (entry.getKey() == this.appView.graphLens().lookupClassType(entry.getKey(), this.applied));
            for (Map.Entry<FeatureSplit, List<DexType>> featureEntry : entry.getValue().entrySet()) {
                for (DexType type : featureEntry.getValue()) {
                    assert (type == this.appView.graphLens().lookupClassType(type, this.applied));
                }
            }
        }
        return true;
    }

    public void visit(BiConsumer<DexType, List<DexType>> consumer) {
        this.services.forEach((type, featureImpls) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            featureImpls.values().forEach(builder::addAll);
            consumer.accept((DexType)type, (List<DexType>)((Object)builder.build()));
        });
    }

    public static class Builder {
        private final AppView<?> appView;
        private final InternalOptions options;
        private final Map<DexType, Map<FeatureSplit, List<DexType>>> services = new LinkedHashMap<DexType, Map<FeatureSplit, List<DexType>>>();

        private Builder(AppView<?> appView) {
            this.appView = appView;
            this.options = appView.options();
        }

        private void readServices(DataResourceProvider dataResourceProvider, FeatureSplit featureSplit) {
            try {
                dataResourceProvider.accept(new DataResourceProviderVisitor(featureSplit));
            }
            catch (ResourceException e) {
                throw new CompilationError(e.getMessage(), e);
            }
        }

        public AppServices build() {
            for (DataResourceProvider provider : ((AppInfo)this.appView.appInfo()).app().dataResourceProviders) {
                this.readServices(provider, FeatureSplit.BASE);
            }
            if (this.options.featureSplitConfiguration != null) {
                List<FeatureSplit> featureSplits = this.options.featureSplitConfiguration.getFeatureSplits();
                for (FeatureSplit featureSplit : featureSplits) {
                    for (ProgramResourceProvider provider : featureSplit.getProgramResourceProviders()) {
                        DataResourceProvider dataResourceProvider = provider.getDataResourceProvider();
                        if (dataResourceProvider == null) continue;
                        this.readServices(dataResourceProvider, featureSplit);
                    }
                }
            }
            return new AppServices(this.appView, this.services);
        }

        private class DataResourceProviderVisitor
        implements DataResourceProvider.Visitor {
            private final FeatureSplit featureSplit;

            public DataResourceProviderVisitor(FeatureSplit featureSplit) {
                this.featureSplit = featureSplit;
            }

            private void readServiceImplementationsForService(String contents, Origin origin, DexType serviceType, List<DexType> serviceImplementations) {
                if (contents != null) {
                    StringUtils.splitLines(contents).stream().map(String::trim).map(this::prefixUntilCommentChar).filter(line -> !line.isEmpty()).filter(DescriptorUtils::isValidJavaType).map(DescriptorUtils::javaTypeToDescriptor).map(Builder.this.appView.dexItemFactory()::createType).filter(serviceImplementationType -> {
                        DexClass serviceImplementationClass;
                        if (!serviceImplementationType.isClassType()) {
                            this.warn("Unexpected service implementation found in META-INF/services/" + serviceType.toSourceString() + ": " + serviceImplementationType.toSourceString() + ".", (DexType)serviceImplementationType, origin);
                            return false;
                        }
                        if (Builder.this.appView.enableWholeProgramOptimizations() && (serviceImplementationClass = ((AppInfo)Builder.this.appView.appInfo()).definitionForWithoutExistenceAssert((DexType)serviceImplementationType)) == null) {
                            this.warn("Unexpected reference to missing service implementation class in META-INF/services/" + serviceType.toSourceString() + ": " + serviceImplementationType.toSourceString() + ".", (DexType)serviceImplementationType, origin);
                        }
                        return !serviceImplementations.contains(serviceImplementationType);
                    }).forEach(serviceImplementations::add);
                }
            }

            private String prefixUntilCommentChar(String line) {
                int commentCharIndex = line.indexOf(35);
                return commentCharIndex > -1 ? line.substring(0, commentCharIndex) : line;
            }

            private void warn(String message, DexType type, Origin origin) {
                if (!Builder.this.appView.getDontWarnConfiguration().matches(type)) {
                    ((Builder)Builder.this).options.reporter.warning(new StringDiagnostic(message, origin));
                }
            }

            @Override
            public void visit(DataDirectoryResource directory) {
            }

            @Override
            public void visit(DataEntryResource file) {
                try {
                    DexClass serviceClass;
                    String name = file.getName();
                    if (!name.startsWith(AppServices.SERVICE_DIRECTORY_NAME)) {
                        return;
                    }
                    String serviceName = name.substring(AppServices.SERVICE_DIRECTORY_NAME.length());
                    if (!DescriptorUtils.isValidJavaType(serviceName)) {
                        return;
                    }
                    String serviceDescriptor = DescriptorUtils.javaTypeToDescriptor(serviceName);
                    DexType serviceType = Builder.this.appView.dexItemFactory().createType(serviceDescriptor);
                    if (Builder.this.appView.enableWholeProgramOptimizations() && (serviceClass = ((AppInfo)Builder.this.appView.appInfo()).definitionForWithoutExistenceAssert(serviceType)) == null) {
                        this.warn("Unexpected reference to missing service class: META-INF/services/" + serviceType.toSourceString() + ".", serviceType, file.getOrigin());
                    }
                    byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                    String contents = new String(bytes, Charset.defaultCharset());
                    Map featureSplitImplementations = Builder.this.services.computeIfAbsent(serviceType, k -> new LinkedHashMap());
                    List serviceImplementations = featureSplitImplementations.computeIfAbsent(this.featureSplit, f -> new ArrayList());
                    this.readServiceImplementationsForService(contents, file.getOrigin(), serviceType, serviceImplementations);
                }
                catch (ResourceException | IOException e) {
                    throw new CompilationError(e.getMessage(), e);
                }
            }
        }
    }
}

