/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.dontwarn.DontWarnConfiguration;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.analysis.InitializedClassesInInstanceMethodsAnalysis;
import com.android.tools.r8.graph.classmerging.MergedClassesCollection;
import com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontallyMergedClasses;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.analysis.proto.EnumLiteProtoShrinker;
import com.android.tools.r8.ir.analysis.proto.GeneratedExtensionRegistryShrinker;
import com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteBuilderShrinker;
import com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteShrinker;
import com.android.tools.r8.ir.analysis.proto.ProtoShrinker;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.desugar.TypeRewriter;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoFactory;
import com.android.tools.r8.ir.optimize.library.LibraryMemberOptimizer;
import com.android.tools.r8.ir.optimize.library.LibraryMethodSideEffectModelCollection;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagator;
import com.android.tools.r8.optimize.interfaces.collection.OpenClosedInterfacesCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepClassInfo;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.shaking.LibraryModeledPredicate;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.shaking.ProguardCompatibilityActions;
import com.android.tools.r8.shaking.RootSetUtils;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.ThrowingConsumer;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AppView<T extends AppInfo>
implements DexDefinitionSupplier,
LibraryModeledPredicate {
    private T appInfo;
    private AppInfoWithClassHierarchy appInfoForDesugaring;
    private AppServices appServices;
    private final DontWarnConfiguration dontWarnConfiguration;
    private final WholeProgramOptimizations wholeProgramOptimizations;
    private GraphLens codeLens = GraphLens.getIdentityLens();
    private GraphLens graphLens = GraphLens.getIdentityLens();
    private InitClassLens initClassLens;
    private ProguardCompatibilityActions proguardCompatibilityActions;
    private RootSetUtils.RootSet rootSet;
    private RootSetUtils.MainDexRootSet mainDexRootSet = null;
    private KeepInfoCollection keepInfo = null;
    private final AbstractValueFactory abstractValueFactory = new AbstractValueFactory();
    private final InstanceFieldInitializationInfoFactory instanceFieldInitializationInfoFactory = new InstanceFieldInitializationInfoFactory();
    private final SimpleInliningConstraintFactory simpleInliningConstraintFactory = new SimpleInliningConstraintFactory();
    public final TypeRewriter typeRewriter;
    private final LibraryMethodSideEffectModelCollection libraryMethodSideEffectModelCollection;
    private final ArgumentPropagator argumentPropagator;
    private final LibraryMemberOptimizer libraryMemberOptimizer;
    private final ProtoShrinker protoShrinker;
    private boolean allCodeProcessed = false;
    private Predicate<DexType> classesEscapingIntoLibrary = Predicates.alwaysTrue();
    private InitializedClassesInInstanceMethodsAnalysis.InitializedClassesInInstanceMethods initializedClassesInInstanceMethods;
    private HorizontallyMergedClasses horizontallyMergedClasses = HorizontallyMergedClasses.empty();
    private VerticallyMergedClasses verticallyMergedClasses;
    private EnumDataMap unboxedEnums = null;
    private OpenClosedInterfacesCollection openClosedInterfacesCollection = OpenClosedInterfacesCollection.getDefault();
    private Set<DexMethod> cfByteCodePassThrough = ImmutableSet.of();
    private Map<DexType, DexValue.DexValueString> sourceDebugExtensions = new IdentityHashMap<DexType, DexValue.DexValueString>();
    private SeedMapper applyMappingSeedMapper;
    private Set<DexType> alreadyLibraryDesugared = null;
    private final CompilationContext context;
    private final Thread mainThread = Thread.currentThread();
    private final AndroidApiLevelCompute apiLevelCompute;
    private final ComputedApiLevel computedMinApiLevel;

    private AppView(T appInfo, WholeProgramOptimizations wholeProgramOptimizations, TypeRewriter mapper) {
        this(appInfo, wholeProgramOptimizations, mapper, Timing.empty());
    }

    private AppView(T appInfo, WholeProgramOptimizations wholeProgramOptimizations, TypeRewriter mapper, Timing timing) {
        assert (appInfo != null);
        this.context = timing.time("Compilation context", () -> CompilationContext.createInitialContext(appInfo.options()));
        this.appInfo = appInfo;
        this.dontWarnConfiguration = timing.time("Dont warn config", () -> DontWarnConfiguration.create(this.options().getProguardConfiguration()));
        this.wholeProgramOptimizations = wholeProgramOptimizations;
        this.initClassLens = timing.time("Init class lens", InitClassLens::getThrowingInstance);
        this.typeRewriter = mapper;
        timing.begin("Create argument propagator");
        this.argumentPropagator = this.enableWholeProgramOptimizations() && this.options().callSiteOptimizationOptions().isEnabled() ? new ArgumentPropagator(this.withLiveness()) : null;
        timing.end();
        this.libraryMethodSideEffectModelCollection = timing.time("Library side-effects", () -> new LibraryMethodSideEffectModelCollection(this));
        this.libraryMemberOptimizer = timing.time("Library optimizer", () -> new LibraryMemberOptimizer(this, timing));
        this.protoShrinker = timing.time("Proto shrinker", () -> ProtoShrinker.create(this.withLiveness()));
        this.apiLevelCompute = timing.time("ApiLevel compute", () -> AndroidApiLevelCompute.create(this));
        this.computedMinApiLevel = timing.time("ApiLevel computed", () -> this.apiLevelCompute.computeInitialMinApiLevel(this.options()));
    }

    private static <T extends AppInfo> TypeRewriter defaultTypeRewriter(T appInfo) {
        InternalOptions options = appInfo.options();
        return options.getTypeRewriter();
    }

    public static <T extends AppInfo> AppView<T> createForD8(T appInfo) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, AppView.defaultTypeRewriter(appInfo));
    }

    public static <T extends AppInfo> AppView<T> createForD8(T appInfo, TypeRewriter mapper, Timing timing) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, mapper, timing);
    }

    public static AppView<AppInfoWithClassHierarchy> createForR8(DexApplication application) {
        return AppView.createForR8(application, MainDexInfo.none());
    }

    public static AppView<AppInfoWithClassHierarchy> createForR8(DexApplication application, MainDexInfo mainDexInfo) {
        ClassToFeatureSplitMap classToFeatureSplitMap = ClassToFeatureSplitMap.createInitialClassToFeatureSplitMap(application.options);
        AppInfoWithClassHierarchy appInfo = AppInfoWithClassHierarchy.createInitialAppInfoWithClassHierarchy(application, classToFeatureSplitMap, mainDexInfo);
        return new AppView<AppInfoWithClassHierarchy>(appInfo, WholeProgramOptimizations.ON, AppView.defaultTypeRewriter(appInfo));
    }

    public static <T extends AppInfo> AppView<T> createForL8(T appInfo, TypeRewriter mapper) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, mapper);
    }

    public static <T extends AppInfo> AppView<T> createForRelocator(T appInfo) {
        return new AppView<T>(appInfo, WholeProgramOptimizations.OFF, AppView.defaultTypeRewriter(appInfo));
    }

    public static AppView<AppInfoWithClassHierarchy> createForTracer(AppInfoWithClassHierarchy appInfo) {
        return new AppView<AppInfoWithClassHierarchy>(appInfo, WholeProgramOptimizations.ON, AppView.defaultTypeRewriter(appInfo));
    }

    private void unsetAppInfoForDesugaring() {
        this.appInfoForDesugaring = null;
    }

    private static void pruneAppInfo(PrunedItems prunedItems, AppView<?> appView, ExecutorService executorService) throws ExecutionException {
        appView.setAppInfo(((AppInfo)appView.appInfo()).prunedCopyFrom(prunedItems, executorService));
    }

    private static void rewriteWithLens(GraphLens.NonIdentityGraphLens lens, DirectMappedDexApplication application, AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens appliedLens) {
        Object appliedMemberRebindingLens;
        if (lens == null) {
            return;
        }
        boolean changed = appView.setGraphLens(lens);
        assert (changed);
        assert (application.verifyWithLens(appView.appInfo().app().asDirect(), lens));
        GraphLens.NonIdentityGraphLens firstUnappliedLens = lens;
        while (firstUnappliedLens.getPrevious() != appliedLens) {
            GraphLens previousLens = firstUnappliedLens.getPrevious();
            assert (previousLens.isNonIdentityLens());
            assert (previousLens != appView.codeLens());
            firstUnappliedLens = previousLens.asNonIdentityLens();
        }
        GraphLens newMemberRebindingLens = GraphLens.getIdentityLens();
        if (!firstUnappliedLens.isMemberRebindingLens() && !firstUnappliedLens.isMemberRebindingIdentityLens() && (appliedMemberRebindingLens = firstUnappliedLens.findPreviousUntil(previous -> previous.isMemberRebindingLens() || previous.isMemberRebindingIdentityLens(), previous -> previous == appView.codeLens())) != null) {
            newMemberRebindingLens = ((GraphLens)appliedMemberRebindingLens).isMemberRebindingLens() ? ((GraphLens)appliedMemberRebindingLens).asMemberRebindingLens().toRewrittenFieldRebindingLens(appView, appliedLens) : ((GraphLens)appliedMemberRebindingLens).asMemberRebindingIdentityLens().toRewrittenMemberRebindingIdentityLens(appView, appliedLens);
        }
        firstUnappliedLens.withAlternativeParentLens(newMemberRebindingLens, () -> {
            if (appView.hasLiveness()) {
                appView.withLiveness().setAppInfo(appView.appInfoWithLiveness().rewrittenWithLens(application, lens));
            }
            appView.setAppServices(appView.appServices().rewrittenWithLens(lens));
            if (appView.hasInitClassLens()) {
                appView.setInitClassLens(appView.initClassLens().rewrittenWithLens(lens));
            }
            if (appView.hasProguardCompatibilityActions()) {
                appView.setProguardCompatibilityActions(appView.getProguardCompatibilityActions().rewrittenWithLens(lens));
            }
            if (appView.hasMainDexRootSet()) {
                appView.setMainDexRootSet(appView.getMainDexRootSet().rewrittenWithLens(lens));
            }
            appView.setOpenClosedInterfacesCollection(appView.getOpenClosedInterfacesCollection().rewrittenWithLens(lens));
            if (appView.hasRootSet()) {
                appView.setRootSet(appView.rootSet().rewrittenWithLens(lens));
            }
        });
    }

    public boolean verifyMainThread() {
        assert (this.mainThread == Thread.currentThread());
        return true;
    }

    @Override
    public boolean isModeled(DexType type) {
        return this.libraryMemberOptimizer.isModeled(type);
    }

    public AbstractValueFactory abstractValueFactory() {
        return this.abstractValueFactory;
    }

    public InstanceFieldInitializationInfoFactory instanceFieldInitializationInfoFactory() {
        return this.instanceFieldInitializationInfoFactory;
    }

    public SimpleInliningConstraintFactory simpleInliningConstraintFactory() {
        return this.simpleInliningConstraintFactory;
    }

    public DexApplication app() {
        return ((AppInfo)this.appInfo()).app();
    }

    public T appInfo() {
        assert (!((AppInfo)this.appInfo).hasClassHierarchy() || this.enableWholeProgramOptimizations());
        return this.appInfo;
    }

    public AppInfoWithLiveness appInfoWithLiveness() {
        return ((AppInfo)this.appInfo).hasLiveness() ? ((AppInfo)this.appInfo).withLiveness() : null;
    }

    public AppInfoWithClassHierarchy appInfoForDesugaring() {
        if (this.enableWholeProgramOptimizations()) {
            assert (((AppInfo)this.appInfo).hasClassHierarchy());
            return ((AppInfo)this.appInfo).withClassHierarchy();
        }
        assert (!((AppInfo)this.appInfo).hasClassHierarchy());
        if (this.appInfoForDesugaring == null) {
            this.appInfoForDesugaring = AppInfoWithClassHierarchy.createForDesugaring(this.appInfo());
        }
        return this.appInfoForDesugaring;
    }

    public <U extends T> AppView<U> setAppInfo(U appInfo) {
        assert (!((AppInfo)appInfo).isObsolete());
        T previous = this.appInfo;
        this.appInfo = appInfo;
        this.unsetAppInfoForDesugaring();
        if (appInfo != previous) {
            ((AppInfo)previous).markObsolete();
        }
        if (((AppInfo)appInfo).hasLiveness()) {
            this.keepInfo = ((AppInfo)appInfo).withLiveness().getKeepInfo();
        }
        AppView appViewWithSpecializedAppInfo = this;
        return appViewWithSpecializedAppInfo;
    }

    public boolean isAllCodeProcessed() {
        return this.allCodeProcessed;
    }

    public void setAllCodeProcessed() {
        this.allCodeProcessed = true;
    }

    public GraphLens clearCodeRewritings() {
        GraphLens newLens = this.graphLens.withCodeRewritingsApplied(this.dexItemFactory());
        this.setGraphLens(newLens);
        return newLens;
    }

    public AppServices appServices() {
        return this.appServices;
    }

    public void setAppServices(AppServices appServices) {
        this.appServices = appServices;
    }

    public DontWarnConfiguration getDontWarnConfiguration() {
        return this.dontWarnConfiguration;
    }

    public boolean isClassEscapingIntoLibrary(DexType type) {
        assert (type.isClassType());
        return this.classesEscapingIntoLibrary.test(type);
    }

    public void setClassesEscapingIntoLibrary(Predicate<DexType> classesEscapingIntoLibrary) {
        this.classesEscapingIntoLibrary = classesEscapingIntoLibrary;
    }

    public void setSourceDebugExtensionForType(DexClass clazz, DexValue.DexValueString sourceDebugExtension) {
        this.sourceDebugExtensions.put(clazz.type, sourceDebugExtension);
    }

    public DexValue.DexValueString getSourceDebugExtensionForType(DexClass clazz) {
        return this.sourceDebugExtensions.get(clazz.type);
    }

    @Override
    public ClassResolutionResult contextIndependentDefinitionForWithResolutionResult(DexType type) {
        return ((AppInfo)this.appInfo()).contextIndependentDefinitionForWithResolutionResult(type);
    }

    @Override
    public final DexClass definitionFor(DexType type) {
        return ((AppInfo)this.appInfo()).definitionFor(type);
    }

    public OptionalBool isInterface(DexType type) {
        assert (type.isClassType());
        if (this.enableWholeProgramOptimizations()) {
            DexClass clazz = this.definitionFor(type);
            if (clazz == null) {
                return OptionalBool.unknown();
            }
            return OptionalBool.of(clazz.isInterface());
        }
        return OptionalBool.unknown();
    }

    @Override
    public DexItemFactory dexItemFactory() {
        return ((AppInfo)this.appInfo).dexItemFactory();
    }

    public boolean enableWholeProgramOptimizations() {
        return this.wholeProgramOptimizations == WholeProgramOptimizations.ON;
    }

    public CompilationContext.ProcessorContext createProcessorContext() {
        assert (this.verifyMainThread());
        return this.context.createProcessorContext();
    }

    public SyntheticItems getSyntheticItems() {
        return ((AppInfo)this.appInfo).getSyntheticItems();
    }

    public <E extends Throwable> void withArgumentPropagator(ThrowingConsumer<ArgumentPropagator, E> consumer) throws E {
        if (this.argumentPropagator != null) {
            consumer.accept(this.argumentPropagator);
        }
    }

    public LibraryMemberOptimizer libraryMethodOptimizer() {
        return this.libraryMemberOptimizer;
    }

    public LibraryMethodSideEffectModelCollection getLibraryMethodSideEffectModelCollection() {
        return this.libraryMethodSideEffectModelCollection;
    }

    public ProtoShrinker protoShrinker() {
        return this.protoShrinker;
    }

    public <E extends Throwable> void withProtoShrinker(ThrowingConsumer<ProtoShrinker, E> consumer) throws E {
        if (this.protoShrinker != null) {
            consumer.accept(this.protoShrinker);
        }
    }

    public <U> U withProtoShrinker(Function<ProtoShrinker, U> consumer, U defaultValue) {
        if (this.protoShrinker != null) {
            return consumer.apply(this.protoShrinker);
        }
        return defaultValue;
    }

    public <U> U withProtoEnumShrinker(Function<EnumLiteProtoShrinker, U> fn, U defaultValue) {
        if (this.protoShrinker != null && this.options().protoShrinking().isEnumLiteProtoShrinkingEnabled()) {
            return fn.apply(this.protoShrinker.enumLiteProtoShrinker);
        }
        return defaultValue;
    }

    public <E extends Throwable> void withGeneratedExtensionRegistryShrinker(ThrowingConsumer<GeneratedExtensionRegistryShrinker, E> consumer) throws E {
        if (this.protoShrinker != null && this.protoShrinker.generatedExtensionRegistryShrinker != null) {
            consumer.accept(this.protoShrinker.generatedExtensionRegistryShrinker);
        }
    }

    public <U> U withGeneratedExtensionRegistryShrinker(Function<GeneratedExtensionRegistryShrinker, U> fn, U defaultValue) {
        if (this.protoShrinker != null && this.protoShrinker.generatedExtensionRegistryShrinker != null) {
            return fn.apply(this.protoShrinker.generatedExtensionRegistryShrinker);
        }
        return defaultValue;
    }

    public <E extends Throwable> void withGeneratedMessageLiteShrinker(ThrowingConsumer<GeneratedMessageLiteShrinker, E> consumer) throws E {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteShrinker != null) {
            consumer.accept(this.protoShrinker.generatedMessageLiteShrinker);
        }
    }

    public <E extends Throwable> void withGeneratedMessageLiteBuilderShrinker(ThrowingConsumer<GeneratedMessageLiteBuilderShrinker, E> consumer) throws E {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteBuilderShrinker != null) {
            consumer.accept(this.protoShrinker.generatedMessageLiteBuilderShrinker);
        }
    }

    public <U> U withGeneratedMessageLiteShrinker(Function<GeneratedMessageLiteShrinker, U> fn, U defaultValue) {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteShrinker != null) {
            return fn.apply(this.protoShrinker.generatedMessageLiteShrinker);
        }
        return defaultValue;
    }

    public <U> U withGeneratedMessageLiteBuilderShrinker(Function<GeneratedMessageLiteBuilderShrinker, U> fn, U defaultValue) {
        if (this.protoShrinker != null && this.protoShrinker.generatedMessageLiteBuilderShrinker != null) {
            return fn.apply(this.protoShrinker.generatedMessageLiteBuilderShrinker);
        }
        return defaultValue;
    }

    public GraphLens codeLens() {
        return this.codeLens;
    }

    public void setCodeLens(GraphLens codeLens) {
        this.codeLens = codeLens;
    }

    public GraphLens graphLens() {
        return this.graphLens;
    }

    public boolean setGraphLens(GraphLens graphLens) {
        if (graphLens != this.graphLens) {
            this.graphLens = graphLens;
            if (graphLens.isAppliedLens() || graphLens.isClearCodeRewritingLens()) {
                this.setCodeLens(graphLens);
            }
            return true;
        }
        return false;
    }

    public boolean canUseInitClass() {
        return this.options().isShrinking() && !this.initClassLens.isFinal();
    }

    public InitClassLens initClassLens() {
        return this.initClassLens;
    }

    public boolean hasInitClassLens() {
        return this.initClassLens != null;
    }

    public void setInitClassLens(InitClassLens initClassLens) {
        this.initClassLens = initClassLens;
    }

    public void setInitializedClassesInInstanceMethods(InitializedClassesInInstanceMethodsAnalysis.InitializedClassesInInstanceMethods initializedClassesInInstanceMethods) {
        this.initializedClassesInInstanceMethods = initializedClassesInInstanceMethods;
    }

    public void setCfByteCodePassThrough(Set<DexMethod> cfByteCodePassThrough) {
        this.cfByteCodePassThrough = cfByteCodePassThrough;
    }

    public <U> U withInitializedClassesInInstanceMethods(Function<InitializedClassesInInstanceMethodsAnalysis.InitializedClassesInInstanceMethods, U> fn, U defaultValue) {
        if (this.initializedClassesInInstanceMethods != null) {
            return fn.apply(this.initializedClassesInInstanceMethods);
        }
        return defaultValue;
    }

    public InternalOptions options() {
        return ((AppInfo)this.appInfo).options();
    }

    public Reporter reporter() {
        return this.options().reporter;
    }

    public InternalOptions.TestingOptions testing() {
        return this.options().testing;
    }

    public boolean hasRootSet() {
        return this.rootSet != null;
    }

    public RootSetUtils.RootSet rootSet() {
        return this.rootSet;
    }

    public void setRootSet(RootSetUtils.RootSet rootSet) {
        this.rootSet = rootSet;
    }

    public void setMainDexRootSet(RootSetUtils.MainDexRootSet mainDexRootSet) {
        assert (mainDexRootSet != null) : "Root set should never be recomputed";
        this.mainDexRootSet = mainDexRootSet;
    }

    public boolean hasMainDexRootSet() {
        return this.mainDexRootSet != null;
    }

    public RootSetUtils.MainDexRootSet getMainDexRootSet() {
        return this.mainDexRootSet;
    }

    public KeepInfoCollection getKeepInfo() {
        return this.keepInfo;
    }

    public KeepClassInfo getKeepInfo(DexProgramClass clazz) {
        return this.getKeepInfo().getClassInfo(clazz);
    }

    public KeepFieldInfo getKeepInfo(ProgramField field) {
        return this.getKeepInfo().getFieldInfo(field);
    }

    public KeepMethodInfo getKeepInfo(ProgramMethod method) {
        return this.getKeepInfo().getMethodInfo(method);
    }

    public boolean hasProguardCompatibilityActions() {
        return this.proguardCompatibilityActions != null;
    }

    public ProguardCompatibilityActions getProguardCompatibilityActions() {
        return this.proguardCompatibilityActions;
    }

    public void setProguardCompatibilityActions(ProguardCompatibilityActions proguardCompatibilityActions) {
        assert (this.options().forceProguardCompatibility);
        this.proguardCompatibilityActions = proguardCompatibilityActions;
    }

    public MergedClassesCollection allMergedClasses() {
        MergedClassesCollection collection = new MergedClassesCollection();
        if (this.hasHorizontallyMergedClasses()) {
            collection.add(this.horizontallyMergedClasses);
        }
        if (this.verticallyMergedClasses != null) {
            collection.add(this.verticallyMergedClasses);
        }
        return collection;
    }

    public boolean hasHorizontallyMergedClasses() {
        return !this.horizontallyMergedClasses.isEmpty();
    }

    public HorizontallyMergedClasses horizontallyMergedClasses() {
        return this.horizontallyMergedClasses;
    }

    public void setHorizontallyMergedClasses(HorizontallyMergedClasses horizontallyMergedClasses, HorizontalClassMerger.Mode mode) {
        assert (!this.hasHorizontallyMergedClasses() || mode.isFinal());
        this.horizontallyMergedClasses = this.horizontallyMergedClasses().extend(horizontallyMergedClasses);
        if (mode.isFinal()) {
            this.testing().horizontallyMergedClassesConsumer.accept(this.dexItemFactory(), this.horizontallyMergedClasses());
        }
    }

    public boolean hasVerticallyMergedClasses() {
        return this.verticallyMergedClasses != null;
    }

    public VerticallyMergedClasses verticallyMergedClasses() {
        return this.verticallyMergedClasses;
    }

    public void setVerticallyMergedClasses(VerticallyMergedClasses verticallyMergedClasses) {
        assert (this.verticallyMergedClasses == null);
        this.verticallyMergedClasses = verticallyMergedClasses;
        this.testing().verticallyMergedClassesConsumer.accept(this.dexItemFactory(), verticallyMergedClasses);
    }

    public OpenClosedInterfacesCollection getOpenClosedInterfacesCollection() {
        return this.openClosedInterfacesCollection;
    }

    public void setOpenClosedInterfacesCollection(OpenClosedInterfacesCollection openClosedInterfacesCollection) {
        this.openClosedInterfacesCollection = openClosedInterfacesCollection;
    }

    public boolean hasUnboxedEnums() {
        return this.unboxedEnums != null;
    }

    public EnumDataMap unboxedEnums() {
        return this.hasUnboxedEnums() ? this.unboxedEnums : EnumDataMap.empty();
    }

    public void setUnboxedEnums(EnumDataMap unboxedEnums) {
        assert (!this.hasUnboxedEnums());
        this.unboxedEnums = unboxedEnums;
        this.testing().unboxedEnumsConsumer.accept(this.dexItemFactory(), unboxedEnums);
    }

    public boolean validateUnboxedEnumsHaveBeenPruned() {
        for (DexType unboxedEnum : this.unboxedEnums.getUnboxedEnums()) {
            assert (((AppInfo)this.appInfo).definitionForWithoutExistenceAssert(unboxedEnum) == null) : "Enum " + unboxedEnum + " has been unboxed but is still in the program.";
            assert (((AppInfo)this.appInfo()).withLiveness().wasPruned(unboxedEnum)) : "Enum " + unboxedEnum + " has been unboxed but was not pruned.";
        }
        return true;
    }

    public boolean hasClassHierarchy() {
        return ((AppInfo)this.appInfo()).hasClassHierarchy();
    }

    public AppView<AppInfoWithClassHierarchy> withClassHierarchy() {
        return ((AppInfo)this.appInfo).hasClassHierarchy() ? this : null;
    }

    public AppView<AppInfo> withoutClassHierarchy() {
        assert (!this.hasClassHierarchy());
        return this;
    }

    public boolean hasLiveness() {
        return ((AppInfo)this.appInfo()).hasLiveness();
    }

    public AppView<AppInfoWithLiveness> withLiveness() {
        AppView appViewWithLiveness = this;
        return appViewWithLiveness;
    }

    public OptionalBool isSubtype(DexType subtype, DexType supertype) {
        if (this.hasClassHierarchy()) {
            return OptionalBool.of(((AppInfo)this.appInfo()).withClassHierarchy().isSubtype(subtype, supertype));
        }
        if (subtype == supertype || supertype == this.dexItemFactory().objectType) {
            return OptionalBool.TRUE;
        }
        return OptionalBool.unknown();
    }

    public boolean isCfByteCodePassThrough(DexEncodedMethod method) {
        if (!this.options().isGeneratingClassFiles()) {
            return false;
        }
        if (this.cfByteCodePassThrough.contains(method.getReference())) {
            return true;
        }
        return this.options().testing.cfByteCodePassThrough != null && this.options().testing.cfByteCodePassThrough.test((DexMethod)method.getReference());
    }

    public boolean hasCfByteCodePassThroughMethods() {
        return !this.cfByteCodePassThrough.isEmpty();
    }

    public void pruneItems(PrunedItems prunedItems, ExecutorService executorService) throws ExecutionException {
        if (prunedItems.isEmpty()) {
            assert (((AppInfo)this.appInfo()).app() == prunedItems.getPrunedApp());
            return;
        }
        if (((AppInfo)this.appInfo).hasLiveness()) {
            AppView<AppInfoWithLiveness> self = this.withLiveness();
            self.setAppInfo(self.appInfo().prunedCopyFrom(prunedItems, executorService));
        } else if (((AppInfo)this.appInfo).hasClassHierarchy()) {
            AppView<AppInfoWithClassHierarchy> self = this.withClassHierarchy();
            self.setAppInfo(self.appInfo().prunedCopyFrom(prunedItems, executorService));
        } else {
            AppView.pruneAppInfo(prunedItems, this, executorService);
        }
        if (this.appServices() != null) {
            this.setAppServices(this.appServices().prunedCopy(prunedItems));
        }
        if (this.hasProguardCompatibilityActions()) {
            this.setProguardCompatibilityActions(this.getProguardCompatibilityActions().withoutPrunedItems(prunedItems));
        }
        if (this.hasRootSet()) {
            this.rootSet.pruneItems(prunedItems);
        }
        if (this.hasMainDexRootSet()) {
            this.setMainDexRootSet(this.mainDexRootSet.withoutPrunedItems(prunedItems));
        }
        this.setOpenClosedInterfacesCollection(this.openClosedInterfacesCollection.withoutPrunedItems(prunedItems));
    }

    public void rewriteWithLens(GraphLens.NonIdentityGraphLens lens) {
        if (lens != null) {
            AppView.rewriteWithLens(lens, ((AppInfo)this.appInfo()).app().asDirect(), this.withClassHierarchy(), lens.getPrevious());
        }
    }

    public void rewriteWithLensAndApplication(GraphLens.NonIdentityGraphLens lens, DirectMappedDexApplication application) {
        this.rewriteWithLensAndApplication(lens, application, lens.getPrevious());
    }

    public void rewriteWithLensAndApplication(GraphLens.NonIdentityGraphLens lens, DirectMappedDexApplication application, GraphLens appliedLens) {
        assert (lens != null);
        assert (application != null);
        AppView.rewriteWithLens(lens, application, this.withClassHierarchy(), appliedLens);
    }

    public void setAlreadyLibraryDesugared(Set<DexType> alreadyLibraryDesugared) {
        assert (this.alreadyLibraryDesugared == null);
        this.alreadyLibraryDesugared = alreadyLibraryDesugared;
    }

    public boolean isAlreadyLibraryDesugared(DexProgramClass clazz) {
        if (!this.options().desugarSpecificOptions().allowAllDesugaredInput) {
            return false;
        }
        assert (this.alreadyLibraryDesugared != null);
        return this.alreadyLibraryDesugared.contains(clazz.getType());
    }

    public void loadApplyMappingSeedMapper() throws IOException {
        if (this.options().getProguardConfiguration().hasApplyMappingFile()) {
            this.applyMappingSeedMapper = SeedMapper.seedMapperFromFile(this.options().reporter, this.options().getProguardConfiguration().getApplyMappingFile());
        }
    }

    public SeedMapper getApplyMappingSeedMapper() {
        return this.applyMappingSeedMapper;
    }

    public void clearApplyMappingSeedMapper() {
        this.applyMappingSeedMapper = null;
    }

    public boolean checkForTesting(Supplier<Boolean> test) {
        return this.testing().enableTestAssertions ? test.get() : true;
    }

    public AndroidApiLevelCompute apiLevelCompute() {
        return this.apiLevelCompute;
    }

    public ComputedApiLevel computedMinApiLevel() {
        return this.computedMinApiLevel;
    }

    private static enum WholeProgramOptimizations {
        ON,
        OFF;

    }
}

