/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexByteCodeWriter;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinMetadataWriter;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.Timing;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.stream.Collectors;

public class AssemblyWriter
extends DexByteCodeWriter {
    private final boolean writeAllClassInfo;
    private final boolean writeFields;
    private final boolean writeAnnotations;
    private final boolean writeIR;
    private final boolean writeCode;
    private final AppInfo appInfo;
    private final Kotlin kotlin;
    private final Timing timing = new Timing("AssemblyWriter");
    private final CompilationContext compilationContext;

    public AssemblyWriter(DexApplication application, InternalOptions options, boolean allInfo, boolean writeIR, boolean writeCode) {
        super(application, options);
        this.compilationContext = CompilationContext.createInitialContext(options);
        this.writeAllClassInfo = allInfo;
        this.writeFields = allInfo;
        this.writeAnnotations = allInfo;
        this.writeIR = writeIR;
        this.writeCode = writeCode;
        if (writeIR) {
            this.appInfo = AppInfo.createInitialAppInfo(application.toDirect());
            if (options.programConsumer == null) {
                options.programConsumer = ClassFileConsumer.emptyConsumer();
            }
            options.outline.enabled = false;
        } else {
            this.appInfo = null;
        }
        this.kotlin = new Kotlin(application.dexItemFactory);
    }

    public static String getFileEnding() {
        return ".dump";
    }

    private void writeIR(ProgramMethod method, PrintStream ps) {
        CfgPrinter printer = new CfgPrinter();
        IRConverter converter = new IRConverter(this.appInfo, this.timing, printer);
        OneTimeMethodProcessor methodProcessor = OneTimeMethodProcessor.create(method, this.compilationContext.createProcessorContext());
        methodProcessor.forEachWaveWithExtension((ignore, methodProcessingContext) -> converter.processDesugaredMethod(method, OptimizationFeedbackIgnore.getInstance(), methodProcessor, methodProcessingContext));
        ps.println(printer.toString());
    }

    private void writeAnnotations(DexProgramClass clazz, DexAnnotationSet annotations, PrintStream ps) {
        if (this.writeAnnotations && !annotations.isEmpty()) {
            ps.println("# Annotations:");
            String prefix = "#  ";
            for (DexAnnotation annotation : annotations.annotations) {
                if (annotation.annotation.type == this.kotlin.factory.kotlinMetadataType) {
                    assert (clazz != null) : "Kotlin metadata is a class annotation";
                    KotlinMetadataWriter.writeKotlinMetadataAnnotation(prefix, annotation, ps, this.kotlin);
                    continue;
                }
                String annotationString = annotation.toString();
                ps.print(new BufferedReader(new StringReader(annotationString)).lines().collect(Collectors.joining(StringUtils.LINE_SEPARATOR + prefix + "  ", prefix, StringUtils.LINE_SEPARATOR)));
            }
        }
    }

    @Override
    void writeClassHeader(DexProgramClass clazz, PrintStream ps) {
        String clazzName = this.application.getProguardMap() != null ? this.application.getProguardMap().originalNameOf(clazz.type) : clazz.type.toSourceString();
        ps.println("# Bytecode for");
        ps.println("# Class: '" + clazzName + "'");
        if (this.writeAllClassInfo) {
            EnclosingMethodAttribute enclosingMethodAttribute;
            this.writeAnnotations(clazz, clazz.annotations(), ps);
            ps.println("# Flags: '" + clazz.accessFlags + "'");
            if (clazz.superType != this.application.dexItemFactory.objectType) {
                ps.println("# Extends: '" + clazz.superType.toSourceString() + "'");
            }
            for (DexType value : clazz.interfaces.values) {
                ps.println("# Implements: '" + value.toSourceString() + "'");
            }
            if (!clazz.getInnerClasses().isEmpty()) {
                ps.println("# InnerClasses:");
                for (InnerClassAttribute innerClassAttribute : clazz.getInnerClasses()) {
                    ps.println("#  Outer: " + (innerClassAttribute.getOuter() != null ? innerClassAttribute.getOuter().toSourceString() : "-") + ", inner: " + innerClassAttribute.getInner().toSourceString() + ", inner name: " + innerClassAttribute.getInnerName() + ", access: " + Integer.toHexString(innerClassAttribute.getAccess()));
                }
            }
            if ((enclosingMethodAttribute = clazz.getEnclosingMethodAttribute()) != null) {
                ps.println("# EnclosingMethod:");
                if (enclosingMethodAttribute.getEnclosingClass() != null) {
                    ps.println("#  Class: " + enclosingMethodAttribute.getEnclosingClass().toSourceString());
                } else {
                    ps.println("#  Method: " + enclosingMethodAttribute.getEnclosingMethod().toSourceString());
                }
            }
        }
        ps.println();
    }

    @Override
    void writeFieldsHeader(DexProgramClass clazz, PrintStream ps) {
        if (this.writeFields) {
            ps.println("#");
            ps.println("# Fields:");
            ps.println("#");
        }
    }

    @Override
    void writeField(DexEncodedField field, PrintStream ps) {
        if (this.writeFields) {
            ClassNameMapper naming = this.application.getProguardMap();
            MemberNaming.FieldSignature fieldSignature = naming != null ? naming.originalSignatureOf((DexField)field.getReference()) : MemberNaming.FieldSignature.fromDexField((DexField)field.getReference());
            this.writeAnnotations(null, field.annotations(), ps);
            ps.print(field.accessFlags + " ");
            ps.print(fieldSignature);
            if (field.isStatic() && field.hasExplicitStaticValue()) {
                ps.print(" = " + field.getStaticValue());
            }
            ps.println();
        }
    }

    @Override
    void writeFieldsFooter(DexProgramClass clazz, PrintStream ps) {
        ps.println();
    }

    @Override
    void writeMethod(ProgramMethod method, PrintStream ps) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        ClassNameMapper naming = this.application.getProguardMap();
        String methodName = naming != null ? naming.originalSignatureOf((DexMethod)((DexMethod)method.getReference())).name : ((DexMethod)method.getReference()).name.toString();
        ps.println("#");
        ps.println("# Method: '" + methodName + "':");
        this.writeAnnotations(null, definition.annotations(), ps);
        ps.println("# " + definition.accessFlags);
        ps.println("#");
        ps.println();
        if (!this.writeCode) {
            return;
        }
        Code code = definition.getCode();
        if (code != null) {
            if (this.writeIR) {
                this.writeIR(method, ps);
            } else {
                ps.println(code.toString(definition, naming));
            }
        }
    }

    @Override
    void writeClassFooter(DexProgramClass clazz, PrintStream ps) {
    }
}

