/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfFrameVerificationHelper;
import com.android.tools.r8.cf.code.CfIinc;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ArgumentUse;
import com.android.tools.r8.graph.CfCodeDiagnostics;
import com.android.tools.r8.graph.CfCodeStackMapValidatingException;
import com.android.tools.r8.graph.CfCompareHelper;
import com.android.tools.r8.graph.CfWritableCode;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeInstructionMetadata;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeMetadata;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.ExtraParameter;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiPredicate;

public class CfCode
extends Code
implements CfWritableCode,
StructuralItem<CfCode> {
    private final DexType originalHolder;
    private int maxLocals;
    private int maxStack;
    private List<CfInstruction> instructions;
    private final List<CfTryCatch> tryCatchRanges;
    private final List<LocalVariableInfo> localVariables;
    private StackMapStatus stackMapStatus = StackMapStatus.NOT_VERIFIED;
    private final com.android.tools.r8.position.Position diagnosticPosition;
    private final BytecodeMetadata<CfInstruction> metadata;

    public CfCode(DexType originalHolder, int maxStack, int maxLocals, List<CfInstruction> instructions) {
        this(originalHolder, maxStack, maxLocals, instructions, Collections.emptyList(), Collections.emptyList());
    }

    public CfCode(DexType originalHolder, int maxStack, int maxLocals, List<CfInstruction> instructions, List<CfTryCatch> tryCatchRanges, List<LocalVariableInfo> localVariables) {
        this(originalHolder, maxStack, maxLocals, instructions, tryCatchRanges, localVariables, com.android.tools.r8.position.Position.UNKNOWN);
    }

    public CfCode(DexType originalHolder, int maxStack, int maxLocals, List<CfInstruction> instructions, List<CfTryCatch> tryCatchRanges, List<LocalVariableInfo> localVariables, com.android.tools.r8.position.Position diagnosticPosition) {
        this(originalHolder, maxStack, maxLocals, instructions, tryCatchRanges, localVariables, diagnosticPosition, BytecodeMetadata.empty());
    }

    public CfCode(DexType originalHolder, int maxStack, int maxLocals, List<CfInstruction> instructions, List<CfTryCatch> tryCatchRanges, List<LocalVariableInfo> localVariables, com.android.tools.r8.position.Position diagnosticPosition, BytecodeMetadata<CfInstruction> metadata) {
        this.originalHolder = originalHolder;
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.instructions = instructions;
        this.tryCatchRanges = tryCatchRanges;
        this.localVariables = localVariables;
        this.diagnosticPosition = diagnosticPosition;
        this.metadata = metadata;
    }

    private int countNonStackOperations(int threshold) {
        int result = 0;
        for (CfInstruction instruction : this.instructions) {
            if (instruction.emitsIR() && ++result > threshold) break;
        }
        return result;
    }

    private boolean shouldAddParameterNames(DexEncodedMethod method, AppView<?> appView) {
        if (appView.options().cfToCfDesugar) {
            return false;
        }
        if (appView.options().debug || appView.isCfByteCodePassThrough(method)) {
            return false;
        }
        assert (this.localVariables.isEmpty());
        if (!method.hasParameterInfo()) {
            return false;
        }
        return !((AppInfo)appView.appInfo()).hasLiveness() || ((AppInfo)appView.appInfo()).withLiveness().isPinned(method.getReference());
    }

    private void writeLocalVariableEntry(MethodVisitor visitor, GraphLens graphLens, NamingLens namingLens, DebugLocalInfo info, CfLabel start, CfLabel end, int index) {
        DexType rewrittenType = graphLens.lookupType(info.type);
        visitor.visitLocalVariable(info.name.toString(), namingLens.lookupDescriptor(rewrittenType).toString(), info.signature == null ? null : info.signature.toString(), start.getLabel(), end.getLabel(), index);
    }

    private void verifyFramesOrRemove(ProgramMethod method, AppView<?> appView, GraphLens codeLens) {
        this.stackMapStatus = this.verifyFrames(method, appView, codeLens);
        if (!this.stackMapStatus.isValid()) {
            ArrayList<CfInstruction> copy = new ArrayList<CfInstruction>(this.instructions);
            copy.removeIf(CfInstruction::isFrame);
            this.setInstructions(copy);
        }
    }

    private IRCode internalBuildPossiblyWithLocals(ProgramMethod context, ProgramMethod method, AppView<?> appView, GraphLens codeLens, NumberGenerator valueNumberGenerator, Position callerPosition, Origin origin, RewrittenPrototypeDescription protoChanges, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        if (!method.keepLocals(appView)) {
            return this.internalBuild(Collections.emptyList(), context, method, appView, codeLens, valueNumberGenerator, callerPosition, origin, protoChanges, conversionOptions);
        }
        return this.internalBuildWithLocals(context, method, appView, codeLens, valueNumberGenerator, callerPosition, origin, protoChanges, conversionOptions);
    }

    private IRCode internalBuildWithLocals(ProgramMethod context, ProgramMethod method, AppView<?> appView, GraphLens codeLens, NumberGenerator valueNumberGenerator, Position callerPosition, Origin origin, RewrittenPrototypeDescription protoChanges, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        try {
            return this.internalBuild(Collections.unmodifiableList(this.localVariables), context, method, appView, codeLens, valueNumberGenerator, callerPosition, origin, protoChanges, conversionOptions);
        }
        catch (InvalidDebugInfoException e) {
            appView.options().warningInvalidDebugInfo(method, origin, e);
            return this.internalBuild(Collections.emptyList(), context, method, appView, codeLens, valueNumberGenerator, callerPosition, origin, protoChanges, conversionOptions);
        }
    }

    private IRCode internalBuild(List<LocalVariableInfo> localVariables, ProgramMethod context, ProgramMethod method, AppView<?> appView, GraphLens codeLens, NumberGenerator valueNumberGenerator, Position callerPosition, Origin origin, RewrittenPrototypeDescription protoChanges, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        IRBuilder builder;
        CfSourceCode source = new CfSourceCode(this, localVariables, method, appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference()), callerPosition, origin, appView);
        if (valueNumberGenerator == null) {
            assert (protoChanges == null);
            builder = IRBuilder.create(method, appView, source, origin);
        } else {
            builder = IRBuilder.createForInlining(method, appView, codeLens, source, origin, valueNumberGenerator, protoChanges);
        }
        return builder.build(context, conversionOptions);
    }

    private StackMapStatus reportStackMapError(CfCodeDiagnostics diagnostics, AppView<?> appView) {
        appView.options().reporter.warning(diagnostics);
        return StackMapStatus.INVALID;
    }

    private boolean finalAndExitInstruction(CfInstruction instruction) {
        boolean isReturnOrThrow;
        boolean bl = isReturnOrThrow = instruction.isThrow() || instruction.isReturn();
        if (!isReturnOrThrow) {
            return false;
        }
        for (int i = this.instructions.size() - 1; i >= 0; --i) {
            CfInstruction instr = this.instructions.get(i);
            if (instr == instruction) {
                return true;
            }
            if (instr.isPosition() || instr.isLabel()) continue;
            return false;
        }
        throw new Unreachable("Instruction " + instruction + " should be in instructions");
    }

    private boolean shouldComputeInitialFrame() {
        for (CfInstruction instruction : this.instructions) {
            if (instruction.isFrame()) {
                return false;
            }
            if (instruction.isLabel() || instruction.isPosition()) continue;
            return true;
        }
        assert (false);
        return true;
    }

    private Int2ReferenceSortedMap<CfFrame.FrameType> computeInitialLocals(AppView<?> appView, DexMethod method, boolean isInstance, RewrittenPrototypeDescription prototypeChanges) {
        CfFrame.FrameType frameType;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        Int2ReferenceAVLTreeMap<CfFrame.FrameType> initialLocals = new Int2ReferenceAVLTreeMap<CfFrame.FrameType>();
        int index = 0;
        if (isInstance) {
            initialLocals.put(index++, method.isInstanceInitializer(dexItemFactory) || method.mustBeInlinedIntoInstanceInitializer(appView) || method.isHorizontallyMergedInstanceInitializer(dexItemFactory) ? CfFrame.FrameType.uninitializedThis() : CfFrame.FrameType.initialized(method.getHolderType()));
        }
        for (DexType parameter : method.getParameters()) {
            frameType = CfFrame.FrameType.initialized(parameter);
            initialLocals.put(index++, frameType);
            if (!frameType.isWide()) continue;
            initialLocals.put(index++, frameType);
        }
        for (ExtraParameter extraParameter : prototypeChanges.getExtraParameters()) {
            frameType = CfFrame.FrameType.initialized(extraParameter.getType(dexItemFactory));
            initialLocals.put(index++, frameType);
            if (!frameType.isWide()) continue;
            initialLocals.put(index++, frameType);
        }
        return initialLocals;
    }

    private BiPredicate<DexType, DexType> isAssignablePredicate(AppView<?> appView) {
        return (source, target) -> this.isAssignable((DexType)source, (DexType)target, appView);
    }

    private boolean isAssignable(DexType source, DexType target, AppView<?> appView) {
        DexItemFactory factory = appView.dexItemFactory();
        if ((source = this.byteCharShortOrBooleanToInt(source, factory)) == (target = this.byteCharShortOrBooleanToInt(target, factory))) {
            return true;
        }
        if (source.isPrimitiveType() || target.isPrimitiveType()) {
            return false;
        }
        if (target == factory.objectType) {
            return true;
        }
        if (source == DexItemFactory.nullValueType) {
            return true;
        }
        if (target.isArrayType() != target.isArrayType()) {
            return false;
        }
        if (target.isArrayType()) {
            return this.isAssignable(target.toArrayElementType(factory), target.toArrayElementType(factory), appView);
        }
        return MemberType.fromDexType(source) == MemberType.fromDexType(target);
    }

    private DexType byteCharShortOrBooleanToInt(DexType type, DexItemFactory factory) {
        if (type.isByteType() || type.isCharType() || type.isShortType() || type.isBooleanType()) {
            return factory.intType;
        }
        return type;
    }

    @Override
    public CfCode self() {
        return this;
    }

    @Override
    public CfWritableCode.CfWritableCodeKind getCfWritableCodeKind() {
        return CfWritableCode.CfWritableCodeKind.DEFAULT;
    }

    public BytecodeMetadata<CfInstruction> getMetadata() {
        return this.metadata;
    }

    @Override
    public BytecodeInstructionMetadata getMetadata(CfOrDexInstruction instruction) {
        return this.getMetadata(instruction.asCfInstruction());
    }

    public BytecodeInstructionMetadata getMetadata(CfInstruction instruction) {
        return this.metadata.getMetadata(instruction);
    }

    @Override
    public StructuralMapping<CfCode> getStructuralMapping() {
        throw new Unreachable();
    }

    public DexType getOriginalHolder() {
        return this.originalHolder;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public StackMapStatus getStackMapStatus() {
        assert (this.stackMapStatus != StackMapStatus.NOT_VERIFIED);
        return this.stackMapStatus;
    }

    public com.android.tools.r8.position.Position getDiagnosticPosition() {
        return this.diagnosticPosition;
    }

    public void setMaxLocals(int newMaxLocals) {
        this.maxLocals = newMaxLocals;
    }

    public void setMaxStack(int newMaxStack) {
        this.maxStack = newMaxStack;
    }

    public List<CfTryCatch> getTryCatchRanges() {
        return this.tryCatchRanges;
    }

    public List<CfInstruction> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    public void setInstructions(List<CfInstruction> instructions) {
        this.instructions = instructions;
    }

    public List<LocalVariableInfo> getLocalVariables() {
        return Collections.unmodifiableList(this.localVariables);
    }

    @Override
    public int estimatedSizeForInlining() {
        return this.countNonStackOperations(Integer.MAX_VALUE);
    }

    @Override
    public boolean estimatedSizeForInliningAtMost(int threshold) {
        return this.countNonStackOperations(threshold) <= threshold;
    }

    @Override
    public int estimatedDexCodeSizeUpperBoundInBytes() {
        return this.estimatedSizeForInlining() * 5;
    }

    @Override
    public boolean isCfCode() {
        return true;
    }

    @Override
    public boolean isCfWritableCode() {
        return true;
    }

    @Override
    public CfCode asCfCode() {
        return this;
    }

    @Override
    public CfWritableCode asCfWritableCode() {
        return this;
    }

    @Override
    public void acceptHashing(HashingVisitor visitor) {
        visitor.visitInt(this.instructions.size());
        visitor.visitInt(this.tryCatchRanges.size());
        visitor.visitInt(this.localVariables.size());
        this.instructions.forEach(i -> visitor.visitInt(i.getCompareToId()));
    }

    @Override
    public int acceptCompareTo(CfCode other, CompareToVisitor visitor) {
        CfCompareHelper helper = new CfCompareHelper(this, other);
        return visitor.visit(this, other, spec -> ((StructuralSpecification)((StructuralSpecification)spec.withCustomItemCollection(c -> c.instructions, helper.instructionAcceptor())).withCustomItemCollection(c -> c.tryCatchRanges, helper.tryCatchRangeAcceptor())).withCustomItemCollection(c -> c.localVariables, helper.localVariableAcceptor()));
    }

    @Override
    public void writeCf(ProgramMethod method, CfVersion classFileVersion, AppView<?> appView, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        GraphLens graphLens = appView.graphLens();
        assert (this.verifyFrames(method, appView).isValid()) : "Could not validate stack map frames";
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        InitClassLens initClassLens = appView.initClassLens();
        InternalOptions options = appView.options();
        CfLabel parameterLabel = null;
        if (this.shouldAddParameterNames((DexEncodedMethod)method.getDefinition(), appView)) {
            parameterLabel = new CfLabel();
            parameterLabel.write(appView, method, dexItemFactory, graphLens, initClassLens, namingLens, rewriter, visitor);
        }
        for (CfInstruction cfInstruction : this.instructions) {
            if (cfInstruction instanceof CfFrame && (classFileVersion.isLessThan(CfVersion.V1_6) || classFileVersion.isEqualTo(CfVersion.V1_6) && !options.shouldKeepStackMapTable())) continue;
            cfInstruction.write(appView, method, dexItemFactory, graphLens, initClassLens, namingLens, rewriter, visitor);
        }
        visitor.visitEnd();
        visitor.visitMaxs(this.maxStack, this.maxLocals);
        for (CfTryCatch cfTryCatch : this.tryCatchRanges) {
            Label label = cfTryCatch.start.getLabel();
            Label end = cfTryCatch.end.getLabel();
            for (int i = 0; i < cfTryCatch.guards.size(); ++i) {
                DexType guard = cfTryCatch.guards.get(i);
                DexType rewrittenGuard = graphLens.lookupType(guard);
                Label target = cfTryCatch.targets.get(i).getLabel();
                visitor.visitTryCatchBlock(label, end, target, rewrittenGuard == options.itemFactory.throwableType ? null : namingLens.lookupInternalName(rewrittenGuard));
            }
        }
        if (parameterLabel != null) {
            assert (this.localVariables.isEmpty());
            Int2ReferenceMap<DebugLocalInfo> parameterInfo = ((DexEncodedMethod)method.getDefinition()).getParameterInfo();
            for (Int2ReferenceMap.Entry entry : parameterInfo.int2ReferenceEntrySet()) {
                this.writeLocalVariableEntry(visitor, graphLens, namingLens, (DebugLocalInfo)entry.getValue(), parameterLabel, parameterLabel, entry.getIntKey());
            }
        } else {
            for (LocalVariableInfo localVariableInfo : this.localVariables) {
                this.writeLocalVariableEntry(visitor, graphLens, namingLens, localVariableInfo.local, localVariableInfo.start, localVariableInfo.end, localVariableInfo.index);
            }
        }
    }

    @Override
    protected int computeHashCode() {
        throw new Unimplemented();
    }

    @Override
    protected boolean computeEquals(Object other) {
        throw new Unimplemented();
    }

    @Override
    public boolean isEmptyVoidMethod() {
        for (CfInstruction insn : this.instructions) {
            if (insn instanceof CfReturnVoid || insn instanceof CfLabel || insn instanceof CfPosition) continue;
            return false;
        }
        return true;
    }

    @Override
    public IRCode buildIR(ProgramMethod method, AppView<?> appView, Origin origin, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        this.verifyFramesOrRemove(method, appView, this.getCodeLens(appView));
        return this.internalBuildPossiblyWithLocals(method, method, appView, appView.codeLens(), null, null, origin, null, conversionOptions);
    }

    @Override
    public IRCode buildInliningIR(ProgramMethod context, ProgramMethod method, AppView<?> appView, GraphLens codeLens, NumberGenerator valueNumberGenerator, Position callerPosition, Origin origin, RewrittenPrototypeDescription protoChanges) {
        assert (valueNumberGenerator != null);
        assert (callerPosition != null);
        assert (protoChanges != null);
        this.verifyFramesOrRemove(method, appView, codeLens);
        return this.internalBuildPossiblyWithLocals(context, method, appView, codeLens, valueNumberGenerator, callerPosition, origin, protoChanges, new MethodConversionOptions.ThrowingMethodConversionOptions(appView.options()));
    }

    @Override
    public void registerCodeReferences(ProgramMethod method, UseRegistry registry) {
        assert (registry.getTraversalContinuation().shouldContinue());
        ListIterator<CfInstruction> iterator2 = this.instructions.listIterator();
        while (iterator2.hasNext()) {
            CfInstruction instruction = iterator2.next();
            instruction.registerUse(registry, method, iterator2);
            if (!registry.getTraversalContinuation().shouldBreak()) continue;
            return;
        }
        for (CfTryCatch tryCatch : this.tryCatchRanges) {
            tryCatch.internalRegisterUse(registry, method);
            if (!registry.getTraversalContinuation().shouldBreak()) continue;
            return;
        }
    }

    @Override
    public void registerCodeReferencesForDesugaring(ClasspathMethod method, UseRegistry registry) {
        ListIterator<CfInstruction> iterator2 = this.instructions.listIterator();
        while (iterator2.hasNext()) {
            CfInstruction instruction = iterator2.next();
            instruction.registerUseForDesugaring(registry, method, iterator2);
        }
        this.tryCatchRanges.forEach(tryCatch -> tryCatch.guards.forEach(registry::registerTypeReference));
    }

    @Override
    public Int2ReferenceMap<DebugLocalInfo> collectParameterInfo(DexEncodedMethod encodedMethod, AppView<?> appView) {
        CfLabel firstLabel = null;
        for (CfInstruction instruction : this.instructions) {
            if (!(instruction instanceof CfLabel)) continue;
            firstLabel = (CfLabel)instruction;
            break;
        }
        if (firstLabel == null) {
            return DexEncodedMethod.NO_PARAMETER_INFO;
        }
        if (!appView.options().hasProguardConfiguration() || !appView.options().getProguardConfiguration().isKeepParameterNames()) {
            return DexEncodedMethod.NO_PARAMETER_INFO;
        }
        if (((AppInfo)appView.appInfo()).hasLiveness() && !((AppInfo)appView.appInfo()).withLiveness().isPinned(encodedMethod.getReference())) {
            return DexEncodedMethod.NO_PARAMETER_INFO;
        }
        BitSet localSlotsForParameters = new BitSet(0);
        int nextLocalSlotsForParameters = 0;
        if (!encodedMethod.isStatic()) {
            localSlotsForParameters.set(nextLocalSlotsForParameters++);
        }
        for (DexType type : ((DexMethod)encodedMethod.getReference()).proto.parameters.values) {
            localSlotsForParameters.set(nextLocalSlotsForParameters);
            nextLocalSlotsForParameters += type.isLongType() || type.isDoubleType() ? 2 : 1;
        }
        Int2ReferenceArrayMap<DebugLocalInfo> parameterInfo = new Int2ReferenceArrayMap<DebugLocalInfo>(localSlotsForParameters.cardinality());
        for (LocalVariableInfo node : this.localVariables) {
            if (node.start != firstLabel || !localSlotsForParameters.get(node.index) || parameterInfo.containsKey(node.index)) continue;
            parameterInfo.put(node.index, new DebugLocalInfo(((LocalVariableInfo)node).local.name, ((LocalVariableInfo)node).local.type, ((LocalVariableInfo)node).local.signature));
        }
        return parameterInfo;
    }

    @Override
    public void registerArgumentReferences(DexEncodedMethod method, ArgumentUse registry) {
        DexProto proto = ((DexMethod)method.getReference()).proto;
        boolean isStatic = method.accessFlags.isStatic();
        int argumentCount = proto.parameters.values.length + (isStatic ? 0 : 1);
        Int2IntArrayMap indexToNumber = new Int2IntArrayMap(argumentCount);
        int index = 0;
        int number = 0;
        if (!isStatic) {
            indexToNumber.put(index++, number++);
        }
        for (DexType value : proto.parameters.values) {
            indexToNumber.put(index++, number++);
            if (!value.isLongType() && !value.isDoubleType()) continue;
            ++index;
        }
        assert (indexToNumber.size() == argumentCount);
        for (CfInstruction instruction : this.instructions) {
            int index2 = -1;
            if (instruction instanceof CfLoad) {
                index2 = ((CfLoad)instruction).getLocalIndex();
            } else {
                if (!(instruction instanceof CfIinc)) continue;
                index2 = ((CfIinc)instruction).getLocalIndex();
            }
            if (index2 < 0 || !indexToNumber.containsKey(index2)) continue;
            registry.register(indexToNumber.get(index2));
        }
    }

    @Override
    public String toString() {
        return new CfPrinter(this).toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return new CfPrinter(this, method, naming).toString();
    }

    public Inliner.ConstraintWithTarget computeInliningConstraint(ProgramMethod method, AppView<AppInfoWithLiveness> appView, GraphLens graphLens, ProgramMethod context) {
        Inliner.ConstraintWithTarget constraint;
        InliningConstraints inliningConstraints = new InliningConstraints(appView, graphLens);
        if (appView.options().isInterfaceMethodDesugaringEnabled()) {
            inliningConstraints.disallowStaticInterfaceMethodCalls();
        }
        Inliner.ConstraintWithTarget constraintWithTarget = constraint = ((DexEncodedMethod)method.getDefinition()).isSynchronized() ? inliningConstraints.forMonitor() : Inliner.ConstraintWithTarget.ALWAYS;
        if (constraint == Inliner.ConstraintWithTarget.NEVER) {
            return constraint;
        }
        for (CfInstruction insn : this.instructions) {
            if ((constraint = Inliner.ConstraintWithTarget.meet(constraint, insn.inliningConstraint(inliningConstraints, this, context), appView)) != Inliner.ConstraintWithTarget.NEVER) continue;
            return constraint;
        }
        if (!this.tryCatchRanges.isEmpty()) {
            constraint = Inliner.ConstraintWithTarget.meet(constraint, inliningConstraints.forMoveException(), appView);
        }
        return constraint;
    }

    void addFakeThisParameter(DexItemFactory factory) {
        if (this.localVariables == null || this.localVariables.isEmpty()) {
            return;
        }
        int largestPrefix = 0;
        int existingThisIndex = -1;
        for (int i = 0; i < this.localVariables.size(); ++i) {
            LocalVariableInfo localVariable = this.localVariables.get(i);
            largestPrefix = Math.max(largestPrefix, DexCode.getLargestPrefix(factory, ((LocalVariableInfo)localVariable).local.name));
            if (!((LocalVariableInfo)localVariable).local.name.toString().equals("this")) continue;
            existingThisIndex = i;
        }
        if (existingThisIndex < 0) {
            return;
        }
        String fakeThisName = Strings.repeat("_", largestPrefix + 1) + "this";
        DebugLocalInfo debugLocalInfo = new DebugLocalInfo(factory.createString(fakeThisName), this.originalHolder, null);
        LocalVariableInfo thisLocalInfo = this.localVariables.get(existingThisIndex);
        this.localVariables.set(existingThisIndex, new LocalVariableInfo(thisLocalInfo.index, debugLocalInfo, thisLocalInfo.start, thisLocalInfo.end));
    }

    @Override
    public Code getCodeAsInlining(DexMethod caller, DexMethod callee, DexItemFactory factory) {
        CfLabel firstLabel;
        Position.SyntheticPosition callerPosition = ((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)Position.SyntheticPosition.builder().setLine(0)).setMethod(caller)).build();
        ArrayList<CfInstruction> newInstructions = new ArrayList<CfInstruction>(this.instructions.size() + 2);
        if (this.instructions.get(0).isLabel()) {
            firstLabel = this.instructions.get(0).asLabel();
        } else {
            firstLabel = new CfLabel();
            newInstructions.add(firstLabel);
        }
        boolean seenPosition = false;
        for (CfInstruction instruction : this.instructions) {
            if (instruction.isPosition()) {
                seenPosition = true;
                CfPosition oldPosition = instruction.asPosition();
                newInstructions.add(new CfPosition(oldPosition.getLabel(), oldPosition.getPosition().withOutermostCallerPosition(callerPosition)));
                continue;
            }
            if (!instruction.isLabel() && !seenPosition) {
                newInstructions.add(new CfPosition(firstLabel, callerPosition));
                seenPosition = true;
            }
            newInstructions.add(instruction);
        }
        return new CfCode(this.originalHolder, this.maxStack, this.maxLocals, newInstructions, this.tryCatchRanges, this.localVariables);
    }

    public StackMapStatus verifyFrames(ProgramMethod method, AppView<?> appView) {
        return this.verifyFrames(method, appView, this.getCodeLens(appView));
    }

    public StackMapStatus verifyFrames(ProgramMethod method, AppView<?> appView, GraphLens codeLens) {
        GraphLens graphLens = appView.graphLens();
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (!appView.options().canUseInputStackMaps() || appView.options().testing.disableStackMapVerification) {
            return StackMapStatus.NOT_PRESENT;
        }
        if (definition.hasClassFileVersion() && definition.getClassFileVersion().isLessThan(CfVersion.V1_7)) {
            return StackMapStatus.NOT_PRESENT;
        }
        RewrittenPrototypeDescription protoChanges = graphLens.lookupPrototypeChangesForMethodDefinition((DexMethod)method.getReference(), codeLens);
        DexMethod previousMethodSignature = graphLens.getOriginalMethodSignature((DexMethod)method.getReference(), codeLens);
        boolean previousMethodSignatureIsInstance = ((DexEncodedMethod)method.getDefinition()).isInstance() || protoChanges.getArgumentInfoCollection().isConvertedToStaticMethod();
        IdentityHashMap<CfLabel, CfFrame> stateMap = new IdentityHashMap<CfLabel, CfFrame>();
        ArrayList<CfLabel> labels = new ArrayList<CfLabel>();
        boolean requireStackMapFrame = !this.tryCatchRanges.isEmpty();
        for (CfInstruction instruction : this.instructions) {
            if (instruction.isFrame()) {
                CfFrame frame = instruction.asFrame();
                if (!labels.isEmpty()) {
                    for (CfLabel label : labels) {
                        if (stateMap.containsKey(label)) {
                            return this.reportStackMapError(CfCodeStackMapValidatingException.multipleFramesForLabel(method, appView), appView);
                        }
                        stateMap.put(label, frame);
                    }
                } else if (instruction != this.instructions.get(0)) {
                    return this.reportStackMapError(CfCodeStackMapValidatingException.unexpectedStackMapFrame(method, appView), appView);
                }
            }
            if (instruction.isPosition()) continue;
            if (instruction.isLabel()) {
                labels.add(instruction.asLabel());
            } else {
                labels.clear();
            }
            if (requireStackMapFrame) continue;
            requireStackMapFrame = instruction.isJump() && !this.finalAndExitInstruction(instruction);
        }
        if (requireStackMapFrame && stateMap.isEmpty()) {
            return this.reportStackMapError(CfCodeStackMapValidatingException.noFramesForMethodWithJumps(method, appView), appView);
        }
        CfFrameVerificationHelper builder = new CfFrameVerificationHelper(previousMethodSignature.getHolderType(), stateMap, this.tryCatchRanges, this.isAssignablePredicate(appView), appView.dexItemFactory(), this.maxStack);
        if (stateMap.containsKey(null)) {
            assert (!this.shouldComputeInitialFrame());
            builder.checkFrameAndSet((CfFrame)stateMap.get(null));
        } else if (this.shouldComputeInitialFrame()) {
            builder.checkFrameAndSet(new CfFrame(this.computeInitialLocals(appView, previousMethodSignature, previousMethodSignatureIsInstance, protoChanges), (Deque<CfFrame.FrameType>)new ArrayDeque<CfFrame.FrameType>()));
        }
        for (int i = 0; i < this.instructions.size(); ++i) {
            CfInstruction instruction = this.instructions.get(i);
            try {
                if (instruction.canThrow()) {
                    assert (!instruction.isStore());
                    builder.checkExceptionEdges();
                }
                instruction.evaluate(builder, previousMethodSignature, appView, appView.dexItemFactory());
                continue;
            }
            catch (CfCodeStackMapValidatingException ex) {
                return this.reportStackMapError(CfCodeStackMapValidatingException.toDiagnostics(method, i, instruction, ex.getMessage(), appView), appView);
            }
        }
        return StackMapStatus.VALID;
    }

    public static class LocalVariableInfo {
        private final int index;
        private final DebugLocalInfo local;
        private final CfLabel start;
        private CfLabel end;

        public LocalVariableInfo(int index, DebugLocalInfo local, CfLabel start) {
            this.index = index;
            this.local = local;
            this.start = start;
        }

        public LocalVariableInfo(int index, DebugLocalInfo local, CfLabel start, CfLabel end) {
            this(index, local, start);
            this.setEnd(end);
        }

        public void setEnd(CfLabel end) {
            assert (this.end == null);
            assert (end != null);
            this.end = end;
        }

        public int getIndex() {
            return this.index;
        }

        public DebugLocalInfo getLocal() {
            return this.local;
        }

        public CfLabel getStart() {
            return this.start;
        }

        public CfLabel getEnd() {
            return this.end;
        }

        public int acceptCompareTo(LocalVariableInfo other, CompareToVisitor visitor, CfCompareHelper helper) {
            return visitor.visit(this, other, spec -> ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withInt(LocalVariableInfo::getIndex)).withCustomItem(LocalVariableInfo::getStart, helper.labelAcceptor())).withCustomItem(LocalVariableInfo::getEnd, helper.labelAcceptor())).withItem(LocalVariableInfo::getLocal));
        }

        public String toString() {
            return "" + this.index + " => " + this.local;
        }
    }

    public static enum StackMapStatus {
        NOT_VERIFIED,
        NOT_PRESENT,
        INVALID,
        VALID;


        public boolean isValid() {
            return this == VALID || this == NOT_PRESENT;
        }

        public boolean isInvalidOrNotPresent() {
            return this == INVALID || this == NOT_PRESENT;
        }
    }
}

