/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralAcceptor;

public class CfCompareHelper {
    public static final int CONST_CLASS_COMPARE_ID;
    public static final int CONST_STRING_COMPARE_ID;
    public static final int CONST_STRING_DEX_ITEM_COMPARE_ID;
    public static final int CONST_NUMBER_COMPARE_ID;
    public static final int CONST_METHOD_TYPE_COMPARE_ID;
    public static final int CONST_METHOD_HANDLE_COMPARE_ID;
    public static final int CONST_DYNAMIC_COMPARE_ID;
    public static final int FRAME_COMPARE_ID;
    public static final int INIT_CLASS_COMPARE_ID;
    public static final int LABEL_COMPARE_ID;
    public static final int POSITION_COMPARE_ID;
    public static final int RECORD_FIELD_VALUES_COMPARE_ID;
    private final CfCode code1;
    private final CfCode code2;
    private StructuralAcceptor<CfLabel> lazyLabelAcceptor = null;

    public static int compareIdUniquelyDeterminesEquality(CfInstruction instruction1, CfInstruction instruction2) {
        assert (instruction1.getClass() == instruction2.getClass());
        assert (instruction1.getCompareToId() == instruction2.getCompareToId());
        assert (instruction1.toString().equals(instruction2.toString()));
        return 0;
    }

    private static Reference2IntMap<CfLabel> getLabelOrdering(CfCode code) {
        Reference2IntOpenHashMap<CfLabel> ordering = new Reference2IntOpenHashMap<CfLabel>();
        for (CfInstruction instruction : code.getInstructions()) {
            if (!instruction.isLabel()) continue;
            ordering.put(instruction.asLabel(), ordering.size());
        }
        return ordering;
    }

    public CfCompareHelper(CfCode code1, CfCode code2) {
        this.code1 = code1;
        this.code2 = code2;
    }

    static {
        int lastId = 199;
        ++lastId;
        CONST_CLASS_COMPARE_ID = lastId++;
        CONST_STRING_COMPARE_ID = lastId++;
        CONST_STRING_DEX_ITEM_COMPARE_ID = lastId++;
        CONST_NUMBER_COMPARE_ID = lastId++;
        CONST_METHOD_TYPE_COMPARE_ID = lastId++;
        CONST_METHOD_HANDLE_COMPARE_ID = lastId++;
        CONST_DYNAMIC_COMPARE_ID = lastId++;
        FRAME_COMPARE_ID = lastId++;
        INIT_CLASS_COMPARE_ID = lastId++;
        LABEL_COMPARE_ID = lastId++;
        POSITION_COMPARE_ID = lastId++;
        RECORD_FIELD_VALUES_COMPARE_ID = lastId;
    }

    public int compareLabels(CfLabel label1, CfLabel label2, CompareToVisitor visitor) {
        return this.labelAcceptor().acceptCompareTo(label1, label2, visitor);
    }

    public StructuralAcceptor<CfLabel> labelAcceptor() {
        if (this.lazyLabelAcceptor == null) {
            this.lazyLabelAcceptor = new StructuralAcceptor<CfLabel>(){
                private final Reference2IntMap<CfLabel> labels1;
                private final Reference2IntMap<CfLabel> labels2;
                {
                    this.labels1 = CfCompareHelper.getLabelOrdering(CfCompareHelper.this.code1);
                    this.labels2 = CfCompareHelper.getLabelOrdering(CfCompareHelper.this.code2);
                }

                @Override
                public int acceptCompareTo(CfLabel item1, CfLabel item2, CompareToVisitor visitor) {
                    return visitor.visitInt(this.labels1.getInt(item1), this.labels2.getInt(item2));
                }

                @Override
                public void acceptHashing(CfLabel item, HashingVisitor visitor) {
                    throw new Unimplemented();
                }
            };
        }
        return this.lazyLabelAcceptor;
    }

    public StructuralAcceptor<CfInstruction> instructionAcceptor() {
        final CfCompareHelper helper = this;
        return new StructuralAcceptor<CfInstruction>(){

            @Override
            public int acceptCompareTo(CfInstruction item1, CfInstruction item2, CompareToVisitor visitor) {
                return item1.acceptCompareTo(item2, visitor, helper);
            }

            @Override
            public void acceptHashing(CfInstruction item, HashingVisitor visitor) {
                throw new Unimplemented();
            }
        };
    }

    public StructuralAcceptor<CfTryCatch> tryCatchRangeAcceptor() {
        final CfCompareHelper helper = this;
        return new StructuralAcceptor<CfTryCatch>(){

            @Override
            public int acceptCompareTo(CfTryCatch item1, CfTryCatch item2, CompareToVisitor visitor) {
                return item1.acceptCompareTo(item2, visitor, helper);
            }

            @Override
            public void acceptHashing(CfTryCatch item, HashingVisitor visitor) {
                throw new Unimplemented();
            }
        };
    }

    public StructuralAcceptor<CfCode.LocalVariableInfo> localVariableAcceptor() {
        final CfCompareHelper helper = this;
        return new StructuralAcceptor<CfCode.LocalVariableInfo>(){

            @Override
            public int acceptCompareTo(CfCode.LocalVariableInfo item1, CfCode.LocalVariableInfo item2, CompareToVisitor visitor) {
                return item1.acceptCompareTo(item2, visitor, helper);
            }

            @Override
            public void acceptHashing(CfCode.LocalVariableInfo item, HashingVisitor visitor) {
                throw new Unimplemented();
            }
        };
    }
}

