/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramOrClasspathClass;
import java.util.function.Consumer;

public interface ClassResolutionResult {
    public static Builder builder() {
        return new Builder();
    }

    public boolean hasClassResolutionResult();

    public DexClass toSingleClassWithProgramOverLibrary();

    public void forEachClassResolutionResult(Consumer<DexClass> var1);

    public static class ClasspathAndLibraryClassResolutionResult
    extends MultipleClassResolutionResult<DexClasspathClass> {
        public ClasspathAndLibraryClassResolutionResult(DexClasspathClass classpathClass, DexLibraryClass libraryClass) {
            super(classpathClass, libraryClass);
        }

        @Override
        public DexClass toSingleClassWithProgramOverLibrary() {
            return this.libraryClass;
        }
    }

    public static class ProgramAndLibraryClassResolutionResult
    extends MultipleClassResolutionResult<DexProgramClass> {
        public ProgramAndLibraryClassResolutionResult(DexProgramClass programClass, DexLibraryClass libraryClass) {
            super(programClass, libraryClass);
        }

        @Override
        public DexClass toSingleClassWithProgramOverLibrary() {
            return this.programOrClasspathClass;
        }
    }

    public static abstract class MultipleClassResolutionResult<T extends DexClass>
    implements ClassResolutionResult {
        protected final T programOrClasspathClass;
        protected final DexLibraryClass libraryClass;

        public MultipleClassResolutionResult(T programOrClasspathClass, DexLibraryClass libraryClass) {
            this.programOrClasspathClass = programOrClasspathClass;
            this.libraryClass = libraryClass;
        }

        @Override
        public boolean hasClassResolutionResult() {
            return true;
        }

        @Override
        public void forEachClassResolutionResult(Consumer<DexClass> consumer) {
            consumer.accept((DexClass)this.programOrClasspathClass);
            consumer.accept(this.libraryClass);
        }
    }

    public static class NoResolutionResult
    implements ClassResolutionResult {
        private static final NoResolutionResult NO_RESULT = new NoResolutionResult();

        static ClassResolutionResult noResult() {
            return NO_RESULT;
        }

        @Override
        public boolean hasClassResolutionResult() {
            return false;
        }

        @Override
        public DexClass toSingleClassWithProgramOverLibrary() {
            return null;
        }

        @Override
        public void forEachClassResolutionResult(Consumer<DexClass> consumer) {
        }
    }

    public static class Builder {
        private ProgramOrClasspathClass programOrClasspathClass;
        private DexLibraryClass libraryClass;

        public Builder add(DexProgramClass programClass) {
            assert (this.programOrClasspathClass == null);
            this.programOrClasspathClass = programClass;
            return this;
        }

        public Builder add(DexClasspathClass classpathClass) {
            assert (this.programOrClasspathClass == null);
            this.programOrClasspathClass = classpathClass;
            return this;
        }

        public Builder add(DexLibraryClass libraryClass) {
            assert (this.libraryClass == null);
            this.libraryClass = libraryClass;
            return this;
        }

        public Builder add(ProgramOrClasspathClass programOrClasspathClass) {
            assert (this.programOrClasspathClass == null);
            this.programOrClasspathClass = programOrClasspathClass;
            return this;
        }

        public ClassResolutionResult build() {
            if (this.programOrClasspathClass == null && this.libraryClass == null) {
                return NoResolutionResult.noResult();
            }
            if (this.programOrClasspathClass == null) {
                return this.libraryClass;
            }
            if (this.libraryClass == null) {
                return this.programOrClasspathClass;
            }
            if (this.programOrClasspathClass.isProgramClass()) {
                return new ProgramAndLibraryClassResolutionResult(this.programOrClasspathClass.asProgramClass(), this.libraryClass);
            }
            assert (this.programOrClasspathClass.isClasspathClass());
            return new ClasspathAndLibraryClassResolutionResult(this.programOrClasspathClass.asClasspathClass(), this.libraryClass);
        }
    }
}

