/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.CodeToKeep;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.CfWritableCode;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfoForWriting;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexWritableCode;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.conversion.SyntheticStraightLineSourceCode;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.structural.HashingVisitor;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DefaultInstanceInitializerCode
extends Code
implements CfWritableCode,
DexWritableCode {
    private static final DefaultInstanceInitializerCode INSTANCE = new DefaultInstanceInitializerCode();

    private DefaultInstanceInitializerCode() {
    }

    public static DefaultInstanceInitializerCode get() {
        return INSTANCE;
    }

    public static boolean canonicalizeCodeIfPossible(AppView<?> appView, ProgramMethod method) {
        if (DefaultInstanceInitializerCode.hasDefaultInstanceInitializerCode(method, appView)) {
            method.setCode(DefaultInstanceInitializerCode.get(), appView);
            return true;
        }
        return false;
    }

    public static void uncanonicalizeCode(AppView<?> appView, ProgramMethod method) {
        DefaultInstanceInitializerCode.uncanonicalizeCode(appView, method, method.getHolder().getSuperType());
    }

    public static void uncanonicalizeCode(AppView<?> appView, ProgramMethod method, DexType superType) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        assert (definition.getCode().isDefaultInstanceInitializerCode());
        method.setCode(DefaultInstanceInitializerCode.get().toCfCode(method, appView.dexItemFactory(), superType), appView);
    }

    private static boolean hasDefaultInstanceInitializerCode(ProgramMethod method, AppView<?> appView) {
        Predicate<CfInstruction> instructionOfInterest;
        if (!((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
            return false;
        }
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        if (!code.isCfCode()) {
            return false;
        }
        CfCode cfCode = code.asCfCode();
        if (!(((DexEncodedMethod)method.getDefinition()).isInstanceInitializer() && cfCode.getLocalVariables().isEmpty() && cfCode.getTryCatchRanges().isEmpty())) {
            return false;
        }
        if (cfCode.getInstructions().size() > 6) {
            return false;
        }
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        Iterator<CfInstruction> instructionIterator = cfCode.getInstructions().iterator();
        CfLoad load = IteratorUtils.nextUntil(instructionIterator, instructionOfInterest = method.getHolder().getSuperType() == dexItemFactory.objectType ? instruction -> !instruction.isLabel() && !instruction.isPosition() : instruction -> !instruction.isLabel()).asLoad();
        if (load == null || load.getLocalIndex() != 0) {
            return false;
        }
        CfInvoke invoke = instructionIterator.next().asInvoke();
        if (invoke == null || !invoke.isInvokeConstructor(dexItemFactory) || invoke.getMethod() != DefaultInstanceInitializerCode.getParentConstructor(method, dexItemFactory)) {
            return false;
        }
        return instructionIterator.next().isReturnVoid();
    }

    static DexMethod getParentConstructor(DexClassAndMethod method, DexItemFactory dexItemFactory) {
        return dexItemFactory.createInstanceInitializer(method.getHolder().getSuperType(), new DexType[0]);
    }

    private int getMaxLocals(ProgramMethod method) {
        int maxLocals = method.getAccessFlags().isStatic() ? 0 : 1;
        for (DexType parameter : method.getParameters()) {
            maxLocals += parameter.getRequiredRegisters();
        }
        return maxLocals;
    }

    private int getMaxStack() {
        return 1;
    }

    private void internalRegisterCodeReferences(DexClassAndMethod method, UseRegistry<?> registry) {
        registry.registerInvokeDirect(DefaultInstanceInitializerCode.getParentConstructor(method, registry.dexItemFactory()));
    }

    @Override
    public Code asCode() {
        return this;
    }

    @Override
    public void acceptHashing(HashingVisitor visitor) {
        visitor.visitInt(this.getCfWritableCodeKind().hashCode());
    }

    @Override
    public IRCode buildIR(ProgramMethod method, AppView<?> appView, Origin origin, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        DexMethod originalMethod = appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference());
        DefaultInstanceInitializerSourceCode source = new DefaultInstanceInitializerSourceCode(originalMethod);
        return IRBuilder.create(method, appView, source, origin).build(method, conversionOptions);
    }

    @Override
    public IRCode buildInliningIR(ProgramMethod context, ProgramMethod method, AppView<?> appView, GraphLens codeLens, NumberGenerator valueNumberGenerator, Position callerPosition, Origin origin, RewrittenPrototypeDescription protoChanges) {
        DexMethod originalMethod = appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference());
        DefaultInstanceInitializerSourceCode source = new DefaultInstanceInitializerSourceCode(originalMethod, callerPosition);
        return IRBuilder.createForInlining(method, appView, codeLens, source, origin, valueNumberGenerator, protoChanges).build(context, new MethodConversionOptions.ThrowingMethodConversionOptions(appView.options()));
    }

    @Override
    public int codeSizeInBytes() {
        return 4;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        DefaultInstanceInitializerCode.getParentConstructor(context, rewriter.dexItemFactory()).collectIndexedItems(indexedItems);
    }

    @Override
    public void collectMixedSectionItems(MixedSectionCollection mixedItems) {
    }

    @Override
    protected int computeHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    protected boolean computeEquals(Object other) {
        return this == other;
    }

    @Override
    public int estimatedDexCodeSizeUpperBoundInBytes() {
        return this.codeSizeInBytes();
    }

    @Override
    public CfWritableCode.CfWritableCodeKind getCfWritableCodeKind() {
        return CfWritableCode.CfWritableCodeKind.DEFAULT_INSTANCE_INITIALIZER;
    }

    @Override
    public DexWritableCode.DexWritableCodeKind getDexWritableCodeKind() {
        return DexWritableCode.DexWritableCodeKind.DEFAULT_INSTANCE_INITIALIZER;
    }

    @Override
    public DexDebugInfoForWriting getDebugInfoForWriting() {
        return null;
    }

    @Override
    public DexCode.TryHandler[] getHandlers() {
        return new DexCode.TryHandler[0];
    }

    @Override
    public DexString getHighestSortingString() {
        return null;
    }

    @Override
    public int getIncomingRegisterSize(ProgramMethod method) {
        return this.getMaxLocals(method);
    }

    @Override
    public int getOutgoingRegisterSize() {
        return 1;
    }

    @Override
    public int getRegisterSize(ProgramMethod method) {
        return this.getIncomingRegisterSize(method);
    }

    @Override
    public DexCode.Try[] getTries() {
        return new DexCode.Try[0];
    }

    @Override
    public boolean isCfWritableCode() {
        return true;
    }

    @Override
    public CfWritableCode asCfWritableCode() {
        return this;
    }

    @Override
    public boolean isDexWritableCode() {
        return true;
    }

    @Override
    public DexWritableCode asDexWritableCode() {
        return this;
    }

    @Override
    public boolean isEmptyVoidMethod() {
        return false;
    }

    @Override
    public boolean isDefaultInstanceInitializerCode() {
        return true;
    }

    @Override
    public DefaultInstanceInitializerCode asDefaultInstanceInitializerCode() {
        return this;
    }

    @Override
    public boolean isSharedCodeObject() {
        return true;
    }

    @Override
    public void registerCodeReferences(ProgramMethod method, UseRegistry registry) {
        this.internalRegisterCodeReferences(method, registry);
    }

    @Override
    public void registerCodeReferencesForDesugaring(ClasspathMethod method, UseRegistry registry) {
        this.internalRegisterCodeReferences(method, registry);
    }

    @Override
    public DexWritableCode rewriteCodeWithJumboStrings(ProgramMethod method, ObjectToOffsetMapping mapping, DexItemFactory factory, boolean force) {
        return this;
    }

    @Override
    public void setCallSiteContexts(ProgramMethod method) {
    }

    public CfCode toCfCode(ProgramMethod method, DexItemFactory dexItemFactory) {
        return this.toCfCode(method, dexItemFactory, method.getHolder().getSuperType());
    }

    public CfCode toCfCode(ProgramMethod method, DexItemFactory dexItemFactory, DexType supertype) {
        List<CfInstruction> instructions = Arrays.asList(new CfLoad(ValueType.OBJECT, 0), new CfInvoke(183, dexItemFactory.createInstanceInitializer(supertype, new DexType[0]), false), new CfReturnVoid());
        return new CfCode(method.getHolderType(), this.getMaxStack(), this.getMaxLocals(method), instructions);
    }

    @Override
    public void writeCf(ProgramMethod method, CfVersion classFileVersion, AppView<?> appView, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, namingLens.lookupInternalName(method.getHolder().getSuperType()), "<init>", "()V", false);
        visitor.visitInsn(177);
        visitor.visitEnd();
        visitor.visitMaxs(this.getMaxStack(), this.getMaxLocals(method));
    }

    @Override
    public void writeDex(ShortBuffer shortBuffer, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils lensCodeRewriter, ObjectToOffsetMapping mapping) {
        new com.android.tools.r8.code.InvokeDirect(1, DefaultInstanceInitializerCode.getParentConstructor(context, mapping.dexItemFactory()), 0, 0, 0, 0, 0).write(shortBuffer, context, graphLens, mapping, lensCodeRewriter);
        new ReturnVoid().write(shortBuffer, context, graphLens, mapping, lensCodeRewriter);
    }

    @Override
    public void writeKeepRulesForDesugaredLibrary(CodeToKeep codeToKeep) {
    }

    @Override
    public String toString() {
        return "DefaultInstanceInitializerCode";
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return this.toString();
    }

    static class DefaultInstanceInitializerSourceCode
    extends SyntheticStraightLineSourceCode {
        DefaultInstanceInitializerSourceCode(DexMethod method) {
            this(method, null);
        }

        DefaultInstanceInitializerSourceCode(DexMethod method, Position callerPosition) {
            super(DefaultInstanceInitializerSourceCode.getInstructionBuilders(), ((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)Position.SyntheticPosition.builder().setLine(0)).setMethod(method)).setCallerPosition(callerPosition)).build());
        }

        private static List<Consumer<IRBuilder>> getInstructionBuilders() {
            return ImmutableList.of(builder -> builder.add(((InvokeDirect.Builder)((InvokeDirect.Builder)InvokeDirect.builder().setMethod(DefaultInstanceInitializerCode.getParentConstructor(builder.getProgramMethod(), builder.dexItemFactory()))).setSingleArgument(builder.getReceiverValue())).build()), IRBuilder::addReturn);
        }
    }
}

