/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.ir.desugar.CovariantReturnTypeAnnotationTransformer;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class DexAnnotation
extends DexItem
implements StructuralItem<DexAnnotation> {
    public static final DexAnnotation[] EMPTY_ARRAY = new DexAnnotation[0];
    public static final int VISIBILITY_BUILD = 0;
    public static final int VISIBILITY_RUNTIME = 1;
    public static final int VISIBILITY_SYSTEM = 2;
    public final int visibility;
    public final DexEncodedAnnotation annotation;

    private static void specify(StructuralSpecification<DexAnnotation, ?> spec) {
        ((StructuralSpecification)spec.withItem(a -> a.annotation)).withInt(a -> a.visibility);
    }

    public DexAnnotation(int visibility, DexEncodedAnnotation annotation) {
        this.visibility = visibility;
        this.annotation = annotation;
    }

    public static boolean retainCompileTimeAnnotation(DexType annotation, InternalOptions options) {
        if (options.retainCompileTimeAnnotations) {
            return true;
        }
        if (annotation == options.itemFactory.annotationSynthesizedClass || annotation.getDescriptor().startsWith(options.itemFactory.dalvikAnnotationOptimizationPrefix)) {
            return true;
        }
        if (options.processCovariantReturnTypeAnnotations) {
            return CovariantReturnTypeAnnotationTransformer.isCovariantReturnTypeAnnotation(annotation, options.itemFactory);
        }
        return false;
    }

    public static DexAnnotation createEnclosingClassAnnotation(DexType enclosingClass, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationEnclosingClass, factory, new DexValue.DexValueType(enclosingClass));
    }

    public static DexType getEnclosingClassFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        DexValue value = DexAnnotation.getSystemValueAnnotationValue(factory.annotationEnclosingClass, annotation);
        if (value == null) {
            return null;
        }
        return (DexType)value.asDexValueType().value;
    }

    public static DexAnnotation createEnclosingMethodAnnotation(DexMethod enclosingMethod, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationEnclosingMethod, factory, new DexValue.DexValueMethod(enclosingMethod));
    }

    public static DexMethod getEnclosingMethodFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        DexValue value = DexAnnotation.getSystemValueAnnotationValue(factory.annotationEnclosingMethod, annotation);
        if (value == null) {
            return null;
        }
        return (DexMethod)value.asDexValueMethod().value;
    }

    public static boolean isEnclosingClassAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationEnclosingClass;
    }

    public static boolean isEnclosingMethodAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationEnclosingMethod;
    }

    public static boolean isInnerClassAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationInnerClass;
    }

    public static boolean isMemberClassesAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationMemberClasses;
    }

    public static DexAnnotation createInnerClassAnnotation(DexString clazz, int access, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationInnerClass, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("accessFlags"), DexValue.DexValueInt.create(access)), new DexAnnotationElement(factory.createString("name"), clazz == null ? DexValue.DexValueNull.NULL : new DexValue.DexValueString(clazz))}));
    }

    public static Pair<DexString, Integer> getInnerClassFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        assert (DexAnnotation.isInnerClassAnnotation(annotation, factory));
        DexAnnotationElement[] elements = annotation.annotation.elements;
        Pair<DexString, Integer> result = new Pair<DexString, Integer>();
        for (DexAnnotationElement element : elements) {
            if (element.name == factory.createString("name")) {
                if (!element.value.isDexValueString()) continue;
                result.setFirst((DexString)element.value.asDexValueString().getValue());
                continue;
            }
            assert (element.name == factory.createString("accessFlags"));
            result.setSecond(element.value.asDexValueInt().getValue());
        }
        return result;
    }

    public static DexAnnotation createMemberClassesAnnotation(List<DexType> classes, DexItemFactory factory) {
        DexValue[] values2 = new DexValue[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            values2[i] = new DexValue.DexValueType(classes.get(i));
        }
        return DexAnnotation.createSystemValueAnnotation(factory.annotationMemberClasses, factory, new DexValue.DexValueArray(values2));
    }

    public static List<DexType> getMemberClassesFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        DexValue value = DexAnnotation.getSystemValueAnnotationValue(factory.annotationMemberClasses, annotation);
        if (value == null) {
            return null;
        }
        DexValue.DexValueArray membersArray = value.asDexValueArray();
        ArrayList<DexType> types = new ArrayList<DexType>(membersArray.getValues().length);
        for (DexValue elementValue : membersArray.getValues()) {
            types.add((DexType)elementValue.asDexValueType().value);
        }
        return types;
    }

    public static DexAnnotation createSourceDebugExtensionAnnotation(DexValue value, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationSourceDebugExtension, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    public static DexAnnotation createMethodParametersAnnotation(DexValue[] names, DexValue[] accessFlags, DexItemFactory factory) {
        assert (names.length == accessFlags.length);
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationMethodParameters, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("names"), new DexValue.DexValueArray(names)), new DexAnnotationElement(factory.createString("accessFlags"), new DexValue.DexValueArray(accessFlags))}));
    }

    public static DexAnnotation createAnnotationDefaultAnnotation(DexType type, List<DexAnnotationElement> defaults, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationDefault, factory, new DexValue.DexValueAnnotation(new DexEncodedAnnotation(type, defaults.toArray(DexAnnotationElement.EMPTY_ARRAY))));
    }

    public static DexAnnotation createSignatureAnnotation(String signature, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationSignature, factory, DexAnnotation.compressSignature(signature, factory));
    }

    public static String getSignature(DexAnnotation signatureAnnotation) {
        DexValue.DexValueArray elements = signatureAnnotation.annotation.elements[0].value.asDexValueArray();
        StringBuilder signature = new StringBuilder();
        for (DexValue element : elements.getValues()) {
            signature.append(((DexString)element.asDexValueString().value).toString());
        }
        return signature.toString();
    }

    public static String getSignature(DexAnnotationSet signatureAnnotations, DexItemFactory factory) {
        DexAnnotation signature = signatureAnnotations.getFirstMatching(factory.annotationSignature);
        return signature == null ? null : DexAnnotation.getSignature(signature);
    }

    public static DexAnnotation createThrowsAnnotation(DexValue[] exceptions, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationThrows, factory, new DexValue.DexValueArray(exceptions));
    }

    private static DexAnnotation createSystemValueAnnotation(DexType type, DexItemFactory factory, DexValue value) {
        return new DexAnnotation(2, new DexEncodedAnnotation(type, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    private static DexValue getSystemValueAnnotationValue(DexType type, DexAnnotation annotation) {
        assert (annotation.visibility == 2);
        assert (annotation.annotation.type == type);
        return annotation.annotation.elements.length == 0 ? null : annotation.annotation.elements[0].value;
    }

    public static boolean isThrowingAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationThrows;
    }

    public static boolean isSignatureAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationSignature;
    }

    public static boolean isAnnotationDefaultAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationDefault;
    }

    public static boolean isJavaLangRetentionAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.getAnnotationType() == factory.retentionType;
    }

    public static boolean isSourceDebugExtension(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationSourceDebugExtension;
    }

    public static boolean isParameterNameAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationMethodParameters;
    }

    private static DexValue compressSignature(String signature, DexItemFactory factory) {
        int length = signature.length();
        ArrayList<DexValue> parts = new ArrayList<DexValue>();
        int at = 0;
        while (at < length) {
            int endAt;
            char c = signature.charAt(at);
            if (c == 'L') {
                for (endAt = at + 1; endAt < length; ++endAt) {
                    c = signature.charAt(endAt);
                    if (c != ';' && c != '<') continue;
                    ++endAt;
                    break;
                }
            } else {
                while (endAt < length && (c = signature.charAt(endAt)) != 'L') {
                    ++endAt;
                }
            }
            parts.add(DexAnnotation.toDexValue(signature.substring(at, endAt), factory));
            at = endAt;
        }
        return new DexValue.DexValueArray(parts.toArray(DexValue.EMPTY_ARRAY));
    }

    private static DexValue toDexValue(String string, DexItemFactory factory) {
        return new DexValue.DexValueString(factory.createString(string));
    }

    public static DexAnnotation createAnnotationSynthesizedClass(SyntheticNaming.SyntheticKind kind, DexItemFactory dexItemFactory) {
        DexAnnotationElement kindElement = new DexAnnotationElement(dexItemFactory.kindString, DexValue.DexValueInt.create(kind.getId()));
        DexAnnotationElement[] elements = new DexAnnotationElement[]{kindElement};
        return new DexAnnotation(0, new DexEncodedAnnotation(dexItemFactory.annotationSynthesizedClass, elements));
    }

    public static boolean hasSynthesizedClassAnnotation(DexAnnotationSet annotations, DexItemFactory factory, SyntheticItems synthetics) {
        return DexAnnotation.getSynthesizedClassAnnotationInfo(annotations, factory, synthetics) != null;
    }

    public static SyntheticNaming.SyntheticKind getSynthesizedClassAnnotationInfo(DexAnnotationSet annotations, DexItemFactory factory, SyntheticItems synthetics) {
        if (annotations.size() != 1) {
            return null;
        }
        DexAnnotation annotation = annotations.annotations[0];
        if (annotation.annotation.type != factory.annotationSynthesizedClass) {
            return null;
        }
        int length = annotation.annotation.elements.length;
        if (length != 1) {
            return null;
        }
        assert (factory.kindString.isLessThan(factory.valueString));
        DexAnnotationElement kindElement = annotation.annotation.elements[0];
        if (kindElement.name != factory.kindString) {
            return null;
        }
        if (!kindElement.value.isDexValueInt()) {
            return null;
        }
        SyntheticNaming.SyntheticKind kind = synthetics.getNaming().fromId(kindElement.value.asDexValueInt().getValue());
        return kind;
    }

    @Override
    public DexAnnotation self() {
        return this;
    }

    @Override
    public StructuralMapping<DexAnnotation> getStructuralMapping() {
        return DexAnnotation::specify;
    }

    public DexType getAnnotationType() {
        return this.annotation.type;
    }

    @Override
    public int hashCode() {
        return this.visibility + this.annotation.hashCode() * 3;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexAnnotation) {
            DexAnnotation o = (DexAnnotation)other;
            return this.visibility == o.visibility && this.annotation.equals(o.annotation);
        }
        return false;
    }

    public String toString() {
        return this.visibility + " " + this.annotation;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.annotation.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
    }

    public DexAnnotation rewrite(Function<DexEncodedAnnotation, DexEncodedAnnotation> rewriter) {
        DexEncodedAnnotation rewritten = rewriter.apply(this.annotation);
        if (rewritten == this.annotation) {
            return this;
        }
        if (rewritten == null) {
            return null;
        }
        return new DexAnnotation(this.visibility, rewritten);
    }

    public static enum AnnotatedKind {
        FIELD,
        METHOD,
        TYPE,
        PARAMETER;


        public static AnnotatedKind from(DexDefinition definition) {
            return AnnotatedKind.from(definition.getReference());
        }

        public static AnnotatedKind from(ProgramDefinition definition) {
            return AnnotatedKind.from(definition.getReference());
        }

        public static AnnotatedKind from(DexReference reference) {
            return reference.apply(type -> TYPE, field -> FIELD, method -> METHOD);
        }

        public boolean isParameter() {
            return this == PARAMETER;
        }
    }
}

