/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.PredicateUtils;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DexAnnotationSet
extends CachedHashValueDexItem
implements StructuralItem<DexAnnotationSet> {
    public static final DexAnnotationSet[] EMPTY_ARRAY = new DexAnnotationSet[0];
    private static final int UNSORTED = 0;
    private static final DexAnnotationSet THE_EMPTY_ANNOTATIONS_SET = new DexAnnotationSet();
    public final DexAnnotation[] annotations;
    private int sorted = 0;

    private static void specify(StructuralSpecification<DexAnnotationSet, ?> spec) {
        spec.withItemArray(a -> a.annotations);
    }

    private DexAnnotationSet() {
        this.annotations = DexAnnotation.EMPTY_ARRAY;
    }

    private DexAnnotationSet(DexAnnotation[] annotations) {
        assert (!ArrayUtils.isEmpty(annotations));
        this.annotations = annotations;
    }

    public static DexAnnotationSet create(DexAnnotation[] annotations) {
        return ArrayUtils.isEmpty(annotations) ? DexAnnotationSet.empty() : new DexAnnotationSet(annotations);
    }

    public static DexType findDuplicateEntryType(DexAnnotation[] annotations) {
        return DexAnnotationSet.findDuplicateEntryType(Arrays.asList(annotations));
    }

    public static DexType findDuplicateEntryType(List<DexAnnotation> annotations) {
        Set<DexType> seenTypes = Sets.newIdentityHashSet();
        for (DexAnnotation annotation : annotations) {
            if (seenTypes.add(annotation.annotation.type)) continue;
            return annotation.annotation.type;
        }
        return null;
    }

    public static DexAnnotationSet empty() {
        return THE_EMPTY_ANNOTATIONS_SET;
    }

    private int sortedHashCode() {
        int hashCode = this.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }

    public DexAnnotation get(int index) {
        return this.annotations[index];
    }

    public DexAnnotation getFirst() {
        return this.get(0);
    }

    @Override
    public DexAnnotationSet self() {
        return this;
    }

    @Override
    public StructuralMapping<DexAnnotationSet> getStructuralMapping() {
        return DexAnnotationSet::specify;
    }

    public void forEach(Consumer<DexAnnotation> consumer) {
        for (DexAnnotation annotation : this.annotations) {
            consumer.accept(annotation);
        }
    }

    public Stream<DexAnnotation> stream() {
        return Arrays.stream(this.annotations);
    }

    public int size() {
        return this.annotations.length;
    }

    @Override
    public int computeHashCode() {
        return Arrays.hashCode(this.annotations);
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexAnnotationSet) {
            DexAnnotationSet o = (DexAnnotationSet)other;
            return Arrays.equals(this.annotations, o.annotations);
        }
        return false;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        for (DexAnnotation annotation : this.annotations) {
            annotation.collectIndexedItems(indexedItems);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
        DexAnnotationSet.collectAll((MixedSectionCollection)mixedItems, (DexItem[])this.annotations);
    }

    public boolean isEmpty() {
        return this.annotations.length == 0;
    }

    public void sort(NamingLens namingLens) {
        if (this.sorted != 0) {
            assert (this.sorted == this.sortedHashCode());
            return;
        }
        Arrays.sort(this.annotations, (a, b) -> a.annotation.type.compareToWithNamingLens(b.annotation.type, namingLens));
        for (DexAnnotation annotation : this.annotations) {
            annotation.annotation.sort();
        }
        this.sorted = this.hashCode();
    }

    public DexAnnotation getFirstMatching(DexType type) {
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type != type) continue;
            return annotation;
        }
        return null;
    }

    public DexAnnotationSet getWithout(DexType annotationType) {
        int index = 0;
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type == annotationType) {
                DexAnnotation[] reducedArray = new DexAnnotation[this.annotations.length - 1];
                System.arraycopy(this.annotations, 0, reducedArray, 0, index);
                if (index < reducedArray.length) {
                    System.arraycopy(this.annotations, index + 1, reducedArray, index, reducedArray.length - index);
                }
                return DexAnnotationSet.create(reducedArray);
            }
            ++index;
        }
        return this;
    }

    public DexAnnotationSet getWithAddedOrReplaced(DexAnnotation newAnnotation) {
        int index = 0;
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type == newAnnotation.annotation.type) {
                DexAnnotation[] modifiedArray = (DexAnnotation[])this.annotations.clone();
                modifiedArray[index] = newAnnotation;
                return DexAnnotationSet.create(modifiedArray);
            }
            ++index;
        }
        DexAnnotation[] extendedArray = new DexAnnotation[this.annotations.length + 1];
        System.arraycopy(this.annotations, 0, extendedArray, 0, this.annotations.length);
        extendedArray[this.annotations.length] = newAnnotation;
        return DexAnnotationSet.create(extendedArray);
    }

    public DexAnnotationSet keepIf(Predicate<DexAnnotation> filter) {
        return this.removeIf(PredicateUtils.not(filter));
    }

    public DexAnnotationSet removeIf(Predicate<DexAnnotation> filter) {
        return this.rewrite(annotation -> filter.test((DexAnnotation)annotation) ? null : annotation);
    }

    public DexAnnotationSet rewrite(Function<DexAnnotation, DexAnnotation> rewriter) {
        if (this.isEmpty()) {
            return this;
        }
        DexAnnotation[] rewritten = ArrayUtils.map(this.annotations, rewriter, DexAnnotation.EMPTY_ARRAY);
        return rewritten != this.annotations ? DexAnnotationSet.create(rewritten) : this;
    }

    public DexAnnotationSet methodParametersWithFakeThisArguments(DexItemFactory factory) {
        DexAnnotation[] newAnnotations = null;
        for (int i = 0; i < this.annotations.length; ++i) {
            DexAnnotation annotation = this.annotations[i];
            if (annotation.annotation.type == factory.annotationMethodParameters) {
                assert (annotation.visibility == 2);
                assert (annotation.annotation.elements.length == 2);
                assert (annotation.annotation.elements[0].name.toString().equals("names"));
                assert (annotation.annotation.elements[1].name.toString().equals("accessFlags"));
                DexValue.DexValueArray names = annotation.annotation.elements[0].value.asDexValueArray();
                DexValue.DexValueArray accessFlags = annotation.annotation.elements[1].value.asDexValueArray();
                assert (names != null && accessFlags != null);
                assert (names.getValues().length == accessFlags.getValues().length);
                if (newAnnotations == null) {
                    newAnnotations = new DexAnnotation[this.annotations.length];
                    System.arraycopy(this.annotations, 0, newAnnotations, 0, i);
                }
                DexValue[] newNames = new DexValue[names.getValues().length + 1];
                newNames[0] = new DexValue.DexValueString(factory.createString("_this"));
                System.arraycopy(names.getValues(), 0, newNames, 1, names.getValues().length);
                DexValue[] newAccessFlags = new DexValue[accessFlags.getValues().length + 1];
                newAccessFlags[0] = DexValue.DexValueInt.create(0);
                System.arraycopy(accessFlags.getValues(), 0, newAccessFlags, 1, accessFlags.getValues().length);
                newAnnotations[i] = DexAnnotation.createMethodParametersAnnotation(newNames, newAccessFlags, factory);
                continue;
            }
            if (newAnnotations == null) continue;
            newAnnotations[i] = annotation;
        }
        return newAnnotations == null ? this : DexAnnotationSet.create(newAnnotations);
    }

    public String toString() {
        return Arrays.toString(this.annotations);
    }
}

