/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.ClassDefinition;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexApplicationReadFlags;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.synthesis.SyntheticDefinitionsProvider;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class DexApplication
implements DexDefinitionSupplier {
    public final ImmutableList<DataResourceProvider> dataResourceProviders;
    private final ClassNameMapper proguardMap;
    public final Timing timing;
    public final InternalOptions options;
    public final DexItemFactory dexItemFactory;
    private final DexApplicationReadFlags flags;
    public final DexString highestSortingString;

    DexApplication(ClassNameMapper proguardMap, DexApplicationReadFlags flags, ImmutableList<DataResourceProvider> dataResourceProviders, InternalOptions options, DexString highestSortingString, Timing timing) {
        this.proguardMap = proguardMap;
        this.flags = flags;
        this.dataResourceProviders = dataResourceProviders;
        this.options = options;
        this.dexItemFactory = options.itemFactory;
        this.highestSortingString = highestSortingString;
        this.timing = timing;
    }

    public static <T extends ClassDefinition> List<T> classesWithDeterministicOrder(Collection<T> classes) {
        return DexApplication.classesWithDeterministicOrder(new ArrayList<T>(classes));
    }

    public static <T extends ClassDefinition> List<T> classesWithDeterministicOrder(List<T> classes) {
        classes.sort(Comparator.comparing(ClassDefinition::getType));
        return classes;
    }

    public static LazyLoadedDexApplication.Builder builder(InternalOptions options, Timing timing) {
        return DexApplication.builder(options, timing, ProgramClassCollection.defaultConflictResolver(options.reporter));
    }

    public static LazyLoadedDexApplication.Builder builder(InternalOptions options, Timing timing, ApplicationReader.ProgramClassConflictResolver resolver) {
        return new LazyLoadedDexApplication.Builder(resolver, options, timing);
    }

    public abstract Builder<?> builder();

    @Override
    public DexItemFactory dexItemFactory() {
        return this.dexItemFactory;
    }

    public DexDefinitionSupplier getDefinitionsSupplier(final SyntheticDefinitionsProvider syntheticDefinitionsProvider) {
        final DexApplication self = this;
        return new DexDefinitionSupplier(){

            @Override
            public ClassResolutionResult contextIndependentDefinitionForWithResolutionResult(DexType type) {
                return syntheticDefinitionsProvider.definitionFor(type, self::contextIndependentDefinitionForWithResolutionResult);
            }

            @Override
            public DexClass definitionFor(DexType type) {
                return syntheticDefinitionsProvider.definitionFor(type, self::contextIndependentDefinitionForWithResolutionResult).toSingleClassWithProgramOverLibrary();
            }

            @Override
            public DexItemFactory dexItemFactory() {
                return self.dexItemFactory;
            }
        };
    }

    abstract Collection<DexProgramClass> programClasses();

    public abstract void forEachProgramType(Consumer<DexType> var1);

    public abstract void forEachLibraryType(Consumer<DexType> var1);

    public Collection<DexProgramClass> classes() {
        ReorderBox<DexProgramClass> box = new ReorderBox<DexProgramClass>(this.programClasses());
        assert (box.reorderClasses());
        return box.getClasses();
    }

    public Collection<DexProgramClass> classesWithDeterministicOrder() {
        return DexApplication.classesWithDeterministicOrder(new ArrayList<DexProgramClass>(this.programClasses()));
    }

    public DexApplicationReadFlags getFlags() {
        return this.flags;
    }

    @Override
    public abstract DexClass definitionFor(DexType var1);

    public abstract DexProgramClass programDefinitionFor(DexType var1);

    public abstract String toString();

    public ClassNameMapper getProguardMap() {
        return this.proguardMap;
    }

    public DirectMappedDexApplication asDirect() {
        throw new Unreachable("Cannot use a LazyDexApplication where a DirectDexApplication is expected.");
    }

    public abstract DirectMappedDexApplication toDirect();

    public abstract boolean isDirect();

    public static abstract class Builder<T extends Builder<T>> {
        private final List<DexProgramClass> programClasses = new ArrayList<DexProgramClass>();
        final List<DataResourceProvider> dataResourceProviders = new ArrayList<DataResourceProvider>();
        public final InternalOptions options;
        public final DexItemFactory dexItemFactory;
        ClassNameMapper proguardMap;
        final Timing timing;
        DexApplicationReadFlags flags;
        DexString highestSortingString;
        private final Collection<DexProgramClass> synthesizedClasses;

        public Builder(InternalOptions options, Timing timing) {
            this.options = options;
            this.dexItemFactory = options.itemFactory;
            this.timing = timing;
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        public Builder(DexApplication application) {
            this.flags = application.flags;
            this.programClasses.addAll(application.programClasses());
            this.dataResourceProviders.addAll(application.dataResourceProviders);
            this.proguardMap = application.getProguardMap();
            this.timing = application.timing;
            this.highestSortingString = application.highestSortingString;
            this.options = application.options;
            this.dexItemFactory = application.dexItemFactory;
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        abstract T self();

        public boolean isDirect() {
            return false;
        }

        public DirectMappedDexApplication.Builder asDirect() {
            return null;
        }

        public void setFlags(DexApplicationReadFlags flags) {
            this.flags = flags;
        }

        public synchronized T setProguardMap(ClassNameMapper proguardMap) {
            assert (this.proguardMap == null);
            this.proguardMap = proguardMap;
            return this.self();
        }

        public synchronized T removeProgramClasses(Predicate<DexProgramClass> predicate) {
            this.programClasses.removeIf(predicate);
            return this.self();
        }

        public synchronized T replaceProgramClasses(Collection<DexProgramClass> newProgramClasses) {
            assert (newProgramClasses != null);
            this.programClasses.clear();
            this.programClasses.addAll(newProgramClasses);
            return this.self();
        }

        public synchronized T addDataResourceProvider(DataResourceProvider provider) {
            this.dataResourceProviders.add(provider);
            return this.self();
        }

        public synchronized T setHighestSortingString(DexString value) {
            this.highestSortingString = value;
            return this.self();
        }

        public synchronized T addProgramClass(DexProgramClass clazz) {
            this.programClasses.add(clazz);
            return this.self();
        }

        public abstract void addProgramClassPotentiallyOverridingNonProgramClass(DexProgramClass var1);

        public synchronized T addProgramClasses(Collection<DexProgramClass> classes) {
            this.programClasses.addAll(classes);
            return this.self();
        }

        public synchronized T addSynthesizedClass(DexProgramClass synthesizedClass) {
            assert (synthesizedClass.isProgramClass()) : "All synthesized classes must be program classes";
            this.addProgramClass(synthesizedClass);
            this.synthesizedClasses.add(synthesizedClass);
            return this.self();
        }

        public List<DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public Collection<DexProgramClass> getSynthesizedClasses() {
            return this.synthesizedClasses;
        }

        public abstract DexApplication build();
    }

    private static class ReorderBox<T> {
        private Collection<T> classes;

        ReorderBox(Collection<T> classes) {
            this.classes = classes;
        }

        boolean reorderClasses() {
            ArrayList<T> shuffled2 = new ArrayList<T>(this.classes);
            Collections.shuffle(shuffled2);
            this.classes = ImmutableList.copyOf(shuffled2);
            return true;
        }

        Collection<T> getClasses() {
            return this.classes;
        }
    }
}

