/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.ClasspathField;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.LibraryField;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import com.android.tools.r8.references.FieldReference;

public abstract class DexClassAndField
extends DexClassAndMember<DexEncodedField, DexField> {
    DexClassAndField(DexClass holder, DexEncodedField field) {
        super(holder, field);
        assert (holder.isClasspathClass() == this instanceof ClasspathField);
        assert (holder.isLibraryClass() == this instanceof LibraryField);
        assert (holder.isProgramClass() == this instanceof ProgramField);
    }

    public static DexClassAndField create(DexClass holder, DexEncodedField field) {
        if (holder.isProgramClass()) {
            return new ProgramField(holder.asProgramClass(), field);
        }
        if (holder.isLibraryClass()) {
            return new LibraryField(holder.asLibraryClass(), field);
        }
        assert (holder.isClasspathClass());
        return new ClasspathField(holder.asClasspathClass(), field);
    }

    public FieldAccessFlags getAccessFlags() {
        return ((DexEncodedField)this.getDefinition()).getAccessFlags();
    }

    public FieldReference getFieldReference() {
        return ((DexField)this.getReference()).asFieldReference();
    }

    public FieldOptimizationInfo getOptimizationInfo() {
        return ((DexEncodedField)this.getDefinition()).getOptimizationInfo();
    }

    public DexType getType() {
        return ((DexField)this.getReference()).getType();
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public DexClassAndField asField() {
        return this;
    }

    public DexClassAndField asMember() {
        return this;
    }
}

