/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.LibraryMethod;
import com.android.tools.r8.graph.LookupLambdaTarget;
import com.android.tools.r8.graph.LookupTarget;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.references.MethodReference;
import java.util.function.Consumer;

public abstract class DexClassAndMethod
extends DexClassAndMember<DexEncodedMethod, DexMethod>
implements LookupTarget {
    DexClassAndMethod(DexClass holder, DexEncodedMethod method) {
        super(holder, method);
        assert (holder.isClasspathClass() == this instanceof ClasspathMethod);
        assert (holder.isLibraryClass() == this instanceof LibraryMethod);
        assert (holder.isProgramClass() == this instanceof ProgramMethod);
    }

    public static ProgramMethod asProgramMethodOrNull(DexClassAndMethod method) {
        return method != null ? method.asProgramMethod() : null;
    }

    public static DexClassAndMethod create(DexClass holder, DexEncodedMethod method) {
        if (holder.isProgramClass()) {
            return new ProgramMethod(holder.asProgramClass(), method);
        }
        if (holder.isLibraryClass()) {
            return new LibraryMethod(holder.asLibraryClass(), method);
        }
        assert (holder.isClasspathClass());
        return new ClasspathMethod(holder.asClasspathClass(), method);
    }

    public boolean isDefaultMethod() {
        return this.getHolder().isInterface() && ((DexEncodedMethod)this.getDefinition()).isDefaultMethod();
    }

    public boolean isStructurallyEqualTo(DexClassAndMethod other) {
        return this.getDefinition() == other.getDefinition() && this.getHolder() == other.getHolder();
    }

    public MethodAccessFlags getAccessFlags() {
        return ((DexEncodedMethod)this.getDefinition()).getAccessFlags();
    }

    public MethodReference getMethodReference() {
        return ((DexMethod)this.getReference()).asMethodReference();
    }

    public DexMethodSignature getMethodSignature() {
        return ((DexMethod)this.getReference()).getSignature();
    }

    public MethodOptimizationInfo getOptimizationInfo() {
        return ((DexEncodedMethod)this.getDefinition()).getOptimizationInfo();
    }

    public DexType getArgumentType(int index) {
        return ((DexEncodedMethod)this.getDefinition()).getArgumentType(index);
    }

    public DexType getParameter(int index) {
        return ((DexMethod)this.getReference()).getParameter(index);
    }

    public DexTypeList getParameters() {
        return ((DexMethod)this.getReference()).getParameters();
    }

    public DexAnnotationSet getParameterAnnotation(int index) {
        return this.getParameterAnnotations().get(index);
    }

    public final ParameterAnnotationsList getParameterAnnotations() {
        return ((DexEncodedMethod)this.getDefinition()).getParameterAnnotations();
    }

    public DexProto getProto() {
        return ((DexMethod)this.getReference()).getProto();
    }

    public DexType getReturnType() {
        return ((DexMethod)this.getReference()).getReturnType();
    }

    @Override
    public boolean isMethodTarget() {
        return true;
    }

    @Override
    public DexClassAndMethod asMethodTarget() {
        return this;
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    public DexClassAndMethod asMember() {
        return this;
    }

    @Override
    public DexClassAndMethod asMethod() {
        return this;
    }

    @Override
    public void accept(Consumer<DexClassAndMethod> methodConsumer, Consumer<LookupLambdaTarget> lambdaConsumer) {
        methodConsumer.accept(this);
    }
}

