/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.code.SwitchPayload;
import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.dex.CodeToKeep;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.JumboStringRewriter;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugEntryBuilder;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexDebugInfoForWriting;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexWritableCode;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeInstructionMetadata;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeMetadata;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.DexSourceCode;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.structural.Equatable;
import com.android.tools.r8.utils.structural.HashCodeVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DexCode
extends Code
implements DexWritableCode,
StructuralItem<DexCode> {
    public static final String FAKE_THIS_PREFIX = "_";
    public static final String FAKE_THIS_SUFFIX = "this";
    public final int registerSize;
    public final int incomingRegisterSize;
    public final int outgoingRegisterSize;
    public final Try[] tries;
    public final TryHandler[] handlers;
    public final Instruction[] instructions;
    public DexString highestSortingString;
    private DexDebugInfo debugInfo;
    private DexDebugInfoForWriting debugInfoForWriting;
    private final BytecodeMetadata<Instruction> metadata;

    private static void specify(StructuralSpecification<DexCode, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withInt(c -> c.registerSize)).withInt(c -> c.incomingRegisterSize)).withInt(c -> c.outgoingRegisterSize)).withItemArray(c -> c.tries)).withItemArray(c -> c.handlers)).withNullableItem(c -> c.debugInfo)).withItemArray(c -> c.instructions);
    }

    public DexCode(int registerSize, int insSize, int outsSize, Instruction[] instructions, Try[] tries, TryHandler[] handlers, DexDebugInfo debugInfo) {
        this(registerSize, insSize, outsSize, instructions, tries, handlers, debugInfo, BytecodeMetadata.empty());
    }

    public DexCode(int registerSize, int insSize, int outsSize, Instruction[] instructions, Try[] tries, TryHandler[] handlers, DexDebugInfo debugInfo, BytecodeMetadata<Instruction> metadata) {
        this.incomingRegisterSize = insSize;
        this.registerSize = registerSize;
        this.outgoingRegisterSize = outsSize;
        this.instructions = instructions;
        this.tries = tries;
        this.handlers = handlers;
        this.debugInfo = debugInfo;
        this.metadata = metadata;
        assert (tries != null);
        assert (handlers != null);
        assert (instructions != null);
        this.hashCode();
    }

    private DexDebugInfo debugInfoAsInlining(DexMethod caller, DexMethod callee, DexItemFactory factory) {
        Position.SyntheticPosition callerPosition = ((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)Position.SyntheticPosition.builder().setLine(0)).setMethod(caller)).build();
        DexDebugInfo.EventBasedDebugInfo eventBasedInfo = DexDebugInfo.convertToEventBased(this, factory);
        if (eventBasedInfo == null) {
            return new DexDebugInfo.EventBasedDebugInfo(0, new DexString[callee.getArity()], new DexDebugEvent[]{new DexDebugEvent.SetInlineFrame(callee, callerPosition), factory.zeroChangeDefaultEvent});
        }
        DexDebugEvent[] oldEvents = eventBasedInfo.events;
        DexDebugEvent[] newEvents = new DexDebugEvent[oldEvents.length + 1];
        int i = 0;
        newEvents[i++] = new DexDebugEvent.SetInlineFrame(callee, callerPosition);
        for (DexDebugEvent event : oldEvents) {
            if (event instanceof DexDebugEvent.SetInlineFrame) {
                DexDebugEvent.SetInlineFrame oldFrame = (DexDebugEvent.SetInlineFrame)event;
                newEvents[i++] = new DexDebugEvent.SetInlineFrame(oldFrame.callee, oldFrame.caller == null ? callerPosition : oldFrame.caller.withOutermostCallerPosition(callerPosition));
                continue;
            }
            newEvents[i++] = event;
        }
        return new DexDebugInfo.EventBasedDebugInfo(eventBasedInfo.startLine, eventBasedInfo.parameters, newEvents);
    }

    public static int getLargestPrefix(DexItemFactory factory, DexString name) {
        if (name != null && name.endsWith(factory.thisName)) {
            String string = name.toString();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '_') continue;
                return i;
            }
        }
        return 0;
    }

    private void internalRegisterCodeReferences(DexClassAndMethod method, UseRegistry registry) {
        assert (registry.getTraversalContinuation().shouldContinue());
        for (Instruction instruction : this.instructions) {
            instruction.registerUse(registry);
            if (!registry.getTraversalContinuation().shouldBreak()) continue;
            return;
        }
        for (StructuralItem<Instruction> structuralItem : this.handlers) {
            for (TryHandler.TypeAddrPair pair : ((TryHandler)structuralItem).pairs) {
                registry.registerExceptionGuard(pair.type);
                if (!registry.getTraversalContinuation().shouldBreak()) continue;
                return;
            }
        }
    }

    private void updateHighestSortingString(DexString candidate) {
        assert (candidate != null);
        if (this.highestSortingString == null || this.highestSortingString.compareTo(candidate) < 0) {
            this.highestSortingString = candidate;
        }
    }

    private int computeCodeSizeInBytes() {
        int size = 0;
        for (Instruction insn : this.instructions) {
            size += insn.getSize();
        }
        return size;
    }

    @Override
    public DexCode self() {
        return this;
    }

    public BytecodeMetadata<Instruction> getMetadata() {
        return this.metadata;
    }

    @Override
    public BytecodeInstructionMetadata getMetadata(CfOrDexInstruction instruction) {
        return this.getMetadata(instruction.asDexInstruction());
    }

    public BytecodeInstructionMetadata getMetadata(Instruction instruction) {
        return this.metadata.getMetadata(instruction);
    }

    @Override
    public DexWritableCode.DexWritableCodeKind getDexWritableCodeKind() {
        return DexWritableCode.DexWritableCodeKind.DEFAULT;
    }

    @Override
    public StructuralMapping<DexCode> getStructuralMapping() {
        return DexCode::specify;
    }

    @Override
    public DexWritableCode rewriteCodeWithJumboStrings(ProgramMethod method, ObjectToOffsetMapping mapping, DexItemFactory factory, boolean force) {
        DexString firstJumboString = null;
        if (force) {
            firstJumboString = mapping.getFirstString();
        } else {
            assert (this.highestSortingString != null || Arrays.stream(this.instructions).noneMatch(Instruction::isConstString));
            assert (Arrays.stream(this.instructions).noneMatch(Instruction::isDexItemBasedConstString));
            if (this.highestSortingString != null && this.highestSortingString.isGreaterThanOrEqualTo(mapping.getFirstJumboString())) {
                firstJumboString = mapping.getFirstJumboString();
            }
        }
        return firstJumboString != null ? new JumboStringRewriter((DexEncodedMethod)method.getDefinition(), firstJumboString, factory).rewrite() : this;
    }

    @Override
    public void setCallSiteContexts(ProgramMethod method) {
        for (Instruction instruction : this.instructions) {
            DexCallSite callSite = instruction.getCallSite();
            if (callSite == null) continue;
            callSite.setContext((DexMethod)method.getReference(), instruction.getOffset());
        }
    }

    public DexCode withoutThisParameter(DexItemFactory factory) {
        return new DexCode(this.registerSize, this.incomingRegisterSize - 1, this.outgoingRegisterSize, this.instructions, this.tries, this.handlers, this.debugInfoWithoutFirstParameter(factory));
    }

    @Override
    public boolean isDexCode() {
        return true;
    }

    @Override
    public boolean isDexWritableCode() {
        return true;
    }

    @Override
    public DexWritableCode asDexWritableCode() {
        return this;
    }

    @Override
    public int estimatedSizeForInlining() {
        return this.codeSizeInBytes();
    }

    @Override
    public int estimatedDexCodeSizeUpperBoundInBytes() {
        return this.codeSizeInBytes();
    }

    @Override
    public DexCode asDexCode() {
        return this;
    }

    public DexDebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(DexDebugInfo debugInfo) {
        this.debugInfo = debugInfo;
        if (this.debugInfoForWriting != null) {
            this.debugInfoForWriting = null;
        }
    }

    public DexDebugInfo debugInfoWithFakeThisParameter(DexItemFactory factory) {
        DexDebugInfo.EventBasedDebugInfo eventBasedInfo = DexDebugInfo.convertToEventBased(this, factory);
        if (eventBasedInfo == null) {
            return eventBasedInfo;
        }
        int largestPrefix = 0;
        for (DexString dexString : eventBasedInfo.parameters) {
            largestPrefix = Integer.max(largestPrefix, DexCode.getLargestPrefix(factory, dexString));
        }
        for (DexItem dexItem : eventBasedInfo.events) {
            if (!(dexItem instanceof DexDebugEvent.StartLocal)) continue;
            DexString name = ((DexDebugEvent.StartLocal)dexItem).name;
            largestPrefix = Integer.max(largestPrefix, DexCode.getLargestPrefix(factory, name));
        }
        String fakeThisName = Strings.repeat(FAKE_THIS_PREFIX, largestPrefix + 1) + FAKE_THIS_SUFFIX;
        DexString[] parameters = eventBasedInfo.parameters;
        DexString[] newParameters = new DexString[parameters.length + 1];
        newParameters[0] = factory.createString(fakeThisName);
        System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
        return new DexDebugInfo.EventBasedDebugInfo(eventBasedInfo.startLine, newParameters, eventBasedInfo.events);
    }

    @Override
    public Code getCodeAsInlining(DexMethod caller, DexMethod callee, DexItemFactory factory) {
        return new DexCode(this.registerSize, this.incomingRegisterSize, this.outgoingRegisterSize, this.instructions, this.tries, this.handlers, this.debugInfoAsInlining(caller, callee, factory));
    }

    public DexDebugInfo debugInfoWithoutFirstParameter(DexItemFactory factory) {
        DexDebugInfo.EventBasedDebugInfo eventBasedInfo = DexDebugInfo.convertToEventBased(this, factory);
        if (eventBasedInfo == null) {
            return eventBasedInfo;
        }
        DexString[] parameters = eventBasedInfo.parameters;
        if (parameters.length == 0) {
            return eventBasedInfo;
        }
        DexString[] newParameters = new DexString[parameters.length - 1];
        System.arraycopy(parameters, 1, newParameters, 0, parameters.length - 1);
        return new DexDebugInfo.EventBasedDebugInfo(eventBasedInfo.startLine, newParameters, eventBasedInfo.events);
    }

    @Override
    public void acceptHashing(HashingVisitor visitor) {
        visitor.visit(this, this.getStructuralMapping());
    }

    @Override
    public int computeHashCode() {
        return this.incomingRegisterSize * 2 + this.registerSize * 3 + this.outgoingRegisterSize * 5 + Arrays.hashCode(this.instructions) * 7 + (this.debugInfo == null ? 0 : this.debugInfo.hashCode()) * 11 + Arrays.hashCode(this.tries) * 13 + Arrays.hashCode(this.handlers) * 17;
    }

    @Override
    public boolean computeEquals(Object other) {
        return Equatable.equalsImpl(this, other);
    }

    @Override
    public boolean isEmptyVoidMethod() {
        return this.instructions.length == 1 && this.instructions[0] instanceof ReturnVoid;
    }

    @Override
    public Code asCode() {
        return this;
    }

    @Override
    public IRCode buildIR(ProgramMethod method, AppView<?> appView, Origin origin, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
        DexSourceCode source = new DexSourceCode(this, method, appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference()), null, appView.dexItemFactory());
        return IRBuilder.create(method, appView, source, origin).build(method, conversionOptions);
    }

    @Override
    public IRCode buildInliningIR(ProgramMethod context, ProgramMethod method, AppView<?> appView, GraphLens codeLens, NumberGenerator valueNumberGenerator, Position callerPosition, Origin origin, RewrittenPrototypeDescription protoChanges) {
        DexSourceCode source = new DexSourceCode(this, method, appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference()), callerPosition, appView.dexItemFactory());
        return IRBuilder.createForInlining(method, appView, codeLens, source, origin, valueNumberGenerator, protoChanges).build(context, new MethodConversionOptions.ThrowingMethodConversionOptions(appView.options()));
    }

    @Override
    public void registerCodeReferences(ProgramMethod method, UseRegistry registry) {
        this.internalRegisterCodeReferences(method, registry);
    }

    @Override
    public void registerCodeReferencesForDesugaring(ClasspathMethod method, UseRegistry registry) {
        this.internalRegisterCodeReferences(method, registry);
    }

    @Override
    public String toString() {
        return this.toString(null, null);
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        boolean isPcBasedInfo;
        StringBuilder builder = new StringBuilder();
        if (method != null) {
            builder.append(method.toSourceString()).append("\n");
        }
        builder.append("registers: ").append(this.registerSize);
        builder.append(", inputs: ").append(this.incomingRegisterSize);
        builder.append(", outputs: ").append(this.outgoingRegisterSize).append("\n");
        builder.append("------------------------------------------------------------\n");
        builder.append("inst#  offset  instruction         arguments\n");
        builder.append("------------------------------------------------------------\n");
        HashMap<Integer, Instruction> payloadUsers = new HashMap<Integer, Instruction>();
        for (Instruction dex : this.instructions) {
            if (!dex.hasPayload()) continue;
            payloadUsers.put(dex.getOffset() + dex.getPayloadOffset(), dex);
        }
        DexDebugEntry debugInfo = null;
        Iterator<Object> debugInfoIterator = Collections.emptyIterator();
        boolean bl = isPcBasedInfo = this.getDebugInfo() != null && this.getDebugInfo().isPcBasedInfo();
        if (!isPcBasedInfo && this.getDebugInfo() != null && method != null) {
            debugInfoIterator = new DexDebugEntryBuilder(method, new DexItemFactory()).build().iterator();
            debugInfo = debugInfoIterator.hasNext() ? (DexDebugEntry)debugInfoIterator.next() : null;
        }
        int instructionNumber = 0;
        Map<Object, Object> locals = Collections.emptyMap();
        for (Instruction insn : this.instructions) {
            debugInfo = this.advanceToOffset(insn.getOffset() - 1, debugInfo, debugInfoIterator);
            while (debugInfo != null && debugInfo.address == insn.getOffset()) {
                if (debugInfo.lineEntry || !locals.equals(debugInfo.locals)) {
                    builder.append("         ").append(debugInfo.toString(false)).append("\n");
                }
                locals = debugInfo.locals;
                debugInfo = debugInfoIterator.hasNext() ? (DexDebugEntry)debugInfoIterator.next() : null;
            }
            StringUtils.appendLeftPadded(builder, Integer.toString(instructionNumber++), 5);
            builder.append(": ");
            if (insn.isSwitchPayload()) {
                Instruction payloadUser = (Instruction)payloadUsers.get(insn.getOffset());
                builder.append(insn.toString(naming, payloadUser));
            } else {
                builder.append(insn.toString(naming));
            }
            builder.append('\n');
        }
        if (isPcBasedInfo) {
            builder.append(this.getDebugInfo()).append("\n");
        } else if (debugInfoIterator.hasNext()) {
            Try[] lastInstruction = ArrayUtils.last(this.instructions);
            debugInfo = this.advanceToOffset(lastInstruction.getOffset(), debugInfo, debugInfoIterator);
            if (debugInfo != null) {
                throw new Unreachable("Could not print all debug information.");
            }
            builder.append("(has debug events past last pc)\n");
        }
        if (this.tries.length > 0) {
            builder.append("Tries (numbers are offsets)\n");
            for (Try atry : this.tries) {
                builder.append("  ");
                builder.append(atry.toString());
                builder.append('\n');
            }
            builder.append("Handlers (numbers are offsets)\n");
            for (int handlerIndex = 0; handlerIndex < this.handlers.length; ++handlerIndex) {
                TryHandler handler = this.handlers[handlerIndex];
                builder.append("  ").append(handlerIndex).append(": ");
                builder.append(handler.toString());
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    DexDebugEntry advanceToOffset(int offset, DexDebugEntry current, Iterator<DexDebugEntry> iterator2) {
        while (current != null && current.address <= offset) {
            current = iterator2.hasNext() ? iterator2.next() : null;
        }
        return current;
    }

    public String toSmaliString(ClassNameMapper naming) {
        Instruction payloadUser;
        StringBuilder builder = new StringBuilder();
        HashMap<Integer, Instruction> payloadUsers = new HashMap<Integer, Instruction>();
        HashSet<Integer> labledTargets = new HashSet<Integer>();
        for (Instruction instruction : this.instructions) {
            int[] targets = instruction.getTargets();
            if (targets != Instruction.NO_TARGETS && targets != Instruction.EXIT_TARGET) {
                assert (targets.length <= 2);
                labledTargets.add(instruction.getOffset() + targets[0]);
                continue;
            }
            if (!instruction.hasPayload()) continue;
            labledTargets.add(instruction.getOffset() + instruction.getPayloadOffset());
            payloadUsers.put(instruction.getOffset() + instruction.getPayloadOffset(), instruction);
        }
        for (Instruction instruction : this.instructions) {
            if (!instruction.isSwitchPayload()) continue;
            payloadUser = (Instruction)payloadUsers.get(instruction.getOffset());
            if (!(instruction instanceof SwitchPayload)) continue;
            SwitchPayload payload = (SwitchPayload)instruction;
            for (int target : payload.switchTargetOffsets()) {
                labledTargets.add(payloadUser.getOffset() + target);
            }
        }
        for (Instruction instruction : this.instructions) {
            if (labledTargets.contains(instruction.getOffset())) {
                builder.append("  :label_");
                builder.append(instruction.getOffset());
                builder.append("\n");
            }
            if (instruction.isSwitchPayload()) {
                payloadUser = (Instruction)payloadUsers.get(instruction.getOffset());
                builder.append(instruction.toSmaliString(payloadUser)).append('\n');
                continue;
            }
            builder.append(instruction.toSmaliString(naming)).append('\n');
        }
        if (this.tries.length > 0) {
            builder.append("Tries (numbers are offsets)\n");
            for (StructuralItem<Instruction> structuralItem : this.tries) {
                builder.append("  ");
                builder.append(((Try)structuralItem).toString());
                builder.append('\n');
            }
            builder.append("Handlers (numbers are offsets)\n");
            for (StructuralItem<Instruction> structuralItem : this.handlers) {
                builder.append(((TryHandler)structuralItem).toString());
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils rewriter) {
        this.highestSortingString = null;
        for (Instruction instruction : this.instructions) {
            assert (!instruction.isDexItemBasedConstString());
            instruction.collectIndexedItems(indexedItems, context, graphLens, rewriter);
            if (instruction.isConstString()) {
                this.updateHighestSortingString(instruction.asConstString().getString());
                continue;
            }
            if (!instruction.isConstStringJumbo()) continue;
            this.updateHighestSortingString(instruction.asConstStringJumbo().getString());
        }
        if (this.debugInfo != null) {
            this.getDebugInfoForWriting().collectIndexedItems(indexedItems, graphLens);
        }
        for (StructuralItem<Instruction> structuralItem : this.handlers) {
            ((TryHandler)structuralItem).collectIndexedItems(indexedItems, graphLens);
        }
    }

    @Override
    public DexDebugInfoForWriting getDebugInfoForWriting() {
        if (this.debugInfoForWriting == null) {
            this.debugInfoForWriting = DexDebugInfo.convertToWritable(this.debugInfo);
        }
        return this.debugInfoForWriting;
    }

    @Override
    public TryHandler[] getHandlers() {
        return this.handlers;
    }

    @Override
    public DexString getHighestSortingString() {
        return this.highestSortingString;
    }

    @Override
    public Try[] getTries() {
        return this.tries;
    }

    @Override
    public int getRegisterSize(ProgramMethod method) {
        return this.registerSize;
    }

    @Override
    public int getIncomingRegisterSize(ProgramMethod method) {
        return this.incomingRegisterSize;
    }

    @Override
    public int getOutgoingRegisterSize() {
        return this.outgoingRegisterSize;
    }

    @Override
    public void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        if (this.debugInfo != null) {
            this.getDebugInfoForWriting().collectMixedSectionItems(mixedItems);
        }
    }

    @Override
    public int codeSizeInBytes() {
        Instruction last = this.instructions[this.instructions.length - 1];
        assert (last.hasOffset());
        int result = last.getOffset() + last.getSize();
        assert (result == this.computeCodeSizeInBytes());
        return result;
    }

    @Override
    public void writeKeepRulesForDesugaredLibrary(CodeToKeep desugaredLibraryCodeToKeep) {
        for (Instruction instruction : this.instructions) {
            DexMethod method = instruction.getMethod();
            DexField field = instruction.getField();
            if (field != null) {
                assert (method == null);
                desugaredLibraryCodeToKeep.recordField(field);
                continue;
            }
            if (method != null) {
                desugaredLibraryCodeToKeep.recordMethod(method);
                continue;
            }
            if (instruction.isConstClass()) {
                desugaredLibraryCodeToKeep.recordClass(instruction.asConstClass().getType());
                continue;
            }
            if (instruction.isInstanceOf()) {
                desugaredLibraryCodeToKeep.recordClass(instruction.asInstanceOf().getType());
                continue;
            }
            if (!instruction.isCheckCast()) continue;
            desugaredLibraryCodeToKeep.recordClass(instruction.asCheckCast().getType());
        }
    }

    @Override
    public void writeDex(ShortBuffer shortBuffer, ProgramMethod context, GraphLens graphLens, LensCodeRewriterUtils lensCodeRewriter, ObjectToOffsetMapping mapping) {
        for (Instruction instruction : this.instructions) {
            instruction.write(shortBuffer, context, graphLens, mapping, lensCodeRewriter);
        }
    }

    public static class TryHandler
    extends DexItem
    implements StructuralItem<TryHandler> {
        public static final int NO_HANDLER = -1;
        public final TypeAddrPair[] pairs;
        public final int catchAllAddr;

        private static void specify(StructuralSpecification<TryHandler, ?> spec) {
            ((StructuralSpecification)spec.withInt(h2 -> h2.catchAllAddr)).withItemArray(h2 -> h2.pairs);
        }

        public TryHandler(TypeAddrPair[] pairs, int catchAllAddr) {
            this.pairs = pairs;
            this.catchAllAddr = catchAllAddr;
        }

        @Override
        public TryHandler self() {
            return this;
        }

        @Override
        public StructuralMapping<TryHandler> getStructuralMapping() {
            return TryHandler::specify;
        }

        @Override
        public int hashCode() {
            return HashCodeVisitor.run(this);
        }

        @Override
        public boolean equals(Object other) {
            return Equatable.equalsImpl(this, other);
        }

        public void collectIndexedItems(IndexedItemCollection indexedItems, GraphLens graphLens) {
            for (TypeAddrPair pair : this.pairs) {
                pair.collectIndexedItems(indexedItems, graphLens);
            }
        }

        @Override
        void collectMixedSectionItems(MixedSectionCollection mixedItems) {
            assert (false);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[\n");
            for (TypeAddrPair pair : this.pairs) {
                builder.append("       ");
                builder.append(pair.type);
                builder.append(" -> ");
                builder.append(StringUtils.hexString(pair.addr, 2));
                builder.append("\n");
            }
            if (this.catchAllAddr != -1) {
                builder.append("       default -> ");
                builder.append(StringUtils.hexString(this.catchAllAddr, 2));
                builder.append("\n");
            }
            builder.append("     ]");
            return builder.toString();
        }

        public static class TypeAddrPair
        extends DexItem
        implements StructuralItem<TypeAddrPair> {
            private final DexType type;
            public final int addr;

            private static void specify(StructuralSpecification<TypeAddrPair, ?> spec) {
                ((StructuralSpecification)spec.withItem(p -> p.type)).withInt(p -> p.addr);
            }

            public TypeAddrPair(DexType type, int addr) {
                this.type = type;
                this.addr = addr;
            }

            @Override
            public TypeAddrPair self() {
                return this;
            }

            @Override
            public StructuralMapping<TypeAddrPair> getStructuralMapping() {
                return TypeAddrPair::specify;
            }

            public DexType getType() {
                return this.type;
            }

            public DexType getType(GraphLens lens) {
                return lens.lookupType(this.type);
            }

            public void collectIndexedItems(IndexedItemCollection indexedItems, GraphLens graphLens) {
                DexType rewritten = this.getType(graphLens);
                rewritten.collectIndexedItems(indexedItems);
            }

            @Override
            void collectMixedSectionItems(MixedSectionCollection mixedItems) {
                assert (false);
            }

            @Override
            public int hashCode() {
                return this.type.hashCode() * 7 + this.addr;
            }

            @Override
            public boolean equals(Object other) {
                return Equatable.equalsImpl(this, other);
            }
        }
    }

    public static class Try
    extends DexItem
    implements StructuralItem<Try> {
        public static final int NO_INDEX = -1;
        public final int handlerOffset;
        public int startAddress;
        public int instructionCount;
        public int handlerIndex;

        private static void specify(StructuralSpecification<Try, ?> spec) {
            ((StructuralSpecification)((StructuralSpecification)spec.withInt(t -> t.startAddress)).withInt(t -> t.instructionCount)).withInt(t -> t.handlerIndex);
        }

        public Try(int startAddress, int instructionCount, int handlerOffset) {
            this.startAddress = startAddress;
            this.instructionCount = instructionCount;
            this.handlerOffset = handlerOffset;
            this.handlerIndex = -1;
        }

        @Override
        public Try self() {
            return this;
        }

        @Override
        public StructuralMapping<Try> getStructuralMapping() {
            return Try::specify;
        }

        public void setHandlerIndex(Int2IntMap map) {
            this.handlerIndex = map.get(this.handlerOffset);
        }

        @Override
        public int hashCode() {
            return this.startAddress * 2 + this.instructionCount * 3 + this.handlerIndex * 5;
        }

        @Override
        public boolean equals(Object other) {
            return Equatable.equalsImpl(this, other);
        }

        public String toString() {
            return "[" + StringUtils.hexString(this.startAddress, 2) + " .. " + StringUtils.hexString(this.startAddress + this.instructionCount - 1, 2) + "] -> " + this.handlerIndex;
        }

        @Override
        void collectMixedSectionItems(MixedSectionCollection mixedItems) {
            assert (false);
        }
    }
}

