/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.DebugBytecodeWriter;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEntry;
import com.android.tools.r8.graph.DexDebugEntryBuilder;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugEventBuilder;
import com.android.tools.r8.graph.DexDebugInfoForWriting;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.LebUtils;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.Equatable;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class DexDebugInfo
extends CachedHashValueDexItem
implements StructuralItem<DexDebugInfo> {
    public static EventBasedDebugInfo convertToEventBased(DexCode code, DexItemFactory factory) {
        if (code.getDebugInfo() == null) {
            return null;
        }
        if (code.getDebugInfo().isEventBasedInfo()) {
            return code.getDebugInfo().asEventBasedInfo();
        }
        assert (code.getDebugInfo().isPcBasedInfo());
        PcBasedDebugInfo pcBasedDebugInfo = code.getDebugInfo().asPcBasedInfo();
        ArrayList<DexDebugEvent> events = new ArrayList<DexDebugEvent>(code.instructions.length);
        int pc = 0;
        int delta = 0;
        for (Instruction instruction : code.instructions) {
            if (instruction.canThrow()) {
                DexDebugEventBuilder.addDefaultEventWithAdvancePcIfNecessary(delta, delta, events, factory);
                pc += delta;
                delta = 0;
            }
            delta += instruction.getSize();
        }
        assert (pc + delta - ArrayUtils.last(code.instructions).getSize() <= pcBasedDebugInfo.maxPc);
        return new EventBasedDebugInfo(0, new DexString[pcBasedDebugInfo.getParameterCount()], events.toArray(DexDebugEvent.EMPTY_ARRAY));
    }

    public static DexDebugInfoForWriting convertToWritable(DexDebugInfo debugInfo) {
        if (debugInfo == null) {
            return null;
        }
        if (debugInfo.isPcBasedInfo()) {
            return debugInfo.asPcBasedInfo();
        }
        EventBasedDebugInfo eventBasedInfo = debugInfo.asEventBasedInfo();
        DexDebugEvent[] writableEvents = ArrayUtils.filter(eventBasedInfo.events, DexDebugEvent::isWritableEvent, DexDebugEvent.EMPTY_ARRAY);
        return new WritableEventBasedDebugInfo(eventBasedInfo.startLine, eventBasedInfo.parameters, writableEvents);
    }

    abstract DebugInfoKind getKind();

    abstract int internalAcceptCompareTo(DexDebugInfo var1, CompareToVisitor var2);

    public abstract int getStartLine();

    public abstract int getParameterCount();

    public boolean isEventBasedInfo() {
        return this.getKind() == DebugInfoKind.EVENT_BASED;
    }

    public boolean isPcBasedInfo() {
        return this.getKind() == DebugInfoKind.PC_BASED;
    }

    public EventBasedDebugInfo asEventBasedInfo() {
        return null;
    }

    public PcBasedDebugInfo asPcBasedInfo() {
        return null;
    }

    @Override
    abstract void collectMixedSectionItems(MixedSectionCollection var1);

    @Override
    public abstract DexDebugInfo self();

    @Override
    public StructuralMapping<DexDebugInfo> getStructuralMapping() {
        throw new Unreachable();
    }

    @Override
    public abstract void acceptHashing(HashingVisitor var1);

    @Override
    public int acceptCompareTo(DexDebugInfo other, CompareToVisitor visitor) {
        int diff = visitor.visitInt(this.getKind().ordinal(), other.getKind().ordinal());
        if (diff != 0) {
            return diff;
        }
        return this.internalAcceptCompareTo(other, visitor);
    }

    @Override
    protected final boolean computeEquals(Object other) {
        return Equatable.equalsImpl(this, other);
    }

    private static class WritableEventBasedDebugInfo
    extends EventBasedDebugInfo
    implements DexDebugInfoForWriting {
        private WritableEventBasedDebugInfo(int startLine, DexString[] parameters, DexDebugEvent[] writableEvents) {
            super(startLine, parameters, writableEvents);
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, GraphLens graphLens) {
            super.collectIndexedItems(indexedItems, graphLens);
        }

        @Override
        public void collectMixedSectionItems(MixedSectionCollection collection) {
            collection.add(this);
        }

        @Override
        public int estimatedWriteSize() {
            return LebUtils.sizeAsUleb128(this.startLine) + LebUtils.sizeAsUleb128(this.parameters.length) + this.parameters.length * 4 + this.events.length + 1;
        }

        @Override
        public void write(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putUleb128(this.startLine);
            writer.putUleb128(this.parameters.length);
            for (DexString dexString : this.parameters) {
                writer.putString(dexString);
            }
            for (DexItem dexItem : this.events) {
                ((DexDebugEvent)dexItem).writeOn(writer, mapping, graphLens);
            }
            writer.putByte(0);
        }
    }

    public static class EventBasedDebugInfo
    extends DexDebugInfo {
        public final int startLine;
        public final DexString[] parameters;
        public DexDebugEvent[] events;

        private static void specify(StructuralSpecification<EventBasedDebugInfo, ?> spec) {
            ((StructuralSpecification)((StructuralSpecification)spec.withInt(d -> d.startLine)).withItemArrayAllowingNullMembers(d -> d.parameters)).withItemArray(d -> d.events);
        }

        public EventBasedDebugInfo(int startLine, DexString[] parameters, DexDebugEvent[] events) {
            assert (startLine >= 0);
            this.startLine = startLine;
            this.parameters = parameters;
            this.events = events;
        }

        @Override
        public DexDebugInfo self() {
            return this;
        }

        @Override
        public EventBasedDebugInfo asEventBasedInfo() {
            return this;
        }

        @Override
        DebugInfoKind getKind() {
            return DebugInfoKind.EVENT_BASED;
        }

        @Override
        public int getStartLine() {
            return this.startLine;
        }

        @Override
        public int getParameterCount() {
            return this.parameters.length;
        }

        public List<DexDebugEntry> computeEntries(DexMethod method) {
            DexDebugEntryBuilder builder = new DexDebugEntryBuilder(this.startLine, method);
            for (DexDebugEvent event : this.events) {
                event.accept(builder);
            }
            return builder.build();
        }

        @Override
        public int computeHashCode() {
            return this.startLine + Arrays.hashCode(this.parameters) * 7 + Arrays.hashCode(this.events) * 13;
        }

        @Override
        public void acceptHashing(HashingVisitor visitor) {
            visitor.visit(this, EventBasedDebugInfo::specify);
        }

        @Override
        int internalAcceptCompareTo(DexDebugInfo other, CompareToVisitor visitor) {
            assert (other.isEventBasedInfo());
            return visitor.visit(this, other.asEventBasedInfo(), EventBasedDebugInfo::specify);
        }

        public void collectIndexedItems(IndexedItemCollection indexedItems, GraphLens graphLens) {
            for (DexString dexString : this.parameters) {
                if (dexString == null) continue;
                dexString.collectIndexedItems(indexedItems);
            }
            for (DexItem dexItem : this.events) {
                ((DexDebugEvent)dexItem).collectIndexedItems(indexedItems, graphLens);
            }
        }

        @Override
        void collectMixedSectionItems(MixedSectionCollection collection) {
            throw new Unreachable();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DebugInfo (line " + this.startLine + ") events: [\n");
            for (DexDebugEvent event : this.events) {
                builder.append("  ").append(event).append("\n");
            }
            builder.append("  END_SEQUENCE\n");
            builder.append("]\n");
            return builder.toString();
        }
    }

    public static class PcBasedDebugInfo
    extends DexDebugInfo
    implements DexDebugInfoForWriting {
        private static final int START_LINE = 0;
        private final int parameterCount;
        private final int maxPc;

        private static void specify(StructuralSpecification<PcBasedDebugInfo, ?> spec) {
            ((StructuralSpecification)spec.withInt(d -> d.parameterCount)).withInt(d -> d.maxPc);
        }

        public PcBasedDebugInfo(int parameterCount, int maxPc) {
            this.parameterCount = parameterCount;
            this.maxPc = maxPc;
        }

        public static int estimatedWriteSize(int parameterCount, int maxPc) {
            return LebUtils.sizeAsUleb128(0) + LebUtils.sizeAsUleb128(parameterCount) + parameterCount * LebUtils.sizeAsUleb128(0) + 1 + maxPc + 1;
        }

        @Override
        public int getStartLine() {
            return 0;
        }

        @Override
        public int getParameterCount() {
            return this.parameterCount;
        }

        @Override
        public DexDebugInfo self() {
            return this;
        }

        @Override
        public PcBasedDebugInfo asPcBasedInfo() {
            return this;
        }

        @Override
        DebugInfoKind getKind() {
            return DebugInfoKind.PC_BASED;
        }

        @Override
        protected int computeHashCode() {
            return Objects.hash(this.parameterCount, this.maxPc);
        }

        @Override
        public void acceptHashing(HashingVisitor visitor) {
            visitor.visit(this, PcBasedDebugInfo::specify);
        }

        @Override
        int internalAcceptCompareTo(DexDebugInfo other, CompareToVisitor visitor) {
            assert (other.isPcBasedInfo());
            return visitor.visit(this, other.asPcBasedInfo(), PcBasedDebugInfo::specify);
        }

        @Override
        public void collectMixedSectionItems(MixedSectionCollection collection) {
            collection.add(this);
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems, GraphLens graphLens) {
        }

        @Override
        public int estimatedWriteSize() {
            return PcBasedDebugInfo.estimatedWriteSize(this.parameterCount, this.maxPc);
        }

        @Override
        public void write(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            int i;
            writer.putUleb128(0);
            writer.putUleb128(this.parameterCount);
            for (i = 0; i < this.parameterCount; ++i) {
                writer.putString(null);
            }
            mapping.dexItemFactory().zeroChangeDefaultEvent.writeOn(writer, mapping, graphLens);
            for (i = 0; i < this.maxPc; ++i) {
                mapping.dexItemFactory().oneChangeDefaultEvent.writeOn(writer, mapping, graphLens);
            }
            writer.putByte(0);
        }

        public String toString() {
            return "PcBasedDebugInfo (params: " + this.parameterCount + ", max-pc: " + StringUtils.hexString(this.maxPc, 2) + ")";
        }
    }

    private static enum DebugInfoKind {
        EVENT_BASED,
        PC_BASED;

    }
}

